/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.dialogs;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IconAndMessageDialog;
import org.eclipse.jface.dialogs.ProgressIndicator;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.operation.ModalContext;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;

public class ProgressMonitorDialog
extends IconAndMessageDialog
implements IRunnableContext {
    private static String DEFAULT_TASKNAME = JFaceResources.getString("ProgressMonitorDialog.message");
    private static int LABEL_DLUS = 21;
    private static int BAR_DLUS = 9;
    protected ProgressIndicator progressIndicator;
    protected Label taskLabel;
    protected Label subTaskLabel;
    protected Button cancel;
    protected boolean operationCancelableState = false;
    protected boolean enableCancelButton;
    private ProgressMonitor progressMonitor = new ProgressMonitor();
    private String task;
    private int runningRunnables;
    private Cursor arrowCursor;
    private Cursor waitCursor;

    public ProgressMonitorDialog(Shell parent) {
        super(parent);
        this.setShellStyle(67616);
        this.setBlockOnOpen(false);
    }

    private void asyncSetOperationCancelButtonEnabled(final boolean b) {
        if (this.getShell() != null) {
            this.getShell().getDisplay().asyncExec(new Runnable(){

                public void run() {
                    ProgressMonitorDialog.this.setOperationCancelButtonEnabled(b);
                }
            });
        }
    }

    public boolean close() {
        if (this.runningRunnables <= 0) {
            Shell shell;
            if (this.cancel != null && !this.cancel.isDisposed()) {
                this.cancel.setCursor(null);
            }
            if ((shell = this.getShell()) != null && !shell.isDisposed()) {
                shell.setCursor(null);
            }
            if (this.arrowCursor != null) {
                this.arrowCursor.dispose();
            }
            if (this.waitCursor != null) {
                this.waitCursor.dispose();
            }
            this.arrowCursor = null;
            this.waitCursor = null;
            return super.close();
        }
        return false;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(JFaceResources.getString("ProgressMonitorDialog.title"));
        if (this.waitCursor == null) {
            this.waitCursor = new Cursor((Device)shell.getDisplay(), 1);
        }
        shell.setCursor(this.waitCursor);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.cancel = this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, true);
        if (this.arrowCursor == null) {
            this.arrowCursor = new Cursor((Device)this.cancel.getDisplay(), 0);
        }
        this.cancel.setCursor(this.arrowCursor);
        this.cancel.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                ProgressMonitorDialog.this.cancel.setEnabled(false);
                ProgressMonitorDialog.this.progressMonitor.setCanceled(true);
            }
        });
        this.setOperationCancelButtonEnabled(this.enableCancelButton);
    }

    protected Control createDialogArea(Composite parent) {
        this.setMessage(DEFAULT_TASKNAME);
        this.createMessageArea(parent);
        this.taskLabel = this.messageLabel;
        this.progressIndicator = new ProgressIndicator(parent);
        GridData gd = new GridData();
        gd.heightHint = this.convertVerticalDLUsToPixels(BAR_DLUS);
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 2;
        this.progressIndicator.setLayoutData(gd);
        this.subTaskLabel = new Label(parent, 16448);
        gd = new GridData(768);
        gd.heightHint = this.convertVerticalDLUsToPixels(LABEL_DLUS);
        gd.horizontalSpan = 2;
        this.subTaskLabel.setLayoutData((Object)gd);
        this.subTaskLabel.setFont(parent.getFont());
        return parent;
    }

    protected Point getInitialSize() {
        Point calculatedSize = super.getInitialSize();
        if (calculatedSize.x < 450) {
            calculatedSize.x = 450;
        }
        return calculatedSize;
    }

    public IProgressMonitor getProgressMonitor() {
        return this.progressMonitor;
    }

    public void run(boolean fork, boolean cancelable, IRunnableWithProgress runnable) throws InvocationTargetException, InterruptedException {
        this.setCancelable(cancelable);
        this.open();
        try {
            ++this.runningRunnables;
            this.progressMonitor.forked = fork;
            ModalContext.run(runnable, fork, this.getProgressMonitor(), this.getShell().getDisplay());
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            --this.runningRunnables;
            this.close();
            throw throwable;
        }
        Object var4_6 = null;
        --this.runningRunnables;
        this.close();
    }

    public void setCancelable(boolean cancelable) {
        if (this.cancel == null) {
            this.enableCancelButton = cancelable;
        } else {
            this.asyncSetOperationCancelButtonEnabled(cancelable);
        }
    }

    private void setOperationCancelButtonEnabled(boolean b) {
        this.operationCancelableState = b;
        this.cancel.setEnabled(b);
    }

    protected Image getImage() {
        return JFaceResources.getImageRegistry().get("dialog_info_image");
    }

    private void setMessage(String messageString) {
        this.message = messageString;
        if (this.messageLabel == null || this.messageLabel.isDisposed()) {
            return;
        }
        this.messageLabel.setText(this.message);
    }

    private void update() {
        if (this.messageLabel == null || this.messageLabel.isDisposed()) {
            return;
        }
        this.messageLabel.update();
    }

    private class ProgressMonitor
    implements IProgressMonitor {
        private String fSubTask = "";
        private boolean fIsCanceled;
        protected boolean forked = false;

        ProgressMonitor() {
        }

        public void beginTask(String name, int totalWork) {
            if (ProgressMonitorDialog.this.progressIndicator.isDisposed()) {
                return;
            }
            if (name == null) {
                ProgressMonitorDialog.this.task = "";
            } else {
                ProgressMonitorDialog.this.task = name;
            }
            String s = ProgressMonitorDialog.this.task;
            if (s.length() <= 0) {
                s = DEFAULT_TASKNAME;
            }
            ProgressMonitorDialog.this.setMessage(s);
            if (!this.forked) {
                ProgressMonitorDialog.this.update();
            }
            if (totalWork == -1) {
                ProgressMonitorDialog.this.progressIndicator.beginAnimatedTask();
            } else {
                ProgressMonitorDialog.this.progressIndicator.beginTask(totalWork);
            }
        }

        public void done() {
            if (!ProgressMonitorDialog.this.progressIndicator.isDisposed()) {
                ProgressMonitorDialog.this.progressIndicator.sendRemainingWork();
                ProgressMonitorDialog.this.progressIndicator.done();
            }
        }

        public void setTaskName(String name) {
            if (name == null) {
                ProgressMonitorDialog.this.task = "";
            } else {
                ProgressMonitorDialog.this.task = name;
            }
            String s = ProgressMonitorDialog.this.task;
            if (s.length() <= 0) {
                s = DEFAULT_TASKNAME;
            }
            ProgressMonitorDialog.this.setMessage(s);
            if (!this.forked) {
                ProgressMonitorDialog.this.update();
            }
        }

        public boolean isCanceled() {
            return this.fIsCanceled;
        }

        public void setCanceled(boolean b) {
            this.fIsCanceled = b;
        }

        public void subTask(String name) {
            if (ProgressMonitorDialog.this.subTaskLabel.isDisposed()) {
                return;
            }
            this.fSubTask = name == null ? "" : name;
            ProgressMonitorDialog.this.subTaskLabel.setText(this.fSubTask);
            if (!this.forked) {
                ProgressMonitorDialog.this.subTaskLabel.update();
            }
        }

        public void worked(int work) {
            this.internalWorked(work);
        }

        public void internalWorked(double work) {
            if (!ProgressMonitorDialog.this.progressIndicator.isDisposed()) {
                ProgressMonitorDialog.this.progressIndicator.worked(work);
            }
        }
    }
}

