/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.viewers;

import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ICellEditorListener;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Item;

abstract class TableViewerImpl {
    private boolean isActivating = false;
    private CellEditor cellEditor;
    private CellEditor[] cellEditors;
    private ICellModifier cellModifier;
    private String[] columnProperties;
    private Item tableItem;
    private int columnNumber;
    private ICellEditorListener cellEditorListener;
    private FocusListener focusListener;

    TableViewerImpl() {
        this.initCellEditorListener();
    }

    private void activateCellEditor() {
        String property;
        Object element;
        if (this.cellEditors != null && this.cellEditors[this.columnNumber] != null && this.cellModifier != null && this.cellModifier.canModify(element = this.tableItem.getData(), property = this.columnProperties[this.columnNumber])) {
            this.cellEditor = this.cellEditors[this.columnNumber];
            this.cellEditor.addListener(this.cellEditorListener);
            Object value = this.cellModifier.getValue(element, property);
            this.cellEditor.setValue(value);
            Control control = this.cellEditor.getControl();
            this.cellEditor.activate();
            if (control == null) {
                return;
            }
            this.setLayoutData(this.cellEditor.getLayoutData());
            this.setEditor(control, this.tableItem, this.columnNumber);
            this.cellEditor.setFocus();
            if (this.focusListener == null) {
                this.focusListener = new FocusAdapter(){

                    public void focusLost(FocusEvent e) {
                        TableViewerImpl.this.applyEditorValue();
                    }
                };
            }
            control.addFocusListener(this.focusListener);
        }
    }

    private void activateCellEditor(MouseEvent event) {
        int columnToEdit;
        if (this.tableItem == null || this.tableItem.isDisposed()) {
            return;
        }
        int columns = this.getColumnCount();
        if (columns == 0) {
            columnToEdit = 0;
        } else {
            columnToEdit = -1;
            int i = 0;
            while (i < columns) {
                Rectangle bounds = this.getBounds(this.tableItem, i);
                if (bounds.contains(event.x, event.y)) {
                    columnToEdit = i;
                    break;
                }
                ++i;
            }
            if (columnToEdit == -1) {
                return;
            }
        }
        this.columnNumber = columnToEdit;
        this.activateCellEditor();
    }

    public void applyEditorValue() {
        CellEditor c = this.cellEditor;
        if (c != null) {
            this.cellEditor = null;
            Item t = this.tableItem;
            if (t != null && !t.isDisposed()) {
                this.saveEditorValue(c, t);
            }
            this.setEditor(null, null, 0);
            c.removeListener(this.cellEditorListener);
            c.deactivate();
        }
    }

    public void cancelEditing() {
        if (this.cellEditor != null) {
            this.setEditor(null, null, 0);
            this.cellEditor.removeListener(this.cellEditorListener);
            CellEditor oldEditor = this.cellEditor;
            this.cellEditor = null;
            oldEditor.deactivate();
        }
    }

    public void editElement(Object element, int column) {
        if (this.cellEditor != null) {
            this.applyEditorValue();
        }
        this.setSelection(new StructuredSelection(element), true);
        Item[] selection = this.getSelection();
        if (selection.length != 1) {
            return;
        }
        this.tableItem = selection[0];
        this.showSelection();
        this.columnNumber = column;
        this.activateCellEditor();
    }

    abstract Rectangle getBounds(Item var1, int var2);

    public CellEditor[] getCellEditors() {
        return this.cellEditors;
    }

    public ICellModifier getCellModifier() {
        return this.cellModifier;
    }

    abstract int getColumnCount();

    public Object[] getColumnProperties() {
        return this.columnProperties;
    }

    abstract Item[] getSelection();

    public void handleMouseDoubleClick(MouseEvent event) {
        this.isActivating = false;
    }

    public void handleMouseDown(MouseEvent event) {
        Item[] items;
        if (event.button != 1) {
            return;
        }
        boolean wasActivated = this.isCellEditorActive();
        if (wasActivated) {
            this.applyEditorValue();
        }
        if ((items = this.getSelection()).length != 1) {
            this.tableItem = null;
            return;
        }
        if (this.tableItem != items[0]) {
            this.tableItem = items[0];
            return;
        }
        if (this.isActivating || wasActivated) {
            return;
        }
        this.isActivating = true;
        this.postActivation(event);
    }

    private void initCellEditorListener() {
        this.cellEditorListener = new ICellEditorListener(){

            public void editorValueChanged(boolean oldValidState, boolean newValidState) {
            }

            public void cancelEditor() {
                TableViewerImpl.this.cancelEditing();
            }

            public void applyEditorValue() {
                TableViewerImpl.this.applyEditorValue();
            }
        };
    }

    public boolean isCellEditorActive() {
        return this.cellEditor != null;
    }

    private void postActivation(final MouseEvent event) {
        if (!this.isActivating) {
            return;
        }
        new Thread(){

            public void run() {
                try {
                    Thread.sleep(400L);
                }
                catch (Exception exception) {}
                if (TableViewerImpl.this.isActivating) {
                    Display.getDefault().asyncExec(new Runnable(this, event){
                        private final /* synthetic */ MouseEvent val$event;
                        private final /* synthetic */ 3 this$1;
                        {
                            this.this$1 = var1_1;
                            this.val$event = mouseEvent;
                        }

                        public void run() {
                            TableViewerImpl.access$1(3.access$0(this.this$1), this.val$event);
                            TableViewerImpl.access$2(3.access$0(this.this$1), false);
                        }
                    });
                }
            }

            static /* synthetic */ TableViewerImpl access$0(3 var0) {
                return var0.TableViewerImpl.this;
            }
        }.start();
    }

    private void saveEditorValue(CellEditor cellEditor, Item tableItem) {
        if (this.cellModifier != null) {
            cellEditor.isValueValid();
            String property = null;
            if (this.columnProperties != null && this.columnNumber < this.columnProperties.length) {
                property = this.columnProperties[this.columnNumber];
            }
            this.cellModifier.modify(tableItem, property, cellEditor.getValue());
        }
    }

    public void setCellEditors(CellEditor[] editors) {
        this.cellEditors = editors;
    }

    public void setCellModifier(ICellModifier modifier) {
        this.cellModifier = modifier;
    }

    public void setColumnProperties(String[] columnProperties) {
        this.columnProperties = columnProperties;
    }

    abstract void setEditor(Control var1, Item var2, int var3);

    abstract void setLayoutData(CellEditor.LayoutData var1);

    abstract void setSelection(StructuredSelection var1, boolean var2);

    abstract void showSelection();

    static /* synthetic */ void access$1(TableViewerImpl tableViewerImpl, MouseEvent mouseEvent) {
        tableViewerImpl.activateCellEditor(mouseEvent);
    }

    static /* synthetic */ void access$2(TableViewerImpl tableViewerImpl, boolean bl) {
        tableViewerImpl.isActivating = bl;
    }
}

