/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.excalibur.packagemanager.impl;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.apache.avalon.excalibur.extension.Extension;
import org.apache.avalon.excalibur.packagemanager.ExtensionManager;
import org.apache.avalon.excalibur.packagemanager.OptionalPackage;
import org.apache.avalon.excalibur.packagemanager.impl.OptionalPackageComparator;

public class DefaultExtensionManager
implements ExtensionManager {
    private static final boolean DEBUG = false;
    private static final String SEPARATOR = "|";
    private final Map m_packages = new HashMap();
    private File[] m_path;
    private boolean m_needToScan;

    public DefaultExtensionManager() {
        this(new File[0]);
    }

    public DefaultExtensionManager(File[] path) {
        this.setPath(path);
    }

    public File[] getPaths() {
        return this.m_path;
    }

    public synchronized OptionalPackage[] getOptionalPackages(Extension extension) {
        if (this.m_needToScan) {
            this.scanPath();
        }
        ArrayList<OptionalPackage> results = new ArrayList<OptionalPackage>();
        ArrayList candidates = (ArrayList)this.m_packages.get(extension.getExtensionName());
        if (null != candidates) {
            int size = candidates.size();
            int i = 0;
            while (i < size) {
                OptionalPackage optionalPackage = (OptionalPackage)candidates.get(i);
                Extension[] extensions = optionalPackage.getAvailableExtensions();
                int j = 0;
                while (j < extensions.length) {
                    if (extensions[j].isCompatibleWith(extension)) {
                        results.add(optionalPackage);
                    }
                    ++j;
                }
                ++i;
            }
        }
        OptionalPackageComparator comparator = new OptionalPackageComparator(extension.getExtensionName());
        Collections.sort(results, comparator);
        return results.toArray(new OptionalPackage[0]);
    }

    protected synchronized OptionalPackage[] getAllOptionalPackages() {
        ArrayList<OptionalPackage> packages = new ArrayList<OptionalPackage>();
        Iterator iterator = this.m_packages.values().iterator();
        while (iterator.hasNext()) {
            ArrayList list = (ArrayList)iterator.next();
            int size = list.size();
            int i = 0;
            while (i < size) {
                OptionalPackage optionalPackage = (OptionalPackage)list.get(i);
                if (!packages.contains(optionalPackage)) {
                    packages.add(optionalPackage);
                }
                ++i;
            }
        }
        return packages.toArray(new OptionalPackage[packages.size()]);
    }

    protected void addPathElements(String[] pathElements) {
        File[] path = this.toFiles(pathElements);
        this.addPathElements(path);
    }

    protected synchronized void addPathElements(File[] path) {
        this.validatePath(path);
        File[] files = this.resolvePath(path);
        this.m_path = this.mergePaths(files);
        this.m_needToScan = true;
    }

    protected void addPathElements(String pathString) {
        String[] pathElements = DefaultExtensionManager.split(pathString, SEPARATOR);
        this.addPathElements(pathElements);
    }

    protected synchronized void setPath(String pathString) {
        String[] pathElements = DefaultExtensionManager.split(pathString, SEPARATOR);
        this.setPath(pathElements);
    }

    protected synchronized void setPath(String[] pathElements) {
        File[] path = this.toFiles(pathElements);
        this.setPath(path);
    }

    protected synchronized void setPath(File[] path) {
        this.validatePath(path);
        this.m_path = this.resolvePath(path);
        this.m_needToScan = true;
    }

    protected final synchronized void scanPath() {
        this.clearCache();
        int i = 0;
        while (i < this.m_path.length) {
            this.scanDirectory(this.m_path[i]);
            ++i;
        }
    }

    private synchronized void scanDirectory(File directory) {
        File[] files = directory.listFiles();
        int i = 0;
        while (i < files.length) {
            String message;
            File file = files[i];
            String name = file.getName();
            if (!name.endsWith(".jar")) {
                message = "Skipping " + file + " as it does not end with '.jar'";
                this.debug(message);
            } else if (!file.isFile()) {
                message = "Skipping " + file + " as it is not a file.";
                this.debug(message);
            } else if (!file.canRead()) {
                message = "Skipping " + file + " as it is not readable.";
                this.debug(message);
            } else {
                try {
                    OptionalPackage optionalPackage = this.getOptionalPackage(file);
                    this.cacheOptionalPackage(optionalPackage);
                }
                catch (IOException ioe) {
                    String message2 = "Skipping " + file + " as it could not be loaded " + "due to " + ioe;
                    this.debug(message2);
                }
            }
            ++i;
        }
    }

    protected final synchronized void clearCache() {
        this.m_packages.clear();
        this.m_needToScan = true;
    }

    protected final synchronized void cacheOptionalPackage(OptionalPackage optionalPackage) {
        this.m_needToScan = false;
        if (optionalPackage.getAvailableExtensions().length == 0) {
            return;
        }
        Extension extension = optionalPackage.getAvailableExtensions()[0];
        ArrayList<OptionalPackage> candidates = (ArrayList<OptionalPackage>)this.m_packages.get(extension.getExtensionName());
        if (null == candidates) {
            candidates = new ArrayList<OptionalPackage>();
            this.m_packages.put(extension.getExtensionName(), candidates);
        }
        candidates.add(optionalPackage);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OptionalPackage getOptionalPackage(File archive) throws IOException {
        Manifest manifest;
        JarFile jarFile;
        File file;
        block3: {
            OptionalPackage optionalPackage;
            file = archive.getCanonicalFile();
            jarFile = new JarFile(file);
            try {
                manifest = jarFile.getManifest();
                if (null != manifest) break block3;
                optionalPackage = null;
                Object var9_7 = null;
            }
            catch (Throwable throwable) {
                Object var9_9 = null;
                jarFile.close();
                throw throwable;
            }
            jarFile.close();
            return optionalPackage;
        }
        Extension[] available = Extension.getAvailable(manifest);
        Extension[] required = Extension.getRequired(manifest);
        OptionalPackage optionalPackage = new OptionalPackage(file, available, required);
        Object var9_8 = null;
        jarFile.close();
        return optionalPackage;
    }

    protected void debug(String message) {
    }

    private File[] resolvePath(File[] path) {
        File[] resultPath = new File[path.length];
        int i = 0;
        while (i < path.length) {
            resultPath[i] = this.resolveFile(path[i]);
            ++i;
        }
        return resultPath;
    }

    private File resolveFile(File file) {
        try {
            return file.getCanonicalFile();
        }
        catch (IOException e) {
            return file.getAbsoluteFile();
        }
    }

    private void validatePath(File[] path) {
        if (null == path) {
            throw new NullPointerException("path");
        }
        int i = 0;
        while (i < path.length) {
            this.validatePathElement(path[i]);
            ++i;
        }
    }

    private void validatePathElement(File file) {
        if (!file.exists() || !file.isDirectory()) {
            String message = "path element " + file + " must exist and must be a directory";
            throw new IllegalArgumentException(message);
        }
    }

    private File[] mergePaths(File[] files) {
        File[] resultPath = new File[this.m_path.length + files.length];
        System.arraycopy(this.m_path, 0, resultPath, 0, this.m_path.length);
        System.arraycopy(files, this.m_path.length, resultPath, 0, files.length);
        return resultPath;
    }

    private File[] toFiles(String[] pathElements) {
        File[] path = new File[pathElements.length];
        int i = 0;
        while (i < path.length) {
            path[i] = new File(pathElements[i]);
            ++i;
        }
        return path;
    }

    private static String[] split(String string, String onToken) {
        StringTokenizer tokenizer = new StringTokenizer(string, onToken);
        String[] result = new String[tokenizer.countTokens()];
        int i = 0;
        while (i < result.length) {
            result[i] = tokenizer.nextToken();
            ++i;
        }
        return result;
    }
}

