/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.visitclass.BetterVisitor;
import edu.umd.cs.findbugs.visitclass.Constants2;
import edu.umd.cs.findbugs.visitclass.DismantleBytecode;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;

public class FindReturnRef
extends BytecodeScanningDetector
implements Constants2 {
    boolean check = false;
    boolean thisOnTOS = false;
    boolean fieldOnTOS = false;
    boolean staticMethod = false;
    String nameOnStack;
    String classNameOnStack;
    String sigOnStack;
    boolean fieldIsStatic;
    private BugReporter bugReporter;

    public FindReturnRef(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    public void visit(JavaClass obj) {
        super.visit(obj);
    }

    public void visit(Method obj) {
        this.check = (obj.getAccessFlags() & 1) != 0;
        boolean bl = this.staticMethod = (obj.getAccessFlags() & 8) != 0;
        if (this.check) {
            super.visit(obj);
        }
        this.thisOnTOS = false;
        this.fieldOnTOS = false;
    }

    public void sawOpcode(int seen) {
        if (seen == 42) {
            this.thisOnTOS = true;
            this.fieldOnTOS = false;
            return;
        }
        if (this.thisOnTOS && seen == 180 && this.classConstant == this.className) {
            this.fieldOnTOS = true;
            this.thisOnTOS = false;
            this.nameOnStack = this.nameConstant;
            this.classNameOnStack = this.betterClassConstant;
            this.sigOnStack = this.sigConstant;
            this.fieldIsStatic = false;
            return;
        }
        if (seen == 178 && this.classConstant == this.className) {
            this.fieldOnTOS = true;
            this.thisOnTOS = false;
            this.nameOnStack = this.nameConstant;
            this.classNameOnStack = this.betterClassConstant;
            this.sigOnStack = this.sigConstant;
            this.fieldIsStatic = true;
            return;
        }
        this.thisOnTOS = false;
        if (this.check && this.fieldOnTOS && seen == 176 && !this.sigOnStack.equals("Ljava/lang/String;") && this.sigOnStack.indexOf("Exception") == -1 && this.sigOnStack.indexOf("[") >= 0) {
            this.bugReporter.reportBug(new BugInstance(this.staticMethod ? "MS_EXPOSE_REP" : "EI_EXPOSE_REP", 2).addClassAndMethod((BetterVisitor)this).addField(this.classNameOnStack, this.nameOnStack, this.sigOnStack, this.fieldIsStatic).addSourceLine((DismantleBytecode)this));
        }
        this.fieldOnTOS = false;
        this.thisOnTOS = false;
    }
}

