/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.visitclass.Constants2;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import org.apache.bcel.classfile.Field;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;

public class MutableStaticFields
extends BytecodeScanningDetector
implements Constants2 {
    LinkedList<FieldRecord> seen = new LinkedList();
    boolean publicClass;
    boolean zeroOnTOS;
    boolean emptyArrayOnTOS;
    boolean inStaticInitializer;
    String packageName;
    HashSet<String> unsafeValue = new HashSet();
    HashSet<String> interfaces = new HashSet();
    HashSet<String> notFinal = new HashSet();
    HashSet<String> outsidePackage = new HashSet();
    private BugReporter bugReporter;

    static String extractPackage(String c) {
        int i = c.lastIndexOf(47);
        if (i < 0) {
            return "";
        }
        return c.substring(0, i);
    }

    static boolean mutableSignature(String sig) {
        return sig.equals("Ljava/util/Hashtable;") || sig.charAt(0) == '[';
    }

    public MutableStaticFields(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    public void visit(JavaClass obj) {
        super.visit(obj);
        int flags = obj.getAccessFlags();
        boolean bl = this.publicClass = (flags & 1) != 0 && !this.betterClassName.startsWith("sun.");
        if ((flags & 0x200) != 0) {
            this.interfaces.add(this.betterClassName);
        }
        this.packageName = MutableStaticFields.extractPackage(this.className);
    }

    public void visit(Method obj) {
        this.zeroOnTOS = false;
        this.inStaticInitializer = this.methodName.equals("<clinit>");
    }

    public void sawOpcode(int seen) {
        switch (seen) {
            case 178: 
            case 179: {
                String packageConstant = MutableStaticFields.extractPackage(this.classConstant);
                boolean samePackage = this.packageName.equals(MutableStaticFields.extractPackage(this.classConstant));
                boolean initOnly = seen == 178 || this.className.equals(this.classConstant) && this.inStaticInitializer;
                boolean safeValue = seen == 178 || this.emptyArrayOnTOS || !MutableStaticFields.mutableSignature(this.sigConstant);
                String name = (this.classConstant + "." + this.nameConstant).replace('/', '.');
                if (!samePackage) {
                    this.outsidePackage.add(name);
                }
                if (!initOnly) {
                    this.notFinal.add(name);
                }
                if (safeValue) break;
                this.unsafeValue.add(name);
                break;
            }
            case 188: 
            case 189: {
                if (this.zeroOnTOS) {
                    this.emptyArrayOnTOS = true;
                }
                this.zeroOnTOS = false;
                return;
            }
            case 3: {
                this.zeroOnTOS = true;
                this.emptyArrayOnTOS = false;
                return;
            }
        }
        this.zeroOnTOS = false;
        this.emptyArrayOnTOS = false;
    }

    public void visit(Field obj) {
        boolean isArray;
        boolean isProtected;
        boolean isStatic;
        super.visit(obj);
        int flags = obj.getAccessFlags();
        boolean bl = isStatic = (flags & 8) != 0;
        if (!isStatic) {
            return;
        }
        boolean isFinal = (flags & 0x10) != 0;
        boolean isPublic = this.publicClass && (flags & 1) != 0;
        boolean bl2 = isProtected = this.publicClass && (flags & 4) != 0;
        if (!isPublic && !isProtected) {
            return;
        }
        boolean isHashtable = this.fieldSig.equals("Ljava/util/Hashtable;");
        boolean bl3 = isArray = this.fieldSig.charAt(0) == '[';
        if (isFinal && !isHashtable && !isArray) {
            return;
        }
        FieldRecord f = new FieldRecord();
        f.className = this.betterClassName;
        f.name = this.fieldName;
        f.signature = this.betterFieldSig;
        f.isPublic = isPublic;
        f.isFinal = isFinal;
        this.seen.add(f);
    }

    public void report() {
        Iterator i = this.seen.iterator();
        while (i.hasNext()) {
            String bugType;
            boolean isArray;
            FieldRecord f = (FieldRecord)i.next();
            boolean isFinal = f.isFinal;
            String className = f.className;
            String fieldSig = f.signature;
            String fieldName = f.name;
            String name = className + "." + fieldName;
            boolean couldBeFinal = !isFinal && !this.notFinal.contains(name);
            boolean isPublic = f.isPublic;
            boolean couldBePackage = !this.outsidePackage.contains(name);
            boolean movedOutofInterface = couldBePackage && this.interfaces.contains(className);
            boolean isHashtable = fieldSig.equals("Ljava/util/Hashtable;");
            boolean bl = isArray = fieldSig.charAt(0) == '[' && this.unsafeValue.contains(name);
            if (isFinal && !isHashtable && !isArray) continue;
            if (movedOutofInterface) {
                bugType = "MS_OOI_PKGPROTECT";
            } else if (couldBePackage && couldBeFinal && (isHashtable || isArray)) {
                bugType = "MS_FINAL_PKGPROTECT";
            } else if (couldBeFinal && !isHashtable && !isArray) {
                bugType = "MS_SHOULD_BE_FINAL";
            } else if (couldBePackage) {
                bugType = "MS_PKGPROTECT";
            } else if (isHashtable) {
                bugType = "MS_MUTABLE_HASHTABLE";
            } else if (isArray) {
                bugType = "MS_MUTABLE_ARRAY";
            } else if (!isFinal) {
                bugType = "MS_CANNOT_BE_FINAL";
            } else {
                throw new RuntimeException("impossible");
            }
            this.bugReporter.reportBug(new BugInstance(bugType, 2).addClass(className).addField(className, fieldName, fieldSig, true));
        }
    }

    static class FieldRecord {
        String className;
        String name;
        String signature;
        boolean isPublic;
        boolean isFinal;

        FieldRecord() {
        }
    }
}

