/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.visitclass.BetterVisitor;
import edu.umd.cs.findbugs.visitclass.Constants2;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.bcel.Repository;
import org.apache.bcel.classfile.Attribute;
import org.apache.bcel.classfile.Field;
import org.apache.bcel.classfile.FieldOrMethod;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.classfile.Synthetic;
import org.apache.bcel.classfile.Visitor;

public class SerializableIdiom
extends PreorderVisitor
implements Detector,
Constants2 {
    boolean sawSerialVersionUID;
    boolean isSerializable;
    boolean implementsSerializableDirectly;
    boolean isGUIClass;
    boolean foundSynthetic;
    boolean foundSynchronizedMethods;
    boolean writeObjectIsSynchronized;
    private BugReporter bugReporter;
    boolean isAbstract;
    private List<BugInstance> fieldWarningList = new LinkedList<BugInstance>();
    private boolean sawReadExternal;
    private boolean sawWriteExternal;
    private boolean sawReadObject;
    private boolean sawWriteObject;

    public SerializableIdiom(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    public void visitClassContext(ClassContext classContext) {
        classContext.getJavaClass().accept((Visitor)this);
        this.flush();
    }

    private void flush() {
        if (!(this.isAbstract || this.sawReadExternal && this.sawWriteExternal || this.sawReadObject && this.sawWriteObject)) {
            Iterator<BugInstance> i = this.fieldWarningList.iterator();
            while (i.hasNext()) {
                this.bugReporter.reportBug(i.next());
            }
        }
        this.fieldWarningList.clear();
    }

    public void report() {
    }

    public void visit(JavaClass obj) {
        int flags = obj.getAccessFlags();
        this.isAbstract = (flags & 0x400) != 0 || (flags & 0x200) != 0;
        this.sawSerialVersionUID = false;
        this.implementsSerializableDirectly = false;
        this.isSerializable = false;
        this.isGUIClass = false;
        String[] interface_names = obj.getInterfaceNames();
        for (int i = 0; i < interface_names.length; ++i) {
            if (!interface_names[i].equals("java.io.Serializable")) continue;
            this.implementsSerializableDirectly = true;
            this.isSerializable = true;
            break;
        }
        if (!this.isSerializable) {
            try {
                if (Repository.instanceOf((JavaClass)obj, (String)"java.io.Serializable")) {
                    this.isSerializable = true;
                }
                if (Repository.instanceOf((JavaClass)obj, (String)"java.rmi.Remote")) {
                    this.isSerializable = false;
                }
            }
            catch (ClassNotFoundException e) {
                this.bugReporter.reportMissingClass(e);
            }
        }
        try {
            this.isGUIClass = Repository.instanceOf((JavaClass)obj, (String)"java.awt.Component");
        }
        catch (ClassNotFoundException e) {
            this.bugReporter.reportMissingClass(e);
        }
        this.foundSynthetic = false;
        this.foundSynchronizedMethods = false;
        this.writeObjectIsSynchronized = false;
        this.sawWriteObject = false;
        this.sawReadObject = false;
        this.sawWriteExternal = false;
        this.sawReadExternal = false;
    }

    public void visitAfter(JavaClass obj) {
        int priority;
        int n = priority = this.isGUIClass ? 3 : 2;
        if (this.foundSynthetic && this.isSerializable && !this.isAbstract && !this.sawSerialVersionUID) {
            this.bugReporter.reportBug(new BugInstance("SE_NO_SERIALVERSIONID", priority).addClass((BetterVisitor)this));
        }
        if (this.writeObjectIsSynchronized && !this.foundSynchronizedMethods) {
            this.bugReporter.reportBug(new BugInstance("WS_WRITEOBJECT_SYNC", priority).addClass((BetterVisitor)this));
        }
    }

    public void visit(Method obj) {
        boolean isSynchronized;
        int accessFlags = obj.getAccessFlags();
        boolean bl = isSynchronized = (accessFlags & 0x20) != 0;
        if (!this.methodName.equals("<init>") && this.isSynthetic((FieldOrMethod)obj)) {
            this.foundSynthetic = true;
        }
        if (this.methodName.equals("readExternal")) {
            this.sawReadExternal = true;
        } else if (this.methodName.equals("writeExternal")) {
            this.sawWriteExternal = true;
        } else if (this.methodName.equals("readObject")) {
            this.sawReadObject = true;
        } else if (this.methodName.equals("writeObject")) {
            this.sawWriteObject = true;
        }
        if (!isSynchronized) {
            return;
        }
        if (this.methodName.equals("readObject") && this.methodSig.equals("(Ljava/io/ObjectInputStream;)V") && this.isSerializable) {
            this.bugReporter.reportBug(new BugInstance("RS_READOBJECT_SYNC", 2).addClass((BetterVisitor)this));
        } else if (this.methodName.equals("writeObject")) {
            this.writeObjectIsSynchronized = true;
        } else {
            this.foundSynchronizedMethods = true;
        }
    }

    boolean isSynthetic(FieldOrMethod obj) {
        Attribute[] a = obj.getAttributes();
        for (int i = 0; i < a.length; ++i) {
            if (!(a[i] instanceof Synthetic)) continue;
            return true;
        }
        return false;
    }

    public void visit(Field obj) {
        int flags = obj.getAccessFlags();
        if (this.className.indexOf("ObjectStreamClass") == -1 && this.isSerializable && this.fieldSig.indexOf("L") >= 0 && !obj.isTransient() && !obj.isStatic()) {
            try {
                String fieldClassName = this.fieldSig.substring(this.fieldSig.indexOf("L") + 1, this.fieldSig.length() - 1).replace('/', '.');
                JavaClass fieldClass = Repository.lookupClass((String)fieldClassName);
                if (!(fieldClassName.equals("java.lang.Object") || Repository.instanceOf((JavaClass)fieldClass, (String)"java.io.Serializable") || Repository.instanceOf((JavaClass)fieldClass, (String)"java.io.Externalizable"))) {
                    int priority = this.isGUIClass && !this.implementsSerializableDirectly ? 3 : (this.implementsSerializableDirectly ? 1 : 2);
                    if (fieldClass.isInterface() || fieldClass.isAbstract()) {
                        priority = Math.max(3, priority + 1);
                        if (Repository.instanceOf((JavaClass)fieldClass, (String)"java.util.Collection")) {
                            return;
                        }
                    }
                    this.fieldWarningList.add(new BugInstance("SE_BAD_FIELD", priority).addClass(this.thisClass.getClassName()).addField(fieldClassName, obj.getName(), this.fieldSig, false).addUnknownSourceLine(this.thisClass.getClassName(), this.thisClass.getSourceFileName()));
                }
            }
            catch (ClassNotFoundException e) {
                this.bugReporter.reportMissingClass(e);
            }
        }
        if (!this.fieldName.startsWith("this") && this.isSynthetic((FieldOrMethod)obj)) {
            this.foundSynthetic = true;
        }
        if (!this.fieldName.equals("serialVersionUID")) {
            return;
        }
        int mask = 24;
        if (!this.fieldSig.equals("I") && !this.fieldSig.equals("J")) {
            return;
        }
        if ((flags & mask) == mask && this.fieldSig.equals("I")) {
            this.bugReporter.reportBug(new BugInstance("SE_NONLONG_SERIALVERSIONID", 3).addClass((BetterVisitor)this).addVisitedField((BetterVisitor)this));
            this.sawSerialVersionUID = true;
            return;
        }
        if ((flags & 8) == 0) {
            this.bugReporter.reportBug(new BugInstance("SE_NONSTATIC_SERIALVERSIONID", 2).addClass((BetterVisitor)this).addVisitedField((BetterVisitor)this));
            return;
        }
        if ((flags & 0x10) == 0) {
            this.bugReporter.reportBug(new BugInstance("SE_NONFINAL_SERIALVERSIONID", 2).addClass((BetterVisitor)this).addVisitedField((BetterVisitor)this));
            return;
        }
        this.sawSerialVersionUID = true;
    }
}

