/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.visitclass.BetterVisitor;
import edu.umd.cs.findbugs.visitclass.Constants2;
import org.apache.bcel.classfile.Code;

public class WaitInLoop
extends BytecodeScanningDetector
implements Constants2 {
    boolean sawWait = false;
    boolean waitHasTimeout = false;
    boolean sawNotify = false;
    int notifyPC;
    int earliestJump = 0;
    int waitAt = 0;
    private BugReporter bugReporter;

    public WaitInLoop(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    public void visit(Code obj) {
        this.sawWait = false;
        this.waitHasTimeout = false;
        this.sawNotify = false;
        this.earliestJump = 9999999;
        super.visit(obj);
        if (this.sawWait && this.waitAt < this.earliestJump) {
            this.bugReporter.reportBug(new BugInstance("WA_NOT_IN_LOOP", this.waitHasTimeout ? 3 : 2).addClassAndMethod((BetterVisitor)this).addSourceLine((BetterVisitor)this, this.waitAt));
        }
        if (this.sawNotify) {
            this.bugReporter.reportBug(new BugInstance("NO_NOTIFY_NOT_NOTIFYALL", 2).addClassAndMethod((BetterVisitor)this).addSourceLine((BetterVisitor)this, this.notifyPC));
        }
    }

    public void sawOpcode(int seen) {
        if ((seen == 182 || seen == 185) && this.nameConstant.equals("notify") && this.sigConstant.equals("()V")) {
            this.sawNotify = true;
            this.notifyPC = this.PC;
        }
        if (!this.sawWait && (seen == 182 || seen == 185) && this.nameConstant.equals("wait") && (this.sigConstant.equals("()V") || this.sigConstant.equals("(J)V") || this.sigConstant.equals("(JI)V"))) {
            this.sawWait = true;
            this.waitHasTimeout = !this.sigConstant.equals("()V");
            this.waitAt = this.PC;
            this.earliestJump = this.PC + 1;
            return;
        }
        if (seen >= 153 && seen <= 167 || seen >= 198 && seen <= 200) {
            this.earliestJump = Math.min(this.earliestJump, this.branchTarget);
        }
    }
}

