/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.console.util;

import java.io.Serializable;
import org.apache.geronimo.gbean.AbstractName;
import org.apache.geronimo.kernel.config.ConfigurationModuleType;
import org.apache.geronimo.kernel.management.State;
import org.apache.geronimo.kernel.repository.Artifact;

public class ConfigurationData
implements Serializable,
Comparable {
    private final Artifact configID;
    private final State state;
    private final AbstractName parentName;
    private final String childName;
    private final ConfigurationModuleType type;
    private final AbstractName moduleBeanName;

    public ConfigurationData(Artifact configID, AbstractName parentName, String childName, State state, ConfigurationModuleType type, AbstractName moduleBeanName) {
        this.configID = configID;
        this.childName = childName;
        this.parentName = parentName;
        this.state = state;
        this.type = type;
        this.moduleBeanName = moduleBeanName;
    }

    public boolean isChild() {
        return this.childName != null;
    }

    public String getChildName() {
        return this.childName;
    }

    public AbstractName getModuleBeanName() {
        return this.moduleBeanName;
    }

    public AbstractName getParentName() {
        return this.parentName;
    }

    public State getState() {
        return this.state;
    }

    public ConfigurationModuleType getType() {
        return this.type;
    }

    public Artifact getConfigID() {
        return this.configID;
    }

    public boolean isRunning() {
        return this.state.toInt() == 1;
    }

    public int compareTo(Object o) {
        ConfigurationData other = (ConfigurationData)o;
        int test = this.getParentName().toString().compareTo(other.getParentName().toString());
        if (test == 0) {
            if (this.getChildName() != null && other.getChildName() != null) {
                return this.getChildName().compareTo(other.getChildName());
            }
            if (this.getChildName() == null && other.getChildName() == null) {
                return 0;
            }
            return this.getChildName() == null ? 1 : -1;
        }
        return test;
    }
}

