/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.jetty;

import java.util.HashMap;
import java.util.Map;
import javax.management.j2ee.statistics.Stats;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoBuilder;
import org.apache.geronimo.gbean.GBeanLifecycle;
import org.apache.geronimo.jetty.InternalJAASJettyRealm;
import org.apache.geronimo.jetty.JettyContainer;
import org.apache.geronimo.jetty.JettyEJBWebServiceContext;
import org.apache.geronimo.jetty.JettyServer;
import org.apache.geronimo.jetty.JettyWebContainerStatsImpl;
import org.apache.geronimo.management.StatisticsProvider;
import org.apache.geronimo.management.geronimo.NetworkConnector;
import org.apache.geronimo.management.geronimo.WebManager;
import org.apache.geronimo.webservices.SoapHandler;
import org.apache.geronimo.webservices.WebServiceContainer;
import org.mortbay.http.HttpContext;
import org.mortbay.http.HttpListener;
import org.mortbay.http.RequestLog;
import org.mortbay.jetty.Server;

public class JettyContainerImpl
implements JettyContainer,
SoapHandler,
GBeanLifecycle,
StatisticsProvider {
    private final Server server;
    private final Map webServices = new HashMap();
    private final String objectName;
    private final WebManager manager;
    private JettyWebContainerStatsImpl stats;
    private final Map realms = new HashMap();
    public static final GBeanInfo GBEAN_INFO;

    public JettyContainerImpl(String objectName, WebManager manager) {
        this.objectName = objectName;
        this.server = new JettyServer();
        this.stats = new JettyWebContainerStatsImpl();
        this.manager = manager;
    }

    public String getObjectName() {
        return this.objectName;
    }

    public boolean isStateManageable() {
        return true;
    }

    public boolean isStatisticsProvider() {
        return true;
    }

    public boolean isEventProvider() {
        return true;
    }

    public NetworkConnector[] getConnectors() {
        return this.manager.getConnectorsForContainer((Object)this);
    }

    public NetworkConnector[] getConnectors(String protocol) {
        return this.manager.getConnectorsForContainer((Object)this, protocol);
    }

    public void resetStatistics() {
        this.server.statsReset();
    }

    public void setCollectStatistics(boolean on) {
        this.server.setStatsOn(on);
        this.stats.setStatsOn(on);
    }

    public boolean getCollectStatistics() {
        return this.server.getStatsOn();
    }

    public long getCollectStatisticsStarted() {
        return this.server.getStatsOnMs();
    }

    public Stats getStats() {
        if (this.getCollectStatistics()) {
            this.stats.getTotalRequestCountImpl().setCount((long)this.server.getRequests());
            this.stats.getTotalConnectionCountImpl().setCount((long)this.server.getConnections());
            this.stats.getTotalErrorCountImpl().setCount((long)this.server.getErrors());
            this.stats.getActiveRequestCountImpl().setCurrent((long)this.server.getRequestsActive());
            this.stats.getActiveRequestCountImpl().setLowWaterMark((long)this.server.getRequestsActiveMin());
            this.stats.getActiveRequestCountImpl().setHighWaterMark((long)this.server.getRequestsActiveMax());
            this.stats.getConnectionRequestCountImpl().setCurrent((long)this.server.getConnectionsOpen());
            this.stats.getConnectionRequestCountImpl().setLowWaterMark((long)this.server.getConnectionsRequestsMin());
            this.stats.getConnectionRequestCountImpl().setHighWaterMark((long)this.server.getConnectionsRequestsMax());
            this.stats.getOpenConnectionCountImpl().setCurrent((long)this.server.getConnectionsOpen());
            this.stats.getOpenConnectionCountImpl().setLowWaterMark((long)this.server.getConnectionsOpenMin());
            this.stats.getOpenConnectionCountImpl().setHighWaterMark((long)this.server.getConnectionsOpenMax());
            this.stats.getRequestDurationImpl().setMinTime(this.server.getRequestsDurationMin());
            this.stats.getRequestDurationImpl().setMaxTime(this.server.getRequestsDurationMax());
            this.stats.getRequestDurationImpl().setCount(this.stats.getTotalRequestCount().getCount());
            this.stats.getRequestDurationImpl().setTotalTime(this.server.getRequestsDurationTotal());
            this.stats.getConnectionDurationImpl().setMinTime(this.server.getConnectionsDurationMin());
            this.stats.getConnectionDurationImpl().setMaxTime(this.server.getConnectionsDurationMax());
            this.stats.getConnectionDurationImpl().setCount(this.stats.getTotalConnectionCount().getCount());
            this.stats.getConnectionDurationImpl().setTotalTime(this.server.getConnectionsDurationTotal());
        }
        return this.stats;
    }

    public void addListener(HttpListener listener) {
        this.server.addListener(listener);
    }

    public void removeListener(HttpListener listener) {
        this.server.removeListener(listener);
    }

    public void addContext(HttpContext context) {
        this.server.addContext(context);
    }

    public void removeContext(HttpContext context) {
        this.server.removeContext(context);
    }

    public InternalJAASJettyRealm addRealm(String realmName) {
        InternalJAASJettyRealm realm = (InternalJAASJettyRealm)this.realms.get(realmName);
        if (realm == null) {
            realm = new InternalJAASJettyRealm(realmName);
            this.realms.put(realmName, realm);
        } else {
            realm.addUse();
        }
        return realm;
    }

    public void removeRealm(String realmName) {
        InternalJAASJettyRealm realm = (InternalJAASJettyRealm)this.realms.get(realmName);
        if (realm != null && realm.removeUse() == 0) {
            this.realms.remove(realmName);
        }
    }

    public void addWebService(String contextPath, String[] virtualHosts, WebServiceContainer webServiceContainer, String securityRealmName, String realmName, String transportGuarantee, String authMethod, ClassLoader classLoader) throws Exception {
        InternalJAASJettyRealm internalJAASJettyRealm = securityRealmName == null ? null : this.addRealm(securityRealmName);
        JettyEJBWebServiceContext webServiceContext = new JettyEJBWebServiceContext(contextPath, webServiceContainer, internalJAASJettyRealm, realmName, transportGuarantee, authMethod, classLoader);
        webServiceContext.setHosts(virtualHosts);
        this.addContext(webServiceContext);
        webServiceContext.start();
        this.webServices.put(contextPath, webServiceContext);
    }

    public void removeWebService(String contextPath) {
        JettyEJBWebServiceContext webServiceContext = (JettyEJBWebServiceContext)((Object)this.webServices.remove(contextPath));
        String securityRealmName = webServiceContext.getSecurityRealmName();
        if (securityRealmName != null) {
            this.removeRealm(securityRealmName);
        }
        this.removeContext(webServiceContext);
    }

    public void setRequestLog(RequestLog log) {
        this.server.setRequestLog(log);
    }

    public RequestLog getRequestLog() {
        return this.server.getRequestLog();
    }

    public void doStart() throws Exception {
        this.server.start();
    }

    public void doStop() {
        try {
            this.server.stop(true);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void doFail() {
        try {
            this.server.stop(false);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static GBeanInfo getGBeanInfo() {
        return GBEAN_INFO;
    }

    static {
        GBeanInfoBuilder infoBuilder = GBeanInfoBuilder.createStatic((String)"Jetty Web Container", (Class)JettyContainerImpl.class);
        infoBuilder.addAttribute("collectStatistics", Boolean.TYPE, true);
        infoBuilder.addAttribute("collectStatisticsStarted", Long.TYPE, false);
        infoBuilder.addOperation("resetStatistics");
        infoBuilder.addAttribute("requestLog", RequestLog.class, false, false);
        infoBuilder.addOperation("addListener", new Class[]{HttpListener.class});
        infoBuilder.addOperation("removeListener", new Class[]{HttpListener.class});
        infoBuilder.addOperation("addContext", new Class[]{HttpContext.class});
        infoBuilder.addOperation("removeContext", new Class[]{HttpContext.class});
        infoBuilder.addOperation("addRealm", new Class[]{String.class});
        infoBuilder.addOperation("removeRealm", new Class[]{String.class});
        infoBuilder.addAttribute("objectName", String.class, false);
        infoBuilder.addReference("WebManager", WebManager.class);
        infoBuilder.addInterface(SoapHandler.class);
        infoBuilder.addInterface(JettyContainer.class);
        infoBuilder.addInterface(StatisticsProvider.class);
        infoBuilder.setConstructor(new String[]{"objectName", "WebManager"});
        GBEAN_INFO = infoBuilder.getBeanInfo();
    }
}

