/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.naming.deployment;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.transaction.UserTransaction;
import javax.xml.namespace.QName;
import org.apache.geronimo.common.DeploymentException;
import org.apache.geronimo.deployment.DeploymentContext;
import org.apache.geronimo.j2ee.deployment.EARContext;
import org.apache.geronimo.j2ee.deployment.Module;
import org.apache.geronimo.j2ee.deployment.RefContext;
import org.apache.geronimo.j2ee.deployment.ServiceReferenceBuilder;
import org.apache.geronimo.j2ee.j2eeobjectnames.J2eeContext;
import org.apache.geronimo.j2ee.j2eeobjectnames.NameFactory;
import org.apache.geronimo.kernel.ClassLoading;
import org.apache.geronimo.kernel.Kernel;
import org.apache.geronimo.naming.deployment.ResourceEnvironmentBuilder;
import org.apache.geronimo.naming.java.ComponentContextBuilder;
import org.apache.geronimo.xbeans.geronimo.naming.GerCssType;
import org.apache.geronimo.xbeans.geronimo.naming.GerEjbLocalRefType;
import org.apache.geronimo.xbeans.geronimo.naming.GerEjbRefType;
import org.apache.geronimo.xbeans.geronimo.naming.GerGbeanLocatorType;
import org.apache.geronimo.xbeans.geronimo.naming.GerResourceEnvRefType;
import org.apache.geronimo.xbeans.geronimo.naming.GerResourceRefType;
import org.apache.geronimo.xbeans.geronimo.naming.GerServiceRefType;
import org.apache.geronimo.xbeans.j2ee.EjbLocalRefType;
import org.apache.geronimo.xbeans.j2ee.EjbRefType;
import org.apache.geronimo.xbeans.j2ee.EnvEntryType;
import org.apache.geronimo.xbeans.j2ee.MessageDestinationRefType;
import org.apache.geronimo.xbeans.j2ee.ParamValueType;
import org.apache.geronimo.xbeans.j2ee.PortComponentRefType;
import org.apache.geronimo.xbeans.j2ee.ResourceEnvRefType;
import org.apache.geronimo.xbeans.j2ee.ResourceRefType;
import org.apache.geronimo.xbeans.j2ee.ServiceRefHandlerType;
import org.apache.geronimo.xbeans.j2ee.ServiceRefType;
import org.apache.geronimo.xbeans.j2ee.XsdQNameType;
import org.apache.geronimo.xbeans.j2ee.XsdStringType;

public class ENCConfigBuilder {
    private static final String JAXR_CONNECTION_FACTORY_CLASS = "javax.xml.registry.ConnectionFactory";
    static /* synthetic */ Class class$java$net$URL;

    public static ObjectName getGBeanId(String j2eeType, GerGbeanLocatorType gerGbeanLocator, J2eeContext j2eeContext, DeploymentContext context, Kernel kernel) throws DeploymentException {
        ObjectName containerId = null;
        if (gerGbeanLocator.isSetGbeanLink()) {
            String linkName = gerGbeanLocator.getGbeanLink().trim();
            ObjectName exact = null;
            try {
                exact = NameFactory.getComponentName(null, null, null, null, (String)linkName, (String)j2eeType, (J2eeContext)j2eeContext);
            }
            catch (MalformedObjectNameException e) {
                throw new DeploymentException("Could not construct gbean name", (Throwable)e);
            }
            if (context.listGBeans(exact).size() == 1) {
                containerId = exact;
            } else {
                ObjectName query = null;
                try {
                    query = NameFactory.getComponentNameQuery(null, null, null, (String)linkName, (String)j2eeType, (J2eeContext)j2eeContext);
                }
                catch (MalformedObjectNameException e) {
                    throw new DeploymentException("Could not construct query for gbean name", (Throwable)e);
                }
                Set localMatches = context.listGBeans(query);
                if (localMatches.size() > 1) {
                    throw new DeploymentException("More than one local match for gbean link, " + localMatches);
                }
                if (localMatches.size() == 1) {
                    containerId = (ObjectName)localMatches.iterator().next();
                }
                if (containerId == null) {
                    try {
                        query = NameFactory.getComponentRestrictedQueryName(null, null, (String)linkName, (String)j2eeType, (J2eeContext)j2eeContext);
                    }
                    catch (MalformedObjectNameException e) {
                        throw new DeploymentException("Could not construct query for gbean name", (Throwable)e);
                    }
                    Set matches = kernel.listGBeans(query);
                    if (matches.size() != 1) {
                        throw new DeploymentException("No or ambiguous match for gbean link: " + linkName + " using query " + query + ", matches: " + matches);
                    }
                    containerId = (ObjectName)matches.iterator().next();
                }
            }
        } else {
            if (gerGbeanLocator.isSetTargetName()) {
                try {
                    containerId = ObjectName.getInstance(ENCConfigBuilder.getStringValue(gerGbeanLocator.getTargetName()));
                }
                catch (MalformedObjectNameException e) {
                    throw new DeploymentException("Could not construct object name from specified string", (Throwable)e);
                }
            }
            try {
                containerId = NameFactory.getComponentName((String)ENCConfigBuilder.getStringValue(gerGbeanLocator.getDomain()), (String)ENCConfigBuilder.getStringValue(gerGbeanLocator.getServer()), (String)ENCConfigBuilder.getStringValue(gerGbeanLocator.getApplication()), (String)ENCConfigBuilder.getStringValue(gerGbeanLocator.getModule()), (String)ENCConfigBuilder.getStringValue(gerGbeanLocator.getName()), (String)j2eeType, (J2eeContext)j2eeContext);
            }
            catch (MalformedObjectNameException e) {
                throw new DeploymentException("could not construct object name for jms resource", (Throwable)e);
            }
        }
        return containerId;
    }

    public static void addEnvEntries(EnvEntryType[] envEntries, ComponentContextBuilder builder, ClassLoader classLoader) throws DeploymentException {
        for (int i = 0; i < envEntries.length; ++i) {
            EnvEntryType envEntry = envEntries[i];
            String name = ENCConfigBuilder.getStringValue((org.apache.geronimo.xbeans.j2ee.String)envEntry.getEnvEntryName());
            String type = ENCConfigBuilder.getStringValue((org.apache.geronimo.xbeans.j2ee.String)envEntry.getEnvEntryType());
            String text = ENCConfigBuilder.getStringValue(envEntry.getEnvEntryValue());
            try {
                builder.addEnvEntry(name, type, text, classLoader);
                continue;
            }
            catch (NumberFormatException e) {
                throw new DeploymentException("Invalid env-entry value for name: " + name, (Throwable)e);
            }
            catch (NamingException e) {
                throw new DeploymentException("Invalid env-entry definition for name: " + name, (Throwable)e);
            }
        }
    }

    public static void addResourceRefs(EARContext earContext, URI uri, ResourceRefType[] resourceRefs, Map refMap, ClassLoader cl, ComponentContextBuilder builder) throws DeploymentException {
        if (refMap == null) {
            refMap = Collections.EMPTY_MAP;
        }
        RefContext refContext = earContext.getRefContext();
        J2eeContext j2eeContext = earContext.getJ2eeContext();
        for (int i = 0; i < resourceRefs.length; ++i) {
            ResourceRefType resourceRef = resourceRefs[i];
            String name = ENCConfigBuilder.getStringValue((org.apache.geronimo.xbeans.j2ee.String)resourceRef.getResRefName());
            String type = ENCConfigBuilder.getStringValue((org.apache.geronimo.xbeans.j2ee.String)resourceRef.getResType());
            GerResourceRefType gerResourceRef = (GerResourceRefType)refMap.get(name);
            Class<?> iface = null;
            try {
                iface = cl.loadClass(type);
            }
            catch (ClassNotFoundException e) {
                throw new DeploymentException("could not load class " + type, (Throwable)e);
            }
            Reference ref = null;
            if (iface == (class$java$net$URL == null ? ENCConfigBuilder.class$("java.net.URL") : class$java$net$URL)) {
                if (gerResourceRef == null || !gerResourceRef.isSetUrl()) {
                    throw new DeploymentException("No url supplied to resolve: " + name);
                }
                try {
                    builder.bind(name, (Object)new URL(gerResourceRef.getUrl()));
                    continue;
                }
                catch (MalformedURLException e) {
                    throw new DeploymentException("Could not convert " + gerResourceRef.getUrl() + " to URL", (Throwable)e);
                }
            }
            String j2eeType = "javax.mail.Session".equals(type) ? NameFactory.JAVA_MAIL_RESOURCE : (JAXR_CONNECTION_FACTORY_CLASS.equals(type) ? NameFactory.JAXR_CONNECTION_FACTORY : NameFactory.JCA_MANAGED_CONNECTION_FACTORY);
            String containerId = ENCConfigBuilder.getResourceContainerId(name, j2eeType, uri, gerResourceRef, refContext, j2eeContext, (DeploymentContext)earContext);
            ref = refContext.getConnectionFactoryRef(containerId, iface);
            builder.bind(name, (Object)ref);
        }
    }

    private static String getResourceContainerId(String name, String type, URI uri, GerResourceRefType gerResourceRef, RefContext refContext, J2eeContext j2eeContext, DeploymentContext context) throws DeploymentException {
        String containerId = null;
        if (gerResourceRef == null) {
            containerId = refContext.getConnectionFactoryContainerId(uri, name, type, j2eeContext, context);
        } else if (gerResourceRef.isSetResourceLink()) {
            containerId = refContext.getConnectionFactoryContainerId(uri, gerResourceRef.getResourceLink().trim(), type, j2eeContext, context);
        } else if (gerResourceRef.isSetTargetName()) {
            containerId = gerResourceRef.getTargetName().trim();
        } else {
            try {
                containerId = NameFactory.getComponentName((String)ENCConfigBuilder.getStringValue(gerResourceRef.getDomain()), (String)ENCConfigBuilder.getStringValue(gerResourceRef.getServer()), (String)ENCConfigBuilder.getStringValue(gerResourceRef.getApplication()), (String)NameFactory.JCA_RESOURCE, (String)ENCConfigBuilder.getStringValue(gerResourceRef.getModule()), (String)ENCConfigBuilder.getStringValue(gerResourceRef.getName()), (String)(gerResourceRef.getType() == null ? type : gerResourceRef.getType().trim()), (J2eeContext)j2eeContext).getCanonicalName();
            }
            catch (MalformedObjectNameException e) {
                throw new DeploymentException("could not construct object name for resource", (Throwable)e);
            }
        }
        return containerId;
    }

    public static void addResourceEnvRefs(EARContext earContext, URI uri, ResourceEnvRefType[] resourceEnvRefArray, Map refMap, ClassLoader cl, ComponentContextBuilder builder) throws DeploymentException {
        if (refMap == null) {
            refMap = Collections.EMPTY_MAP;
        }
        RefContext refContext = earContext.getRefContext();
        J2eeContext j2eeContext = earContext.getJ2eeContext();
        for (int i = 0; i < resourceEnvRefArray.length; ++i) {
            ResourceEnvRefType resourceEnvRef = resourceEnvRefArray[i];
            String name = ENCConfigBuilder.getStringValue((org.apache.geronimo.xbeans.j2ee.String)resourceEnvRef.getResourceEnvRefName());
            String type = ENCConfigBuilder.getStringValue((org.apache.geronimo.xbeans.j2ee.String)resourceEnvRef.getResourceEnvRefType());
            Class<?> iface = null;
            try {
                iface = cl.loadClass(type);
            }
            catch (ClassNotFoundException e) {
                throw new DeploymentException("could not load class " + type, (Throwable)e);
            }
            GerResourceEnvRefType gerResourceEnvRef = (GerResourceEnvRefType)refMap.get(name);
            String containerId = ENCConfigBuilder.getAdminObjectContainerId(name, uri, gerResourceEnvRef, refContext, j2eeContext);
            Reference ref = refContext.getAdminObjectRef(containerId, iface);
            builder.bind(name, (Object)ref);
        }
    }

    private static String getAdminObjectContainerId(String name, URI uri, GerResourceEnvRefType gerResourceEnvRef, RefContext refContext, J2eeContext j2eeContext) throws DeploymentException {
        String containerId = null;
        if (gerResourceEnvRef == null) {
            containerId = refContext.getAdminObjectContainerId(uri, name, j2eeContext);
        } else if (gerResourceEnvRef.isSetMessageDestinationLink()) {
            containerId = refContext.getAdminObjectContainerId(uri, ENCConfigBuilder.getStringValue(gerResourceEnvRef.getMessageDestinationLink()), j2eeContext);
        } else if (gerResourceEnvRef.isSetTargetName()) {
            containerId = ENCConfigBuilder.getStringValue(gerResourceEnvRef.getTargetName());
        } else {
            try {
                containerId = NameFactory.getComponentName((String)ENCConfigBuilder.getStringValue(gerResourceEnvRef.getDomain()), (String)ENCConfigBuilder.getStringValue(gerResourceEnvRef.getServer()), (String)ENCConfigBuilder.getStringValue(gerResourceEnvRef.getApplication()), (String)NameFactory.JCA_RESOURCE, (String)ENCConfigBuilder.getStringValue(gerResourceEnvRef.getModule()), (String)ENCConfigBuilder.getStringValue(gerResourceEnvRef.getName()), (String)NameFactory.JMS_RESOURCE, (J2eeContext)j2eeContext).getCanonicalName();
            }
            catch (MalformedObjectNameException e) {
                throw new DeploymentException("could not construct object name for jms resource", (Throwable)e);
            }
        }
        return containerId;
    }

    public static void addMessageDestinationRefs(EARContext earContext, URI uri, MessageDestinationRefType[] messageDestinationRefs, ClassLoader cl, ComponentContextBuilder builder) throws DeploymentException {
        RefContext refContext = earContext.getRefContext();
        for (int i = 0; i < messageDestinationRefs.length; ++i) {
            MessageDestinationRefType messageDestinationRef = messageDestinationRefs[i];
            String name = ENCConfigBuilder.getStringValue((org.apache.geronimo.xbeans.j2ee.String)messageDestinationRef.getMessageDestinationRefName());
            String linkName = ENCConfigBuilder.getStringValue((org.apache.geronimo.xbeans.j2ee.String)messageDestinationRef.getMessageDestinationLink());
            String type = ENCConfigBuilder.getStringValue((org.apache.geronimo.xbeans.j2ee.String)messageDestinationRef.getMessageDestinationType());
            Class<?> iface = null;
            try {
                iface = cl.loadClass(type);
            }
            catch (ClassNotFoundException e) {
                throw new DeploymentException("could not load class " + type, (Throwable)e);
            }
            String containerId = refContext.getAdminObjectContainerId(uri, linkName, earContext.getJ2eeContext());
            Reference ref = refContext.getAdminObjectRef(containerId, iface);
            builder.bind(name, (Object)ref);
        }
    }

    public static void addEJBRefs(EARContext earContext, URI uri, EjbRefType[] ejbRefs, Map ejbRefMap, ClassLoader cl, ComponentContextBuilder builder) throws DeploymentException {
        RefContext refContext = earContext.getRefContext();
        J2eeContext j2eeContext = earContext.getJ2eeContext();
        for (int i = 0; i < ejbRefs.length; ++i) {
            Reference ejbReference;
            EjbRefType ejbRef = ejbRefs[i];
            String ejbRefName = ENCConfigBuilder.getStringValue((org.apache.geronimo.xbeans.j2ee.String)ejbRef.getEjbRefName());
            String remote = ENCConfigBuilder.getStringValue((org.apache.geronimo.xbeans.j2ee.String)ejbRef.getRemote());
            ENCConfigBuilder.assureEJBObjectInterface(remote, cl);
            String home = ENCConfigBuilder.getStringValue((org.apache.geronimo.xbeans.j2ee.String)ejbRef.getHome());
            ENCConfigBuilder.assureEJBHomeInterface(home, cl);
            boolean isSession = "Session".equals(ENCConfigBuilder.getStringValue((org.apache.geronimo.xbeans.j2ee.String)ejbRef.getEjbRefType()));
            if (isSession && remote.equals("javax.management.j2ee.Management") && home.equals("javax.management.j2ee.ManagementHome")) {
                String mejbName = refContext.getMEJBName();
                ejbReference = refContext.getEJBRemoteRef(mejbName, isSession, home, remote);
            } else {
                String ejbLink = null;
                GerEjbRefType remoteRef = (GerEjbRefType)ejbRefMap.get(ejbRefName);
                if (remoteRef != null && remoteRef.isSetEjbLink()) {
                    ejbLink = remoteRef.getEjbLink();
                } else if (ejbRef.isSetEjbLink()) {
                    ejbLink = ENCConfigBuilder.getStringValue((org.apache.geronimo.xbeans.j2ee.String)ejbRef.getEjbLink());
                }
                if (ejbLink != null) {
                    ejbReference = refContext.getEJBRemoteRef(uri, ejbLink, isSession, home, remote);
                } else if (remoteRef != null) {
                    if (remoteRef.isSetTargetName()) {
                        ejbReference = refContext.getEJBRemoteRef(ENCConfigBuilder.getStringValue(remoteRef.getTargetName()), isSession, home, remote);
                    } else {
                        if (remoteRef.isSetNsCorbaloc()) {
                            try {
                                ObjectName cssBean;
                                if (remoteRef.isSetCssName()) {
                                    cssBean = ObjectName.getInstance(ENCConfigBuilder.getStringValue(remoteRef.getCssName()));
                                } else if (remoteRef.isSetCssLink()) {
                                    String cssLink = remoteRef.getCssLink().trim();
                                    cssBean = refContext.locateComponent(cssLink, "CORBACSS", j2eeContext, (DeploymentContext)earContext, "css gbean");
                                } else {
                                    GerCssType css = remoteRef.getCss();
                                    cssBean = NameFactory.getComponentName((String)ENCConfigBuilder.getStringValue(css.getDomain()), (String)ENCConfigBuilder.getStringValue(css.getServer()), (String)ENCConfigBuilder.getStringValue(css.getApplication()), (String)ENCConfigBuilder.getStringValue(css.getModule()), (String)ENCConfigBuilder.getStringValue(css.getName()), (String)ENCConfigBuilder.getStringValue("CORBACSS"), (J2eeContext)j2eeContext);
                                }
                                ejbReference = refContext.getCORBARemoteRef(new URI(ENCConfigBuilder.getStringValue(remoteRef.getNsCorbaloc())), ENCConfigBuilder.getStringValue(remoteRef.getName()), ObjectName.getInstance(cssBean), home);
                            }
                            catch (URISyntaxException e) {
                                throw new DeploymentException("Could not construct CORBA NameServer URI: " + remoteRef.getNsCorbaloc(), (Throwable)e);
                            }
                            catch (MalformedObjectNameException e) {
                                throw new DeploymentException("Could not construct CSS container name: " + remoteRef.getCssName(), (Throwable)e);
                            }
                        }
                        String containerId = null;
                        try {
                            containerId = NameFactory.getEjbComponentNameString((String)ENCConfigBuilder.getStringValue(remoteRef.getDomain()), (String)ENCConfigBuilder.getStringValue(remoteRef.getServer()), (String)ENCConfigBuilder.getStringValue(remoteRef.getApplication()), (String)ENCConfigBuilder.getStringValue(remoteRef.getModule()), (String)ENCConfigBuilder.getStringValue(remoteRef.getName()), (String)ENCConfigBuilder.getStringValue(remoteRef.getType()), (J2eeContext)j2eeContext);
                        }
                        catch (MalformedObjectNameException e) {
                            throw new DeploymentException("Could not construct ejb object name: " + remoteRef.getName(), (Throwable)e);
                        }
                        ejbReference = refContext.getEJBRemoteRef(containerId, isSession, home, remote);
                    }
                } else {
                    ejbReference = refContext.getImplicitEJBRemoteRef(uri, ejbRefName, isSession, home, remote);
                }
            }
            builder.bind(ejbRefName, (Object)ejbReference);
        }
    }

    public static void addEJBLocalRefs(EARContext earContext, URI uri, EjbLocalRefType[] ejbLocalRefs, Map ejbLocalRefMap, ClassLoader cl, ComponentContextBuilder builder) throws DeploymentException {
        RefContext refContext = earContext.getRefContext();
        J2eeContext j2eeContext = earContext.getJ2eeContext();
        for (int i = 0; i < ejbLocalRefs.length; ++i) {
            Reference ejbReference;
            EjbLocalRefType ejbLocalRef = ejbLocalRefs[i];
            String ejbRefName = ENCConfigBuilder.getStringValue((org.apache.geronimo.xbeans.j2ee.String)ejbLocalRef.getEjbRefName());
            String local = ENCConfigBuilder.getStringValue((org.apache.geronimo.xbeans.j2ee.String)ejbLocalRef.getLocal());
            ENCConfigBuilder.assureEJBLocalObjectInterface(local, cl);
            String localHome = ENCConfigBuilder.getStringValue((org.apache.geronimo.xbeans.j2ee.String)ejbLocalRef.getLocalHome());
            ENCConfigBuilder.assureEJBLocalHomeInterface(localHome, cl);
            boolean isSession = "Session".equals(ENCConfigBuilder.getStringValue((org.apache.geronimo.xbeans.j2ee.String)ejbLocalRef.getEjbRefType()));
            String ejbLink = null;
            GerEjbLocalRefType localRef = (GerEjbLocalRefType)ejbLocalRefMap.get(ejbRefName);
            if (localRef != null && localRef.isSetEjbLink()) {
                ejbLink = localRef.getEjbLink();
            } else if (ejbLocalRef.isSetEjbLink()) {
                ejbLink = ENCConfigBuilder.getStringValue((org.apache.geronimo.xbeans.j2ee.String)ejbLocalRef.getEjbLink());
            }
            if (ejbLink != null) {
                ejbReference = refContext.getEJBLocalRef(uri, ejbLink, isSession, localHome, local);
            } else if (localRef != null) {
                if (localRef.isSetTargetName()) {
                    ejbReference = refContext.getEJBLocalRef(ENCConfigBuilder.getStringValue(localRef.getTargetName()), isSession, localHome, local);
                } else {
                    String containerId = null;
                    try {
                        containerId = NameFactory.getEjbComponentNameString((String)ENCConfigBuilder.getStringValue(localRef.getDomain()), (String)ENCConfigBuilder.getStringValue(localRef.getServer()), (String)ENCConfigBuilder.getStringValue(localRef.getApplication()), (String)ENCConfigBuilder.getStringValue(localRef.getModule()), (String)ENCConfigBuilder.getStringValue(localRef.getName()), (String)ENCConfigBuilder.getStringValue(localRef.getType()), (J2eeContext)j2eeContext);
                    }
                    catch (MalformedObjectNameException e) {
                        throw new DeploymentException("Could not construct ejb object name: " + localRef.getName(), (Throwable)e);
                    }
                    ejbReference = refContext.getEJBLocalRef(containerId, isSession, localHome, local);
                }
            } else {
                ejbReference = refContext.getImplicitEJBLocalRef(uri, ejbLink, isSession, localHome, local);
            }
            builder.bind(ejbRefName, (Object)ejbReference);
        }
    }

    public static void addServiceRefs(EARContext earContext, Module module, ServiceRefType[] serviceRefs, Map serviceRefMap, ClassLoader cl, ComponentContextBuilder builder) throws DeploymentException {
        RefContext refContext = earContext.getRefContext();
        for (int i = 0; i < serviceRefs.length; ++i) {
            ServiceRefType serviceRef = serviceRefs[i];
            String name = ENCConfigBuilder.getStringValue((org.apache.geronimo.xbeans.j2ee.String)serviceRef.getServiceRefName());
            GerServiceRefType serviceRefType = (GerServiceRefType)serviceRefMap.get(name);
            String serviceInterfaceName = ENCConfigBuilder.getStringValue((org.apache.geronimo.xbeans.j2ee.String)serviceRef.getServiceInterface());
            ENCConfigBuilder.assureInterface(serviceInterfaceName, "javax.xml.rpc.Service", "[Web]Service", cl);
            Class<?> serviceInterface = null;
            try {
                serviceInterface = cl.loadClass(serviceInterfaceName);
            }
            catch (ClassNotFoundException e) {
                throw new DeploymentException("Could not load service interface class: " + serviceInterfaceName, (Throwable)e);
            }
            URI wsdlURI = null;
            if (serviceRef.isSetWsdlFile()) {
                try {
                    wsdlURI = new URI(ENCConfigBuilder.getStringValue(serviceRef.getWsdlFile().getStringValue()));
                }
                catch (URISyntaxException e) {
                    throw new DeploymentException("could not construct wsdl uri from " + serviceRef.getWsdlFile().getStringValue(), (Throwable)e);
                }
            }
            URI jaxrpcMappingURI = null;
            if (serviceRef.isSetJaxrpcMappingFile()) {
                try {
                    jaxrpcMappingURI = new URI(ENCConfigBuilder.getStringValue((org.apache.geronimo.xbeans.j2ee.String)serviceRef.getJaxrpcMappingFile()));
                }
                catch (URISyntaxException e) {
                    throw new DeploymentException("Could not construct jaxrpc mapping uri from " + serviceRef.getJaxrpcMappingFile(), (Throwable)e);
                }
            }
            QName serviceQName = null;
            if (serviceRef.isSetServiceQname()) {
                serviceQName = serviceRef.getServiceQname().getQNameValue();
            }
            HashMap portComponentRefMap = new HashMap();
            PortComponentRefType[] portComponentRefs = serviceRef.getPortComponentRefArray();
            if (portComponentRefs != null) {
                for (int j = 0; j < portComponentRefs.length; ++j) {
                    Class<?> serviceEndpointClass;
                    PortComponentRefType portComponentRef = portComponentRefs[j];
                    String portComponentLink = ENCConfigBuilder.getStringValue(portComponentRef.getPortComponentLink());
                    String serviceEndpointInterfaceType = ENCConfigBuilder.getStringValue((org.apache.geronimo.xbeans.j2ee.String)portComponentRef.getServiceEndpointInterface());
                    ENCConfigBuilder.assureInterface(serviceEndpointInterfaceType, "java.rmi.Remote", "ServiceEndpoint", cl);
                    try {
                        serviceEndpointClass = cl.loadClass(serviceEndpointInterfaceType);
                    }
                    catch (ClassNotFoundException e) {
                        throw new DeploymentException("could not load service endpoint class " + serviceEndpointInterfaceType, (Throwable)e);
                    }
                    portComponentRefMap.put(serviceEndpointClass, portComponentLink);
                }
            }
            ServiceRefHandlerType[] handlers = serviceRef.getHandlerArray();
            List handlerInfos = ENCConfigBuilder.buildHandlerInfoList(handlers, cl);
            Object ref = refContext.getServiceReference(serviceInterface, wsdlURI, jaxrpcMappingURI, serviceQName, portComponentRefMap, handlerInfos, (Object)serviceRefType, (DeploymentContext)earContext, module, cl);
            builder.bind(name, ref);
        }
    }

    private static List buildHandlerInfoList(ServiceRefHandlerType[] handlers, ClassLoader classLoader) throws DeploymentException {
        ArrayList<ServiceReferenceBuilder.HandlerInfoInfo> handlerInfos = new ArrayList<ServiceReferenceBuilder.HandlerInfoInfo>();
        for (int i = 0; i < handlers.length; ++i) {
            ServiceRefHandlerType handler = handlers[i];
            org.apache.geronimo.xbeans.j2ee.String[] portNameArray = handler.getPortNameArray();
            ArrayList<String> portNames = new ArrayList<String>();
            for (int j = 0; j < portNameArray.length; ++j) {
                portNames.add(portNameArray[j].getStringValue().trim());
            }
            String handlerClassName = handler.getHandlerClass().getStringValue().trim();
            Class handlerClass = null;
            try {
                handlerClass = ClassLoading.loadClass((String)handlerClassName, (ClassLoader)classLoader);
            }
            catch (ClassNotFoundException e) {
                throw new DeploymentException("Could not load handler class", (Throwable)e);
            }
            HashMap<String, String> config = new HashMap<String, String>();
            ParamValueType[] paramValues = handler.getInitParamArray();
            for (int j = 0; j < paramValues.length; ++j) {
                ParamValueType paramValue = paramValues[j];
                String paramName = paramValue.getParamName().getStringValue().trim();
                String paramStringValue = paramValue.getParamValue().getStringValue().trim();
                config.put(paramName, paramStringValue);
            }
            XsdQNameType[] soapHeaderQNames = handler.getSoapHeaderArray();
            QName[] headerQNames = new QName[soapHeaderQNames.length];
            for (int j = 0; j < soapHeaderQNames.length; ++j) {
                XsdQNameType soapHeaderQName = soapHeaderQNames[j];
                headerQNames[j] = soapHeaderQName.getQNameValue();
            }
            HashSet<String> soapRoles = new HashSet<String>();
            for (int j = 0; j < handler.getSoapRoleArray().length; ++j) {
                String soapRole = handler.getSoapRoleArray(j).getStringValue().trim();
                soapRoles.add(soapRole);
            }
            ServiceReferenceBuilder.HandlerInfoInfo handlerInfoInfo = new ServiceReferenceBuilder.HandlerInfoInfo(new HashSet(portNames), handlerClass, config, headerQNames, soapRoles);
            handlerInfos.add(handlerInfoInfo);
        }
        return handlerInfos;
    }

    public static void assureEJBObjectInterface(String remote, ClassLoader cl) throws DeploymentException {
        ENCConfigBuilder.assureInterface(remote, "javax.ejb.EJBObject", "Remote", cl);
    }

    public static void assureEJBHomeInterface(String home, ClassLoader cl) throws DeploymentException {
        ENCConfigBuilder.assureInterface(home, "javax.ejb.EJBHome", "Home", cl);
    }

    public static void assureEJBLocalObjectInterface(String local, ClassLoader cl) throws DeploymentException {
        ENCConfigBuilder.assureInterface(local, "javax.ejb.EJBLocalObject", "Local", cl);
    }

    public static void assureEJBLocalHomeInterface(String localHome, ClassLoader cl) throws DeploymentException {
        ENCConfigBuilder.assureInterface(localHome, "javax.ejb.EJBLocalHome", "LocalHome", cl);
    }

    public static void assureInterface(String interfaceName, String superInterfaceName, String interfaceType, ClassLoader cl) throws DeploymentException {
        Class<?> clazz = null;
        try {
            clazz = cl.loadClass(interfaceName);
        }
        catch (ClassNotFoundException e) {
            throw new DeploymentException(interfaceType + " interface class not found: " + interfaceName);
        }
        if (!clazz.isInterface()) {
            throw new DeploymentException(interfaceType + " interface is not an interface: " + interfaceName);
        }
        Class<?> superInterface = null;
        try {
            superInterface = cl.loadClass(superInterfaceName);
        }
        catch (ClassNotFoundException e) {
            throw new DeploymentException("Class " + superInterfaceName + " could not be loaded");
        }
        if (!superInterface.isAssignableFrom(clazz)) {
            throw new DeploymentException(interfaceType + " interface does not extend " + superInterfaceName + ": " + interfaceName);
        }
    }

    private static String getStringValue(org.apache.geronimo.xbeans.j2ee.String string) {
        if (string == null) {
            return null;
        }
        String s = string.getStringValue();
        return s == null ? null : s.trim();
    }

    private static String getStringValue(XsdStringType string) {
        if (string == null) {
            return null;
        }
        String s = string.getStringValue();
        return s == null ? null : s.trim();
    }

    private static String getStringValue(String string) {
        return string == null ? null : string.trim();
    }

    public static void setResourceEnvironment(EARContext earContext, URI uri, ResourceEnvironmentBuilder builder, ResourceRefType[] resourceRefs, GerResourceRefType[] gerResourceRefs) throws DeploymentException {
        RefContext refContext = earContext.getRefContext();
        J2eeContext j2eeContext = earContext.getJ2eeContext();
        Map refMap = ENCConfigBuilder.mapResourceRefs(gerResourceRefs);
        HashSet<String> unshareableResources = new HashSet<String>();
        HashSet<String> applicationManagedSecurityResources = new HashSet<String>();
        for (int i = 0; i < resourceRefs.length; ++i) {
            ResourceRefType resourceRefType = resourceRefs[i];
            String type = resourceRefType.getResType().getStringValue().trim();
            if ((class$java$net$URL == null ? ENCConfigBuilder.class$("java.net.URL") : class$java$net$URL).getName().equals(type) || "javax.mail.Session".equals(type) || JAXR_CONNECTION_FACTORY_CLASS.equals(type)) continue;
            GerResourceRefType gerResourceRef = (GerResourceRefType)refMap.get(resourceRefType.getResRefName().getStringValue());
            String containerId = ENCConfigBuilder.getResourceContainerId(ENCConfigBuilder.getStringValue((org.apache.geronimo.xbeans.j2ee.String)resourceRefType.getResRefName()), NameFactory.JCA_MANAGED_CONNECTION_FACTORY, uri, gerResourceRef, refContext, j2eeContext, (DeploymentContext)earContext);
            if ("Unshareable".equals(ENCConfigBuilder.getStringValue((org.apache.geronimo.xbeans.j2ee.String)resourceRefType.getResSharingScope()))) {
                unshareableResources.add(containerId);
            }
            if (!"Application".equals(ENCConfigBuilder.getStringValue((org.apache.geronimo.xbeans.j2ee.String)resourceRefType.getResAuth()))) continue;
            applicationManagedSecurityResources.add(containerId);
        }
        builder.setUnshareableResources(unshareableResources);
        builder.setApplicationManagedSecurityResources(applicationManagedSecurityResources);
    }

    public static Map buildComponentContext(EARContext earContext, Module module, UserTransaction userTransaction, EnvEntryType[] envEntries, EjbRefType[] ejbRefs, GerEjbRefType[] gerEjbRefs, EjbLocalRefType[] ejbLocalRefs, GerEjbLocalRefType[] gerEjbLocalRef, ResourceRefType[] resourceRefs, GerResourceRefType[] gerResourceRef, ResourceEnvRefType[] resourceEnvRefs, GerResourceEnvRefType[] gerResourceEnvRef, MessageDestinationRefType[] messageDestinationRefs, ServiceRefType[] serviceRefs, GerServiceRefType[] gerServiceRefs, ClassLoader cl) throws DeploymentException {
        Object handleDelegateReference;
        ObjectName corbaGBean;
        ComponentContextBuilder builder = new ComponentContextBuilder();
        if (userTransaction != null) {
            builder.addUserTransaction(userTransaction);
        }
        if ((corbaGBean = earContext.getCORBAGBeanObjectName()) != null) {
            builder.addORB(corbaGBean);
        }
        if ((handleDelegateReference = earContext.getRefContext().getHandleDelegateReference()) != null) {
            builder.addHandleDelegateReference(handleDelegateReference);
        }
        URI uri = module.getConfigId();
        ENCConfigBuilder.addEnvEntries(envEntries, builder, cl);
        ENCConfigBuilder.addEJBRefs(earContext, uri, ejbRefs, ENCConfigBuilder.mapEjbRefs(gerEjbRefs), cl, builder);
        ENCConfigBuilder.addEJBLocalRefs(earContext, uri, ejbLocalRefs, ENCConfigBuilder.mapEjbLocalRefs(gerEjbLocalRef), cl, builder);
        ENCConfigBuilder.addResourceRefs(earContext, uri, resourceRefs, ENCConfigBuilder.mapResourceRefs(gerResourceRef), cl, builder);
        ENCConfigBuilder.addResourceEnvRefs(earContext, uri, resourceEnvRefs, ENCConfigBuilder.mapResourceEnvRefs(gerResourceEnvRef), cl, builder);
        ENCConfigBuilder.addMessageDestinationRefs(earContext, uri, messageDestinationRefs, cl, builder);
        Map serviceRefMap = ENCConfigBuilder.mapServiceRefs(gerServiceRefs);
        ENCConfigBuilder.addServiceRefs(earContext, module, serviceRefs, serviceRefMap, cl, builder);
        return builder.getContext();
    }

    private static Map mapEjbRefs(GerEjbRefType[] refs) {
        HashMap<String, GerEjbRefType> refMap = new HashMap<String, GerEjbRefType>();
        if (refs != null) {
            for (int i = 0; i < refs.length; ++i) {
                GerEjbRefType ref = refs[i];
                refMap.put(ref.getRefName().trim(), ref);
            }
        }
        return refMap;
    }

    private static Map mapEjbLocalRefs(GerEjbLocalRefType[] refs) {
        HashMap<String, GerEjbLocalRefType> refMap = new HashMap<String, GerEjbLocalRefType>();
        if (refs != null) {
            for (int i = 0; i < refs.length; ++i) {
                GerEjbLocalRefType ref = refs[i];
                refMap.put(ref.getRefName().trim(), ref);
            }
        }
        return refMap;
    }

    private static Map mapResourceRefs(GerResourceRefType[] refs) {
        HashMap<String, GerResourceRefType> refMap = new HashMap<String, GerResourceRefType>();
        if (refs != null) {
            for (int i = 0; i < refs.length; ++i) {
                GerResourceRefType ref = refs[i];
                refMap.put(ref.getRefName().trim(), ref);
            }
        }
        return refMap;
    }

    private static Map mapResourceEnvRefs(GerResourceEnvRefType[] refs) {
        HashMap<String, GerResourceEnvRefType> refMap = new HashMap<String, GerResourceEnvRefType>();
        if (refs != null) {
            for (int i = 0; i < refs.length; ++i) {
                GerResourceEnvRefType ref = refs[i];
                refMap.put(ref.getRefName().trim(), ref);
            }
        }
        return refMap;
    }

    private static Map mapServiceRefs(GerServiceRefType[] refs) {
        HashMap<String, GerServiceRefType> refMap = new HashMap<String, GerServiceRefType>();
        if (refs != null) {
            for (int i = 0; i < refs.length; ++i) {
                GerServiceRefType ref = refs[i];
                String serviceRefName = ref.getServiceRefName().trim();
                refMap.put(serviceRefName, ref);
            }
        }
        return refMap;
    }
}

