/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.security.deploy;

import java.beans.PropertyEditorManager;
import org.apache.geronimo.common.propertyeditor.PropertyEditorException;
import org.apache.geronimo.common.propertyeditor.TextPropertyEditorSupport;
import org.apache.geronimo.security.deploy.PrincipalInfo;

public class LoginDomainPrincipalInfo
extends PrincipalInfo {
    private final String domainName;

    public LoginDomainPrincipalInfo(String domainName, String className, String principalName, boolean designatedRunAs) {
        super(className, principalName, designatedRunAs);
        this.domainName = domainName;
    }

    public String getDomain() {
        return this.domainName;
    }

    static {
        PropertyEditorManager.registerEditor(LoginDomainPrincipalInfo.class, LoginDomainPrincipalEditor.class);
    }

    public static class LoginDomainPrincipalEditor
    extends TextPropertyEditorSupport {
        public void setAsText(String text) {
            if (text != null) {
                String[] parts = text.split(",");
                if (parts.length != 4) {
                    throw new PropertyEditorException("Principal should have the form 'domain,class,name,run-as'");
                }
                LoginDomainPrincipalInfo principal = new LoginDomainPrincipalInfo(parts[0], parts[1], parts[2], Boolean.valueOf(parts[3]));
                this.setValue(principal);
            } else {
                this.setValue(null);
            }
        }

        public String getAsText() {
            LoginDomainPrincipalInfo principal = (LoginDomainPrincipalInfo)this.getValue();
            if (principal == null) {
                return null;
            }
            return principal.getPrincipalName() + "," + principal.getClassName() + "," + principal.isDesignatedRunAs() + "," + principal.getDomain();
        }
    }
}

