/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.security.deploy;

import java.beans.PropertyEditorManager;
import java.io.Serializable;
import org.apache.geronimo.common.propertyeditor.PropertyEditorException;
import org.apache.geronimo.common.propertyeditor.TextPropertyEditorSupport;

public class PrincipalInfo
implements Serializable {
    private final String className;
    private final String principalName;
    private final boolean designatedRunAs;

    public PrincipalInfo(String className, String principalName, boolean designatedRunAs) {
        this.className = className;
        this.principalName = principalName;
        this.designatedRunAs = designatedRunAs;
    }

    public String getClassName() {
        return this.className;
    }

    public String getPrincipalName() {
        return this.principalName;
    }

    public boolean isDesignatedRunAs() {
        return this.designatedRunAs;
    }

    static {
        PropertyEditorManager.registerEditor(PrincipalInfo.class, PrincipalEditor.class);
    }

    public static class PrincipalEditor
    extends TextPropertyEditorSupport {
        public void setAsText(String text) {
            if (text != null) {
                String[] parts = text.split(",");
                if (parts.length != 3) {
                    throw new PropertyEditorException("Principal should have the form 'name,class,run-as'");
                }
                PrincipalInfo principalInfo = new PrincipalInfo(parts[0], parts[1], Boolean.valueOf(parts[2]));
                this.setValue(principalInfo);
            } else {
                this.setValue(null);
            }
        }

        public String getAsText() {
            PrincipalInfo principalInfo = (PrincipalInfo)this.getValue();
            if (principalInfo == null) {
                return null;
            }
            return principalInfo.getPrincipalName() + "," + principalInfo.getClassName() + "," + principalInfo.isDesignatedRunAs();
        }
    }
}

