/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.security.jaas.server;

import EDU.oswego.cs.dl.util.concurrent.ClockDaemon;
import EDU.oswego.cs.dl.util.concurrent.ThreadFactory;
import [Ljavax.security.auth.callback.Callback;;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.util.Collection;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geronimo.common.GeronimoSecurityException;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoBuilder;
import org.apache.geronimo.gbean.GBeanLifecycle;
import org.apache.geronimo.security.ContextManager;
import org.apache.geronimo.security.IdentificationPrincipal;
import org.apache.geronimo.security.SubjectId;
import org.apache.geronimo.security.jaas.LoginUtils;
import org.apache.geronimo.security.jaas.server.ExpiredLoginModuleException;
import org.apache.geronimo.security.jaas.server.JaasLoginModuleConfiguration;
import org.apache.geronimo.security.jaas.server.JaasLoginServiceMBean;
import org.apache.geronimo.security.jaas.server.JaasSecuritySession;
import org.apache.geronimo.security.jaas.server.JaasSessionId;
import org.apache.geronimo.security.realm.SecurityRealm;

public class JaasLoginService
implements GBeanLifecycle,
JaasLoginServiceMBean {
    public static final Log log;
    private static final int DEFAULT_EXPIRED_LOGIN_SCAN_INTERVAL = 300000;
    private static final int DEFAULT_MAX_LOGIN_DURATION = 86400000;
    private static final ClockDaemon clockDaemon;
    private static long nextLoginModuleId;
    private Collection realms;
    private Object expiredLoginScanIdentifier;
    private final String objectName;
    private final SecretKey key;
    private final String algorithm;
    private final ClassLoader classLoader;
    private final Map activeLogins = new Hashtable();
    private int expiredLoginScanIntervalMillis = 300000;
    private int maxLoginDurationMillis = 86400000;
    public static final GBeanInfo GBEAN_INFO;
    static final /* synthetic */ boolean $assertionsDisabled;

    public JaasLoginService(String algorithm, String password, ClassLoader classLoader, String objectName) {
        this.classLoader = classLoader;
        this.algorithm = algorithm;
        this.key = new SecretKeySpec(password.getBytes(), algorithm);
        this.objectName = objectName;
    }

    public String getObjectName() {
        return this.objectName;
    }

    public Collection getRealms() {
        return this.realms;
    }

    public void setRealms(Collection realms) {
        this.realms = realms;
    }

    public int getMaxLoginDurationMillis() {
        return this.maxLoginDurationMillis;
    }

    public void setMaxLoginDurationMillis(int maxLoginDurationMillis) {
        if (maxLoginDurationMillis == 0) {
            maxLoginDurationMillis = 86400000;
        }
        this.maxLoginDurationMillis = maxLoginDurationMillis;
    }

    public int getExpiredLoginScanIntervalMillis() {
        return this.expiredLoginScanIntervalMillis;
    }

    public void setExpiredLoginScanIntervalMillis(int expiredLoginScanIntervalMillis) {
        if (expiredLoginScanIntervalMillis == 0) {
            expiredLoginScanIntervalMillis = 300000;
        }
        this.expiredLoginScanIntervalMillis = expiredLoginScanIntervalMillis;
    }

    public void doStart() throws Exception {
        this.expiredLoginScanIdentifier = clockDaemon.executePeriodically((long)this.expiredLoginScanIntervalMillis, (Runnable)new ExpirationMonitor(), true);
    }

    public void doStop() throws Exception {
        ClockDaemon.cancel((Object)this.expiredLoginScanIdentifier);
    }

    public void doFail() {
    }

    public JaasSessionId connectToRealm(String realmName) {
        SecurityRealm realm = this.getRealm(realmName);
        if (realm == null) {
            throw new GeronimoSecurityException("No such realm (" + realmName + ")");
        }
        return this.initializeClient(realm);
    }

    public JaasLoginModuleConfiguration[] getLoginConfiguration(JaasSessionId sessionHandle) throws LoginException {
        JaasSecuritySession session = (JaasSecuritySession)this.activeLogins.get(sessionHandle);
        if (session == null) {
            throw new ExpiredLoginModuleException();
        }
        JaasLoginModuleConfiguration[] config = session.getModules();
        JaasLoginModuleConfiguration[] result = new JaasLoginModuleConfiguration[config.length];
        for (int i = 0; i < config.length; ++i) {
            result[i] = LoginUtils.getSerializableCopy(config[i]);
        }
        return result;
    }

    public Callback[] getServerLoginCallbacks(JaasSessionId sessionHandle, int loginModuleIndex) throws LoginException {
        JaasSecuritySession session = (JaasSecuritySession)this.activeLogins.get(sessionHandle);
        this.checkContext(session, loginModuleIndex);
        LoginModule module = session.getLoginModule(loginModuleIndex);
        session.getHandler().setExploring();
        try {
            module.initialize(session.getSubject(), session.getHandler(), new HashMap(), session.getOptions(loginModuleIndex));
        }
        catch (Exception e) {
            System.err.println("Failed to initialize module");
            e.printStackTrace();
        }
        try {
            module.login();
        }
        catch (LoginException e) {
            // empty catch block
        }
        try {
            module.abort();
        }
        catch (LoginException e) {
            // empty catch block
        }
        return session.getHandler().finalizeCallbackList();
    }

    public boolean performLogin(JaasSessionId sessionHandle, int loginModuleIndex, Callback[] results) throws LoginException {
        JaasSecuritySession session = (JaasSecuritySession)this.activeLogins.get(sessionHandle);
        this.checkContext(session, loginModuleIndex);
        try {
            session.getHandler().setClientResponse(results);
        }
        catch (IllegalArgumentException iae) {
            throw new LoginException(iae.toString());
        }
        return session.getLoginModule(loginModuleIndex).login();
    }

    public boolean performCommit(JaasSessionId sessionHandle, int loginModuleIndex) throws LoginException {
        JaasSecuritySession session = (JaasSecuritySession)this.activeLogins.get(sessionHandle);
        this.checkContext(session, loginModuleIndex);
        return session.getLoginModule(loginModuleIndex).commit();
    }

    public Principal loginSucceeded(JaasSessionId sessionHandle) throws LoginException {
        JaasSecuritySession session = (JaasSecuritySession)this.activeLogins.get(sessionHandle);
        if (session == null) {
            throw new ExpiredLoginModuleException();
        }
        Subject subject = session.getSubject();
        ContextManager.registerSubject(subject);
        SubjectId id = ContextManager.getSubjectId(subject);
        IdentificationPrincipal principal = new IdentificationPrincipal(id);
        subject.getPrincipals().add(principal);
        return principal;
    }

    public void loginFailed(JaasSessionId sessionHandle) {
        this.activeLogins.remove(sessionHandle);
    }

    public void logout(JaasSessionId sessionHandle) throws LoginException {
        JaasSecuritySession session = (JaasSecuritySession)this.activeLogins.get(sessionHandle);
        if (session == null) {
            throw new ExpiredLoginModuleException();
        }
        ContextManager.unregisterSubject(session.getSubject());
        this.activeLogins.remove(sessionHandle);
        for (int i = 0; i < session.getModules().length; ++i) {
            if (!session.isServerSide(i)) continue;
            session.getLoginModule(i).logout();
        }
    }

    public Map syncShareState(JaasSessionId sessionHandle, Map sharedState) throws LoginException {
        JaasSecuritySession session = (JaasSecuritySession)this.activeLogins.get(sessionHandle);
        if (session == null) {
            throw new ExpiredLoginModuleException();
        }
        session.getSharedContext().putAll(sharedState);
        return LoginUtils.getSerializableCopy(session.getSharedContext());
    }

    public Set syncPrincipals(JaasSessionId sessionHandle, Set principals) throws LoginException {
        JaasSecuritySession session = (JaasSecuritySession)this.activeLogins.get(sessionHandle);
        if (session == null) {
            throw new ExpiredLoginModuleException();
        }
        session.getSubject().getPrincipals().addAll(principals);
        return LoginUtils.getSerializableCopy(session.getSubject().getPrincipals());
    }

    private void checkContext(JaasSecuritySession session, int loginModuleIndex) throws LoginException {
        if (session == null) {
            throw new ExpiredLoginModuleException();
        }
        if (loginModuleIndex < 0 || loginModuleIndex >= session.getModules().length || !session.isServerSide(loginModuleIndex)) {
            throw new LoginException("Invalid login module specified");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JaasSessionId initializeClient(SecurityRealm realm) {
        long id;
        Class clazz = JaasLoginService.class;
        synchronized (clazz) {
            id = ++nextLoginModuleId;
        }
        JaasSessionId sessionHandle = new JaasSessionId(id, this.hash(id));
        JaasLoginModuleConfiguration[] modules = realm.getAppConfigurationEntries();
        JaasSecuritySession session = new JaasSecuritySession(realm.getRealmName(), modules, new HashMap(), this.classLoader);
        this.activeLogins.put(sessionHandle, session);
        return sessionHandle;
    }

    private SecurityRealm getRealm(String realmName) {
        Iterator it = this.realms.iterator();
        while (it.hasNext()) {
            SecurityRealm test = (SecurityRealm)it.next();
            if (!test.getRealmName().equals(realmName)) continue;
            return test;
        }
        return null;
    }

    private byte[] hash(long id) {
        byte[] bytes = new byte[8];
        for (int i = 7; i >= 0; --i) {
            bytes[i] = (byte)id;
            id >>>= 8;
        }
        try {
            Mac mac = Mac.getInstance(this.algorithm);
            mac.init(this.key);
            mac.update(bytes);
            return mac.doFinal();
        }
        catch (NoSuchAlgorithmException e) {
        }
        catch (InvalidKeyException e) {
            // empty catch block
        }
        if (!$assertionsDisabled) {
            throw new AssertionError((Object)"Should never have reached here");
        }
        return null;
    }

    public static GBeanInfo getGBeanInfo() {
        return GBEAN_INFO;
    }

    static {
        $assertionsDisabled = !JaasLoginService.class.desiredAssertionStatus();
        log = LogFactory.getLog((Class)JaasLoginService.class);
        nextLoginModuleId = System.currentTimeMillis();
        clockDaemon = new ClockDaemon();
        clockDaemon.setThreadFactory(new ThreadFactory(){

            public Thread newThread(Runnable r) {
                Thread t = new Thread(r, "LoginService login modules monitor");
                t.setDaemon(true);
                return t;
            }
        });
        GBeanInfoBuilder infoFactory = GBeanInfoBuilder.createStatic((Class)JaasLoginService.class, (String)"JaasLoginService");
        infoFactory.addAttribute("algorithm", String.class, true);
        infoFactory.addAttribute("password", String.class, true);
        infoFactory.addAttribute("classLoader", ClassLoader.class, false);
        infoFactory.addAttribute("maxLoginDurationMillis", Integer.TYPE, true);
        infoFactory.addAttribute("expiredLoginScanIntervalMillis", Integer.TYPE, true);
        infoFactory.addAttribute("objectName", String.class, false);
        infoFactory.addOperation("connectToRealm", new Class[]{String.class});
        infoFactory.addOperation("getLoginConfiguration", new Class[]{JaasSessionId.class});
        infoFactory.addOperation("getServerLoginCallbacks", new Class[]{JaasSessionId.class, Integer.TYPE});
        infoFactory.addOperation("performLogin", new Class[]{JaasSessionId.class, Integer.TYPE, Callback;.class});
        infoFactory.addOperation("performCommit", new Class[]{JaasSessionId.class, Integer.TYPE});
        infoFactory.addOperation("loginSucceeded", new Class[]{JaasSessionId.class});
        infoFactory.addOperation("loginFailed", new Class[]{JaasSessionId.class});
        infoFactory.addOperation("logout", new Class[]{JaasSessionId.class});
        infoFactory.addOperation("syncShareState", new Class[]{JaasSessionId.class, Map.class});
        infoFactory.addOperation("syncPrincipals", new Class[]{JaasSessionId.class, Set.class});
        infoFactory.addReference("Realms", SecurityRealm.class, "SecurityRealm");
        infoFactory.addInterface(JaasLoginServiceMBean.class);
        infoFactory.setConstructor(new String[]{"algorithm", "password", "classLoader", "objectName"});
        GBEAN_INFO = infoFactory.getBeanInfo();
    }

    private class ExpirationMonitor
    implements Runnable {
        private ExpirationMonitor() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            long now = System.currentTimeMillis();
            LinkedList<JaasSecuritySession> list = new LinkedList<JaasSecuritySession>();
            Map map = JaasLoginService.this.activeLogins;
            synchronized (map) {
                Iterator it = JaasLoginService.this.activeLogins.keySet().iterator();
                while (it.hasNext()) {
                    JaasSessionId id = (JaasSessionId)it.next();
                    JaasSecuritySession session = (JaasSecuritySession)JaasLoginService.this.activeLogins.get(id);
                    int age = (int)(now - session.getCreated());
                    if (!session.isDone() && age <= JaasLoginService.this.maxLoginDurationMillis) continue;
                    list.add(session);
                    session.setDone(true);
                    it.remove();
                }
            }
            Iterator it = list.iterator();
            while (it.hasNext()) {
                JaasSecuritySession session = (JaasSecuritySession)it.next();
                ContextManager.unregisterSubject(session.getSubject());
            }
        }
    }
}

