/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.security.keystore;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.net.URI;
import java.security.InvalidKeyException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geronimo.gbean.AbstractName;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoBuilder;
import org.apache.geronimo.gbean.GBeanLifecycle;
import org.apache.geronimo.kernel.Kernel;
import org.apache.geronimo.management.geronimo.KeystoreInstance;
import org.apache.geronimo.management.geronimo.KeystoreIsLocked;
import org.apache.geronimo.system.serverinfo.ServerInfo;
import org.apache.geronimo.util.asn1.DERObjectIdentifier;
import org.apache.geronimo.util.asn1.x509.X509Name;
import org.apache.geronimo.util.jce.X509Principal;
import org.apache.geronimo.util.jce.X509V1CertificateGenerator;

public class FileKeystoreInstance
implements KeystoreInstance,
GBeanLifecycle {
    private static final Log log = LogFactory.getLog((Class)FileKeystoreInstance.class);
    static final String JKS = "JKS";
    private URI keystorePath;
    private ServerInfo serverInfo;
    private File keystoreFile;
    private String keystoreName;
    private char[] keystorePassword;
    private Map keyPasswords = new HashMap();
    private Kernel kernel;
    private AbstractName abstractName;
    private char[] openPassword;
    private List privateKeys = new ArrayList();
    private List trustCerts = new ArrayList();
    private KeyStore keystore;
    private long keystoreReadDate = Long.MIN_VALUE;
    public static final GBeanInfo GBEAN_INFO;

    public FileKeystoreInstance(ServerInfo serverInfo, URI keystorePath, String keystoreName, String keystorePassword, String keyPasswords, Kernel kernel, AbstractName abstractName) {
        this.serverInfo = serverInfo;
        this.keystorePath = keystorePath;
        this.keystoreName = keystoreName;
        this.kernel = kernel;
        this.abstractName = abstractName;
        char[] cArray = this.keystorePassword = keystorePassword == null ? null : keystorePassword.toCharArray();
        if (keyPasswords != null) {
            String[] keys = keyPasswords.split("\\]\\!\\[");
            for (int i = 0; i < keys.length; ++i) {
                String key = keys[i];
                int pos = key.indexOf(61);
                this.keyPasswords.put(key.substring(0, pos), key.substring(pos + 1).toCharArray());
            }
        }
    }

    public void doStart() throws Exception {
        this.keystoreFile = new File(this.serverInfo.resolveServer(this.keystorePath));
        if (!this.keystoreFile.exists() || !this.keystoreFile.canRead()) {
            throw new IllegalArgumentException("Invalid keystore file (" + this.keystorePath + " = " + this.keystoreFile.getAbsolutePath() + ")");
        }
    }

    public void doStop() throws Exception {
    }

    public void doFail() {
    }

    public String getKeystoreName() {
        return this.keystoreName;
    }

    public boolean unlockKeystore(char[] password) {
        try {
            this.kernel.setAttribute(this.abstractName, "keystorePassword", (Object)(password == null ? null : new String(password)));
        }
        catch (Exception e) {
            throw (IllegalStateException)new IllegalStateException("Unable to set attribute keystorePassword on myself!").initCause(e);
        }
        return true;
    }

    public void setKeystorePassword(String password) {
        this.keystorePassword = password == null ? null : password.toCharArray();
    }

    public void lockKeystore() {
        try {
            this.kernel.setAttribute(this.abstractName, "keystorePassword", null);
            this.keyPasswords.clear();
            this.storePasswords();
        }
        catch (Exception e) {
            throw (IllegalStateException)new IllegalStateException("Unable to set attribute keystorePassword on myself!").initCause(e);
        }
    }

    public boolean isKeystoreLocked() {
        return this.keystorePassword == null;
    }

    public String[] listPrivateKeys(char[] storePassword) {
        if (!this.isLoaded(storePassword) && !this.loadKeystoreData(storePassword)) {
            return null;
        }
        return this.privateKeys.toArray(new String[this.privateKeys.size()]);
    }

    public boolean unlockPrivateKey(String alias, char[] password) throws KeystoreIsLocked {
        if (this.isKeystoreLocked()) {
            throw new KeystoreIsLocked("Keystore '" + this.keystoreName + "' is locked!");
        }
        this.keyPasswords.put(alias, password);
        this.storePasswords();
        return true;
    }

    public String[] getUnlockedKeys() throws KeystoreIsLocked {
        if (this.isKeystoreLocked()) {
            throw new KeystoreIsLocked("Keystore '" + this.keystoreName + "' is locked; please unlock it in the console.");
        }
        if (this.keystore == null || this.keystoreReadDate < this.keystoreFile.lastModified()) {
            this.loadKeystoreData(this.keystorePassword);
        }
        return this.keyPasswords.keySet().toArray(new String[this.keyPasswords.size()]);
    }

    public boolean isTrustStore() throws KeystoreIsLocked {
        if (this.isKeystoreLocked()) {
            throw new KeystoreIsLocked("Keystore '" + this.keystoreName + "' is locked; please unlock it in the console.");
        }
        if (this.keystore == null || this.keystoreReadDate < this.keystoreFile.lastModified()) {
            this.loadKeystoreData(this.keystorePassword);
        }
        return this.trustCerts.size() > 0;
    }

    public void lockPrivateKey(String alias) {
        this.keyPasswords.remove(alias);
        this.storePasswords();
    }

    private void storePasswords() {
        StringBuffer buf = new StringBuffer();
        Iterator it = this.keyPasswords.entrySet().iterator();
        while (it.hasNext()) {
            if (buf.length() > 0) {
                buf.append("]![");
            }
            Map.Entry entry = it.next();
            buf.append(entry.getKey()).append("=").append(entry.getValue());
        }
        try {
            this.kernel.setAttribute(this.abstractName, "keyPasswords", (Object)(buf.length() == 0 ? null : buf.toString()));
        }
        catch (Exception e) {
            log.error((Object)("Unable to save key passwords in keystore '" + this.keystoreName + "'"), (Throwable)e);
        }
    }

    public void setKeyPasswords(String passwords) {
    }

    public boolean isKeyLocked(String alias) {
        return this.keyPasswords.get(alias) == null;
    }

    public String[] listTrustCertificates(char[] storePassword) {
        if (!this.isLoaded(storePassword) && !this.loadKeystoreData(storePassword)) {
            return null;
        }
        return this.trustCerts.toArray(new String[this.trustCerts.size()]);
    }

    public Certificate getCertificate(String alias, char[] storePassword) {
        if (!this.isLoaded(storePassword) && !this.loadKeystoreData(storePassword)) {
            return null;
        }
        try {
            return this.keystore.getCertificate(alias);
        }
        catch (KeyStoreException e) {
            log.error((Object)"Unable to read certificate from keystore", (Throwable)e);
            return null;
        }
    }

    public boolean importTrustCertificate(Certificate cert, String alias, char[] storePassword) {
        if (!this.isLoaded(storePassword) && !this.loadKeystoreData(storePassword)) {
            return false;
        }
        try {
            this.keystore.setCertificateEntry(alias, cert);
            this.trustCerts.add(alias);
            return this.saveKeystore(storePassword);
        }
        catch (KeyStoreException e) {
            log.error((Object)"Unable to import certificate", (Throwable)e);
            return false;
        }
    }

    public boolean generateKeyPair(String alias, char[] storePassword, char[] keyPassword, String keyAlgorithm, int keySize, String signatureAlgorithm, int validity, String commonName, String orgUnit, String organization, String locality, String state, String country) {
        try {
            KeyPairGenerator kpgen = KeyPairGenerator.getInstance(keyAlgorithm);
            kpgen.initialize(keySize);
            KeyPair keyPair = kpgen.generateKeyPair();
            X509Certificate cert = this.generateCertificate(keyPair.getPublic(), keyPair.getPrivate(), signatureAlgorithm, validity, commonName, orgUnit, organization, locality, state, country);
            this.keystore.setKeyEntry(alias, keyPair.getPrivate(), keyPassword, new Certificate[]{cert});
            this.privateKeys.add(alias);
            return this.saveKeystore(storePassword);
        }
        catch (SignatureException e) {
            log.error((Object)"Unable to generate key pair", (Throwable)e);
        }
        catch (InvalidKeyException e) {
            log.error((Object)"Unable to generate key pair", (Throwable)e);
        }
        catch (KeyStoreException e) {
            log.error((Object)"Unable to generate key pair", (Throwable)e);
        }
        catch (NoSuchAlgorithmException e) {
            log.error((Object)"Unable to generate key pair", (Throwable)e);
        }
        return false;
    }

    public KeyManager[] getKeyManager(String algorithm, String alias) throws NoSuchAlgorithmException, UnrecoverableKeyException, KeyStoreException, KeystoreIsLocked {
        if (this.isKeystoreLocked()) {
            throw new KeystoreIsLocked("Keystore '" + this.keystoreName + "' is locked; please unlock it in the console.");
        }
        if (this.keystore == null || this.keystoreReadDate < this.keystoreFile.lastModified()) {
            this.loadKeystoreData(this.keystorePassword);
        }
        KeyManagerFactory keyFactory = KeyManagerFactory.getInstance(algorithm);
        keyFactory.init(this.keystore, (char[])this.keyPasswords.get(alias));
        return keyFactory.getKeyManagers();
    }

    public TrustManager[] getTrustManager(String algorithm) throws KeyStoreException, NoSuchAlgorithmException, KeystoreIsLocked {
        if (this.isKeystoreLocked()) {
            throw new KeystoreIsLocked("Keystore '" + this.keystoreName + "' is locked; please unlock it in the console.");
        }
        if (this.keystore == null || this.keystoreReadDate < this.keystoreFile.lastModified()) {
            this.loadKeystoreData(this.keystorePassword);
        }
        TrustManagerFactory trustFactory = TrustManagerFactory.getInstance(algorithm);
        trustFactory.init(this.keystore);
        return trustFactory.getTrustManagers();
    }

    private boolean saveKeystore(char[] password) {
        try {
            BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(this.keystoreFile));
            this.keystore.store(out, password);
            out.flush();
            out.close();
            this.keystoreReadDate = System.currentTimeMillis();
            return true;
        }
        catch (KeyStoreException e) {
            log.error((Object)"Unable to save keystore", (Throwable)e);
        }
        catch (IOException e) {
            log.error((Object)"Unable to save keystore", (Throwable)e);
        }
        catch (NoSuchAlgorithmException e) {
            log.error((Object)"Unable to save keystore", (Throwable)e);
        }
        catch (CertificateException e) {
            log.error((Object)"Unable to save keystore", (Throwable)e);
        }
        return false;
    }

    public static GBeanInfo getGBeanInfo() {
        return GBEAN_INFO;
    }

    private boolean loadKeystoreData(char[] password) {
        try {
            this.keystoreReadDate = System.currentTimeMillis();
            this.privateKeys.clear();
            this.trustCerts.clear();
            if (this.keystore == null) {
                this.keystore = KeyStore.getInstance(JKS);
            }
            BufferedInputStream in = new BufferedInputStream(new FileInputStream(this.keystoreFile));
            this.keystore.load(in, password);
            ((InputStream)in).close();
            this.openPassword = password;
            Enumeration<String> aliases = this.keystore.aliases();
            while (aliases.hasMoreElements()) {
                String alias = aliases.nextElement();
                if (this.keystore.isKeyEntry(alias)) {
                    this.privateKeys.add(alias);
                    continue;
                }
                if (!this.keystore.isCertificateEntry(alias)) continue;
                this.trustCerts.add(alias);
            }
            return true;
        }
        catch (KeyStoreException e) {
            log.error((Object)"Unable to open keystore with provided password", (Throwable)e);
        }
        catch (IOException e) {
            log.error((Object)"Unable to open keystore with provided password", (Throwable)e);
        }
        catch (NoSuchAlgorithmException e) {
            log.error((Object)"Unable to open keystore with provided password", (Throwable)e);
        }
        catch (CertificateException e) {
            log.error((Object)"Unable to open keystore with provided password", (Throwable)e);
        }
        return false;
    }

    private boolean isLoaded(char[] password) {
        if (this.openPassword == null || this.openPassword.length != password.length) {
            return false;
        }
        if (this.keystoreReadDate < this.keystoreFile.lastModified()) {
            return false;
        }
        for (int i = 0; i < password.length; ++i) {
            if (password[i] == this.openPassword[i]) continue;
            return false;
        }
        return true;
    }

    private X509Certificate generateCertificate(PublicKey publicKey, PrivateKey privateKey, String algorithm, int validity, String commonName, String orgUnit, String organization, String locality, String state, String country) throws SignatureException, InvalidKeyException {
        X509V1CertificateGenerator certgen = new X509V1CertificateGenerator();
        Vector<DERObjectIdentifier> order = new Vector<DERObjectIdentifier>();
        Hashtable<DERObjectIdentifier, String> attrmap = new Hashtable<DERObjectIdentifier, String>();
        if (commonName != null) {
            attrmap.put(X509Principal.CN, commonName);
            order.add(X509Principal.CN);
        }
        if (orgUnit != null) {
            attrmap.put(X509Principal.OU, orgUnit);
            order.add(X509Principal.OU);
        }
        if (organization != null) {
            attrmap.put(X509Principal.O, organization);
            order.add(X509Principal.O);
        }
        if (locality != null) {
            attrmap.put(X509Principal.L, locality);
            order.add(X509Principal.L);
        }
        if (state != null) {
            attrmap.put(X509Principal.ST, state);
            order.add(X509Principal.ST);
        }
        if (country != null) {
            attrmap.put(X509Principal.C, country);
            order.add(X509Principal.C);
        }
        X509Principal issuerDN = new X509Principal(order, attrmap);
        long curr = System.currentTimeMillis();
        long untill = curr + (long)validity * 24L * 60L * 60L * 1000L;
        certgen.setNotBefore(new Date(curr));
        certgen.setNotAfter(new Date(untill));
        certgen.setIssuerDN((X509Name)issuerDN);
        certgen.setSubjectDN((X509Name)issuerDN);
        certgen.setPublicKey(publicKey);
        certgen.setSignatureAlgorithm(algorithm);
        certgen.setSerialNumber(new BigInteger(String.valueOf(curr)));
        return certgen.generateX509Certificate(privateKey);
    }

    static {
        GBeanInfoBuilder infoFactory = GBeanInfoBuilder.createStatic((Class)FileKeystoreInstance.class, (String)"Keystore");
        infoFactory.addAttribute("keystorePath", URI.class, true, false);
        infoFactory.addAttribute("keystoreName", String.class, true, false);
        infoFactory.addAttribute("keystorePassword", String.class, true, true);
        infoFactory.addAttribute("keyPasswords", String.class, true, true);
        infoFactory.addAttribute("kernel", Kernel.class, false);
        infoFactory.addAttribute("abstractName", AbstractName.class, false);
        infoFactory.addReference("ServerInfo", ServerInfo.class, "GBean");
        infoFactory.addInterface(KeystoreInstance.class);
        infoFactory.setConstructor(new String[]{"ServerInfo", "keystorePath", "keystoreName", "keystorePassword", "keyPasswords", "kernel", "abstractName"});
        GBEAN_INFO = infoFactory.getBeanInfo();
    }
}

