/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.security.realm.providers;

import java.io.IOException;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import org.apache.geronimo.security.realm.providers.CertificateCallback;
import org.apache.geronimo.security.realm.providers.CertificateChainCallback;

public class CertificateChainCallbackHandler
implements CallbackHandler {
    Certificate[] certificateChain;

    public CertificateChainCallbackHandler(Certificate[] certificateChain) {
        this.certificateChain = certificateChain;
    }

    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        for (int i = 0; i < callbacks.length; ++i) {
            Callback cc;
            Callback callback = callbacks[i];
            if (callback instanceof CertificateChainCallback) {
                cc = (CertificateChainCallback)callback;
                ((CertificateChainCallback)cc).setCertificateChain(this.certificateChain);
                continue;
            }
            if (callback instanceof CertificateCallback && this.certificateChain != null && this.certificateChain.length > 0 && this.certificateChain[0] instanceof X509Certificate) {
                cc = (CertificateCallback)callback;
                ((CertificateCallback)cc).setCertificate((X509Certificate)this.certificateChain[0]);
                continue;
            }
            throw new UnsupportedCallbackException(callback);
        }
    }
}

