/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.security.realm.providers;

import java.io.IOException;
import java.security.Principal;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.FailedLoginException;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import javax.sql.DataSource;
import org.apache.geronimo.gbean.AbstractName;
import org.apache.geronimo.gbean.AbstractNameQuery;
import org.apache.geronimo.kernel.GBeanNotFoundException;
import org.apache.geronimo.kernel.Kernel;
import org.apache.geronimo.kernel.KernelRegistry;
import org.apache.geronimo.management.geronimo.JCAManagedConnectionFactory;
import org.apache.geronimo.security.realm.providers.GeronimoGroupPrincipal;
import org.apache.geronimo.security.realm.providers.GeronimoUserPrincipal;

public class SQLLoginModule
implements LoginModule {
    public static final String USER_SELECT = "userSelect";
    public static final String GROUP_SELECT = "groupSelect";
    public static final String CONNECTION_URL = "jdbcURL";
    public static final String USER = "jdbcUser";
    public static final String PASSWORD = "jdbcPassword";
    public static final String DRIVER = "jdbcDriver";
    public static final String DATABASE_POOL_NAME = "dataSourceName";
    public static final String DATABASE_POOL_APP_NAME = "dataSourceApplication";
    private String connectionURL;
    private Properties properties;
    private Driver driver;
    private JCAManagedConnectionFactory factory;
    private String userSelect;
    private String groupSelect;
    private Subject subject;
    private CallbackHandler handler;
    private String cbUsername;
    private String cbPassword;
    private final Set groups = new HashSet();
    static /* synthetic */ Class class$javax$sql$DataSource;
    static final /* synthetic */ boolean $assertionsDisabled;

    public void initialize(Subject subject, CallbackHandler callbackHandler, Map sharedState, Map options) {
        this.subject = subject;
        this.handler = callbackHandler;
        this.userSelect = (String)options.get(USER_SELECT);
        this.groupSelect = (String)options.get(GROUP_SELECT);
        String dataSourceName = (String)options.get(DATABASE_POOL_NAME);
        if (dataSourceName != null) {
            dataSourceName = dataSourceName.trim();
            String dataSourceAppName = (String)options.get(DATABASE_POOL_APP_NAME);
            dataSourceAppName = dataSourceAppName == null || dataSourceAppName.trim().equals("") ? "null" : dataSourceAppName.trim();
            String kernelName = (String)options.get("org.apache.geronimo.security.realm.GenericSecurityRealm.KERNEL");
            Kernel kernel = KernelRegistry.getKernel((String)kernelName);
            Set set = kernel.listGBeans(new AbstractNameQuery(JCAManagedConnectionFactory.class.getName()));
            Iterator it = set.iterator();
            while (it.hasNext()) {
                AbstractName name = (AbstractName)it.next();
                if (!name.getName().get("J2EEApplication").equals(dataSourceAppName) || !name.getName().get("name").equals(dataSourceName)) continue;
                try {
                    JCAManagedConnectionFactory factory = (JCAManagedConnectionFactory)kernel.getGBean(name);
                    String type = factory.getConnectionFactoryInterface();
                    if (!type.equals((class$javax$sql$DataSource == null ? SQLLoginModule.class$("javax.sql.DataSource") : class$javax$sql$DataSource).getName())) continue;
                    this.factory = factory;
                    break;
                }
                catch (GBeanNotFoundException e) {
                }
            }
        } else {
            this.connectionURL = (String)options.get(CONNECTION_URL);
            this.properties = new Properties();
            if (options.get(USER) != null) {
                this.properties.put("user", options.get(USER));
            }
            if (options.get(PASSWORD) != null) {
                this.properties.put("password", options.get(PASSWORD));
            }
            ClassLoader cl = (ClassLoader)options.get("org.apache.geronimo.security.realm.GenericSecurityRealm.CLASSLOADER");
            try {
                this.driver = (Driver)cl.loadClass((String)options.get(DRIVER)).newInstance();
            }
            catch (ClassNotFoundException e) {
                throw new IllegalArgumentException("Driver class " + options.get(DRIVER) + " is not available.  Perhaps you need to add it as a dependency in your deployment plan?");
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Unable to load, instantiate, register driver " + options.get(DRIVER) + ": " + e.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean login() throws LoginException {
        Callback[] callbacks = new Callback[]{new NameCallback("User name"), new PasswordCallback("Password", false)};
        try {
            this.handler.handle(callbacks);
        }
        catch (IOException ioe) {
            throw (LoginException)new LoginException().initCause(ioe);
        }
        catch (UnsupportedCallbackException uce) {
            throw (LoginException)new LoginException().initCause(uce);
        }
        if (!$assertionsDisabled && callbacks.length != 2) {
            throw new AssertionError();
        }
        this.cbUsername = ((NameCallback)callbacks[0]).getName();
        if (this.cbUsername == null || this.cbUsername.equals("")) {
            return false;
        }
        char[] provided = ((PasswordCallback)callbacks[1]).getPassword();
        this.cbPassword = provided == null ? null : new String(provided);
        boolean found = false;
        try {
            Connection conn;
            if (this.factory != null) {
                DataSource ds = (DataSource)this.factory.getConnectionFactory();
                conn = ds.getConnection();
            } else {
                conn = this.driver.connect(this.connectionURL, this.properties);
            }
            try {
                String userName;
                int count;
                PreparedStatement statement = conn.prepareStatement(this.userSelect);
                try {
                    count = SQLLoginModule.countParameters(this.userSelect);
                    for (int i = 0; i < count; ++i) {
                        statement.setObject(i + 1, this.cbUsername);
                    }
                    ResultSet result = statement.executeQuery();
                    try {
                        while (result.next()) {
                            userName = result.getString(1);
                            String userPassword = result.getString(2);
                            if (!this.cbUsername.equals(userName)) continue;
                            found = this.cbPassword == null && userPassword == null || this.cbPassword != null && userPassword != null && this.cbPassword.equals(userPassword);
                            break;
                        }
                    }
                    finally {
                        result.close();
                    }
                }
                finally {
                    statement.close();
                }
                if (!found) {
                    throw new FailedLoginException();
                }
                statement = conn.prepareStatement(this.groupSelect);
                try {
                    count = SQLLoginModule.countParameters(this.groupSelect);
                    for (int i = 0; i < count; ++i) {
                        statement.setObject(i + 1, this.cbUsername);
                    }
                    ResultSet result = statement.executeQuery();
                    try {
                        while (result.next()) {
                            userName = result.getString(1);
                            String groupName = result.getString(2);
                            if (!this.cbUsername.equals(userName)) continue;
                            this.groups.add(new GeronimoGroupPrincipal(groupName));
                        }
                    }
                    finally {
                        result.close();
                    }
                }
                finally {
                    statement.close();
                }
            }
            finally {
                conn.close();
            }
        }
        catch (SQLException sqle) {
            throw (LoginException)new LoginException("SQL error").initCause(sqle);
        }
        return true;
    }

    public boolean commit() throws LoginException {
        Set<Principal> principals = this.subject.getPrincipals();
        principals.add(new GeronimoUserPrincipal(this.cbUsername));
        Iterator iter = this.groups.iterator();
        while (iter.hasNext()) {
            principals.add((Principal)iter.next());
        }
        return true;
    }

    public boolean abort() throws LoginException {
        this.cbUsername = null;
        this.cbPassword = null;
        return true;
    }

    public boolean logout() throws LoginException {
        this.cbUsername = null;
        this.cbPassword = null;
        return true;
    }

    private static int countParameters(String sql) {
        int count = 0;
        int pos = -1;
        while ((pos = sql.indexOf(63, pos + 1)) != -1) {
            ++count;
        }
        return count;
    }

    static {
        $assertionsDisabled = !SQLLoginModule.class.desiredAssertionStatus();
    }
}

