/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.security.remoting.jmx;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.geronimo.core.service.Interceptor;
import org.apache.geronimo.proxy.ProxyContainer;
import org.apache.geronimo.security.jaas.server.JaasLoginServiceMBean;
import org.apache.geronimo.security.remoting.jmx.JaasLoginServiceRemotingServer;
import org.apache.geronimo.security.remoting.jmx.RequestChannelInterceptor;

public class JaasLoginServiceRemotingClient {
    public static JaasLoginServiceMBean create(String host, int port) throws IllegalArgumentException {
        try {
            URI target = new URI("async", null, host, port, "/JMX", null, JaasLoginServiceRemotingServer.REQUIRED_OBJECT_NAME.getCanonicalName());
            return JaasLoginServiceRemotingClient.create(target);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Bad host or port.");
        }
        catch (IOException e) {
            throw new RuntimeException("IOException: " + e.getMessage(), e);
        }
    }

    public static JaasLoginServiceMBean create(URI target) throws IOException, URISyntaxException {
        ClassLoader cl = JaasLoginServiceMBean.class.getClassLoader();
        RequestChannelInterceptor remoteInterceptor = new RequestChannelInterceptor(target, cl);
        ProxyContainer clientContainer = new ProxyContainer((Interceptor)remoteInterceptor);
        return (JaasLoginServiceMBean)clientContainer.createProxy(cl, new Class[]{JaasLoginServiceMBean.class});
    }
}

