/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.transaction;

import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.InvalidTransactionException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.apache.geronimo.transaction.InheritableTransactionContext;

public class ContainerTransactionContext
extends InheritableTransactionContext {
    private final TransactionManager txnManager;
    private Transaction transaction;
    static final /* synthetic */ boolean $assertionsDisabled;

    public ContainerTransactionContext(TransactionManager txnManager) {
        this.txnManager = txnManager;
    }

    public void begin() throws SystemException, NotSupportedException {
        this.txnManager.begin();
        this.transaction = this.txnManager.getTransaction();
    }

    public void suspend() throws SystemException {
        Transaction suspendedTransaction = this.txnManager.suspend();
        if (!$assertionsDisabled && this.transaction != suspendedTransaction) {
            throw new AssertionError((Object)"suspend did not return our transaction");
        }
    }

    public void resume() throws SystemException, InvalidTransactionException {
        this.txnManager.resume(this.transaction);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit() throws HeuristicMixedException, HeuristicRollbackException, RollbackException, SystemException {
        try {
            try {
                this.flushState();
            }
            catch (Throwable t) {
                try {
                    this.txnManager.rollback();
                }
                catch (Throwable t1) {
                    log.error((Object)"Unable to roll back transaction", t1);
                }
                throw (RollbackException)new RollbackException("Could not flush state before commit").initCause(t);
            }
            try {
                this.beforeCommit();
            }
            catch (Exception e) {
                try {
                    this.txnManager.rollback();
                }
                catch (Throwable t1) {
                    log.error((Object)"Unable to roll back transaction", t1);
                }
                throw (RollbackException)new RollbackException("Could not flush state before commit").initCause((Throwable)e);
            }
            this.txnManager.commit();
            try {
                this.afterCommit(true);
            }
            catch (Exception e) {
                try {
                    this.txnManager.rollback();
                }
                catch (Throwable t1) {
                    log.error((Object)"Unable to roll back transaction", t1);
                }
                throw (RollbackException)new RollbackException("Could not flush state before commit").initCause((Throwable)e);
            }
        }
        finally {
            this.connectorAfterCommit();
            this.transaction = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollback() throws SystemException {
        try {
            this.txnManager.rollback();
        }
        finally {
            this.connectorAfterCommit();
            this.transaction = null;
        }
    }

    public boolean isActive() {
        try {
            return this.txnManager.getStatus() == 0;
        }
        catch (SystemException e) {
            return false;
        }
    }

    public Transaction getTransaction() {
        return this.transaction;
    }

    public void setRollbackOnly() throws IllegalStateException, SystemException {
        if (this.transaction == null) {
            throw new IllegalStateException("There is no transaction in progress.");
        }
        this.transaction.setRollbackOnly();
    }

    public boolean getRollbackOnly() throws SystemException {
        if (this.transaction == null) {
            throw new IllegalStateException("There is no transaction in progress.");
        }
        int status = this.transaction.getStatus();
        return status == 1 || status == 4 || status == 9;
    }

    static {
        $assertionsDisabled = !ContainerTransactionContext.class.desiredAssertionStatus();
    }
}

