/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.transaction;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.resource.spi.XATerminator;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.InvalidTransactionException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import javax.transaction.xa.XAException;
import javax.transaction.xa.Xid;
import org.apache.geronimo.gbean.GAttributeInfo;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoFactory;
import org.apache.geronimo.gbean.GOperationInfo;
import org.apache.geronimo.transaction.TransactionProxy;
import org.apache.geronimo.transaction.XAWork;
import org.apache.geronimo.transaction.manager.TransactionManagerImpl;
import org.apache.geronimo.transaction.manager.XidImporter;

public class TransactionManagerProxy
implements TransactionManager,
XATerminator,
XAWork {
    public static final GBeanInfo GBEAN_INFO;
    private final TransactionManager delegate;
    private final XidImporter importer;
    private final ThreadLocal threadTx = new ThreadLocal();
    private final Map importedTransactions = new HashMap();
    private Set activeTransactions = new HashSet();
    static final /* synthetic */ boolean $assertionsDisabled;

    public TransactionManagerProxy(TransactionManager delegate, XidImporter importer) {
        this.delegate = delegate;
        this.importer = importer;
    }

    public TransactionManagerProxy() {
        this.delegate = new TransactionManagerImpl();
        this.importer = (XidImporter)this.delegate;
    }

    public void setTransactionTimeout(int timeout) throws SystemException {
        this.delegate.setTransactionTimeout(timeout);
    }

    public void begin() throws NotSupportedException, SystemException {
        this.delegate.begin();
        this.threadTx.set(new TransactionProxy(this.delegate.getTransaction()));
    }

    public int getStatus() throws SystemException {
        Transaction tx = this.getTransaction();
        return tx != null ? tx.getStatus() : 6;
    }

    public Transaction getTransaction() throws SystemException {
        return (Transaction)this.threadTx.get();
    }

    public Transaction suspend() throws SystemException {
        Transaction tx = this.getTransaction();
        this.threadTx.set(null);
        return tx;
    }

    public void resume(Transaction tx) throws IllegalStateException, InvalidTransactionException, SystemException {
        if (this.threadTx.get() != null) {
            throw new IllegalStateException("Transaction already associated with current thread");
        }
        if (!(tx instanceof TransactionProxy)) {
            throw new InvalidTransactionException("Cannot resume foreign transaction: " + tx);
        }
        this.threadTx.set(tx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit() throws HeuristicMixedException, HeuristicRollbackException, IllegalStateException, RollbackException, SecurityException, SystemException {
        Transaction tx = this.getTransaction();
        if (tx == null) {
            throw new IllegalStateException("No transaction associated with current thread");
        }
        try {
            tx.commit();
        }
        finally {
            this.threadTx.set(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollback() throws IllegalStateException, SecurityException, SystemException {
        Transaction tx = this.getTransaction();
        if (tx == null) {
            throw new IllegalStateException("No transaction associated with current thread");
        }
        try {
            tx.rollback();
        }
        finally {
            this.threadTx.set(null);
        }
    }

    public void setRollbackOnly() throws IllegalStateException, SystemException {
        Transaction tx = this.getTransaction();
        if (tx == null) {
            throw new IllegalStateException("No transaction associated with current thread");
        }
        tx.setRollbackOnly();
    }

    public void commit(Xid xid, boolean onePhase) throws XAException {
        TransactionProxy tx = (TransactionProxy)this.importedTransactions.remove(xid);
        if (tx == null) {
            throw new XAException("No imported transaction for xid: " + xid);
        }
        try {
            int status = tx.getStatus();
            if (!$assertionsDisabled && status != 0 && status != 2) {
                throw new AssertionError();
            }
        }
        catch (SystemException e) {
            throw new XAException();
        }
        this.importer.commit(tx.getDelegate(), onePhase);
    }

    public void forget(Xid xid) throws XAException {
        TransactionProxy tx = (TransactionProxy)this.importedTransactions.remove(xid);
        if (tx == null) {
            throw new XAException("No imported transaction for xid: " + xid);
        }
        try {
            int status = tx.getStatus();
        }
        catch (SystemException e) {
            throw new XAException();
        }
        this.importer.forget(tx.getDelegate());
    }

    public int prepare(Xid xid) throws XAException {
        TransactionProxy tx = (TransactionProxy)this.importedTransactions.get(xid);
        if (tx == null) {
            throw new XAException("No imported transaction for xid: " + xid);
        }
        try {
            int status = tx.getStatus();
            if (!$assertionsDisabled && status != 0) {
                throw new AssertionError();
            }
        }
        catch (SystemException e) {
            throw new XAException();
        }
        return this.importer.prepare(tx.getDelegate());
    }

    public Xid[] recover(int arg0) throws XAException {
        throw new XAException("Not implemented.");
    }

    public void rollback(Xid xid) throws XAException {
        TransactionProxy tx = (TransactionProxy)this.importedTransactions.remove(xid);
        if (tx == null) {
            throw new XAException("No imported transaction for xid: " + xid);
        }
        try {
            int status = tx.getStatus();
            if (!$assertionsDisabled && status != 0 && status != 2) {
                throw new AssertionError();
            }
        }
        catch (SystemException e) {
            throw new XAException();
        }
        this.importer.rollback(tx.getDelegate());
    }

    public void begin(Xid xid, long txTimeoutMillis) throws XAException {
        TransactionProxy tx = (TransactionProxy)this.importedTransactions.get(xid);
        if (tx == null) {
            try {
                tx = new TransactionProxy(this.importer.importXid(xid));
            }
            catch (SystemException e) {
                throw (XAException)new XAException("Could not import xid").initCause(e);
            }
            this.importedTransactions.put(xid, tx);
        }
        if (this.activeTransactions.contains(tx)) {
            throw new XAException("Xid already active");
        }
        this.activeTransactions.add(tx);
        this.threadTx.set(tx);
        this.importer.setTransactionTimeout(txTimeoutMillis);
    }

    public void end(Xid xid) throws XAException {
        TransactionProxy tx = (TransactionProxy)this.importedTransactions.get(xid);
        if (tx == null) {
            throw new XAException("No imported transaction for xid: " + xid);
        }
        if (!this.activeTransactions.remove(tx)) {
            throw new XAException("tx not active for xid: " + xid);
        }
    }

    public static GBeanInfo getGBeanInfo() {
        return GBEAN_INFO;
    }

    static {
        $assertionsDisabled = !TransactionManagerProxy.class.desiredAssertionStatus();
        GBeanInfoFactory infoFactory = new GBeanInfoFactory(TransactionManagerProxy.class.getName());
        infoFactory.addAttribute(new GAttributeInfo("Delegate", true));
        infoFactory.addOperation(new GOperationInfo("setTransactionTimeout", new String[]{Integer.TYPE.getName()}));
        infoFactory.addOperation(new GOperationInfo("begin"));
        infoFactory.addOperation(new GOperationInfo("getStatus"));
        infoFactory.addOperation(new GOperationInfo("getTransaction"));
        infoFactory.addOperation(new GOperationInfo("suspend"));
        infoFactory.addOperation(new GOperationInfo("resume", new String[]{Transaction.class.getName()}));
        infoFactory.addOperation(new GOperationInfo("commit"));
        infoFactory.addOperation(new GOperationInfo("rollback"));
        infoFactory.addOperation(new GOperationInfo("setRollbackOnly"));
        GBEAN_INFO = infoFactory.getBeanInfo();
    }
}

