/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.transaction;

import java.io.Serializable;
import javax.resource.ResourceException;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.TransactionManager;
import javax.transaction.UserTransaction;
import org.apache.geronimo.transaction.BeanTransactionContext;
import org.apache.geronimo.transaction.TrackedConnectionAssociator;
import org.apache.geronimo.transaction.TransactionContext;
import org.apache.geronimo.transaction.UnspecifiedTransactionContext;

public class UserTransactionImpl
implements UserTransaction,
Serializable {
    private transient TransactionManager txnManager;
    private transient TrackedConnectionAssociator trackedConnectionAssociator;
    private final ThreadLocal state = new StateThreadLocal();
    private final UserTransaction ONLINE = new OnlineUserTransaction();
    private static final UserTransaction OFFLINE;
    static final /* synthetic */ boolean $assertionsDisabled;

    public UserTransactionImpl() {
        this.state.set(OFFLINE);
    }

    public void setUp(TransactionManager txnManager, TrackedConnectionAssociator trackedConnectionAssociator) {
        if (!$assertionsDisabled && this.isOnline()) {
            throw new AssertionError((Object)"Only set the tx manager when UserTransaction is offline");
        }
        this.txnManager = txnManager;
        this.trackedConnectionAssociator = trackedConnectionAssociator;
    }

    public boolean isOnline() {
        return this.state.get() == this.ONLINE;
    }

    public void setOnline(boolean online) {
        if (!$assertionsDisabled && online && this.txnManager == null) {
            throw new AssertionError((Object)"online requires a tx manager");
        }
        this.state.set(online ? this.ONLINE : OFFLINE);
    }

    private UserTransaction getUserTransaction() {
        return (UserTransaction)this.state.get();
    }

    public void begin() throws NotSupportedException, SystemException {
        this.getUserTransaction().begin();
    }

    public void commit() throws HeuristicMixedException, HeuristicRollbackException, IllegalStateException, RollbackException, SecurityException, SystemException {
        this.getUserTransaction().commit();
    }

    public int getStatus() throws SystemException {
        return this.getUserTransaction().getStatus();
    }

    public void rollback() throws IllegalStateException, SecurityException, SystemException {
        this.getUserTransaction().rollback();
    }

    public void setRollbackOnly() throws IllegalStateException, SystemException {
        this.getUserTransaction().setRollbackOnly();
    }

    public void setTransactionTimeout(int timeout) throws SystemException {
        this.getUserTransaction().setTransactionTimeout(timeout);
    }

    static {
        $assertionsDisabled = !UserTransactionImpl.class.desiredAssertionStatus();
        OFFLINE = new OfflineUserTransaction();
    }

    private static final class OfflineUserTransaction
    implements UserTransaction,
    Serializable {
        private OfflineUserTransaction() {
        }

        public void begin() throws NotSupportedException, SystemException {
            throw new IllegalStateException("Cannot use UserTransaction methods in this state");
        }

        public void commit() throws HeuristicMixedException, HeuristicRollbackException, IllegalStateException, RollbackException, SecurityException, SystemException {
            throw new IllegalStateException("Cannot use UserTransaction methods in this state");
        }

        public int getStatus() throws SystemException {
            throw new IllegalStateException("Cannot use UserTransaction methods in this state");
        }

        public void rollback() throws IllegalStateException, SecurityException, SystemException {
            throw new IllegalStateException("Cannot use UserTransaction methods in this state");
        }

        public void setRollbackOnly() throws IllegalStateException, SystemException {
            throw new IllegalStateException("Cannot use UserTransaction methods in this state");
        }

        public void setTransactionTimeout(int seconds) throws SystemException {
            throw new IllegalStateException("Cannot use UserTransaction methods in this state");
        }
    }

    private final class OnlineUserTransaction
    implements UserTransaction,
    Serializable {
        private OnlineUserTransaction() {
        }

        public int getStatus() throws SystemException {
            return UserTransactionImpl.this.txnManager.getStatus();
        }

        public void setRollbackOnly() throws IllegalStateException, SystemException {
            UserTransactionImpl.this.txnManager.setRollbackOnly();
        }

        public void setTransactionTimeout(int seconds) throws SystemException {
            UserTransactionImpl.this.txnManager.setTransactionTimeout(seconds);
        }

        public void begin() throws NotSupportedException, SystemException {
            TransactionContext ctx = TransactionContext.getContext();
            if (!(ctx instanceof UnspecifiedTransactionContext)) {
                throw new NotSupportedException("Previous Transaction has not been committed");
            }
            UnspecifiedTransactionContext oldContext = (UnspecifiedTransactionContext)ctx;
            BeanTransactionContext newContext = new BeanTransactionContext(UserTransactionImpl.this.txnManager, oldContext);
            oldContext.suspend();
            try {
                newContext.begin();
            }
            catch (SystemException e) {
                oldContext.resume();
                throw e;
            }
            catch (NotSupportedException e) {
                oldContext.resume();
                throw e;
            }
            TransactionContext.setContext(newContext);
            if (UserTransactionImpl.this.trackedConnectionAssociator != null) {
                try {
                    UserTransactionImpl.this.trackedConnectionAssociator.newTransaction();
                }
                catch (ResourceException e) {
                    throw (SystemException)new SystemException().initCause((Throwable)e);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void commit() throws HeuristicMixedException, HeuristicRollbackException, IllegalStateException, RollbackException, SecurityException, SystemException {
            TransactionContext ctx = TransactionContext.getContext();
            if (!(ctx instanceof BeanTransactionContext)) {
                throw new IllegalStateException("Transaction has not been started");
            }
            BeanTransactionContext beanContext = (BeanTransactionContext)ctx;
            try {
                beanContext.commit();
            }
            finally {
                UnspecifiedTransactionContext oldContext = beanContext.getOldContext();
                TransactionContext.setContext(oldContext);
                oldContext.resume();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void rollback() throws IllegalStateException, SecurityException, SystemException {
            TransactionContext ctx = TransactionContext.getContext();
            if (!(ctx instanceof BeanTransactionContext)) {
                throw new IllegalStateException("Transaction has not been started");
            }
            BeanTransactionContext beanContext = (BeanTransactionContext)ctx;
            try {
                beanContext.rollback();
            }
            finally {
                UnspecifiedTransactionContext oldContext = beanContext.getOldContext();
                TransactionContext.setContext(oldContext);
                oldContext.resume();
            }
        }
    }

    private static class StateThreadLocal
    extends ThreadLocal
    implements Serializable {
        private StateThreadLocal() {
        }

        protected Object initialValue() {
            return OFFLINE;
        }
    }
}

