/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.transaction.manager;

import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.InvalidTransactionException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import javax.transaction.xa.XAException;
import javax.transaction.xa.Xid;
import org.apache.geronimo.transaction.log.UnrecoverableLog;
import org.apache.geronimo.transaction.manager.TransactionImpl;
import org.apache.geronimo.transaction.manager.TransactionLog;
import org.apache.geronimo.transaction.manager.XidFactory;
import org.apache.geronimo.transaction.manager.XidImporter;

public class TransactionManagerImpl
implements TransactionManager,
XidImporter {
    private final TransactionLog txnLog;
    private final XidFactory xidFactory = new XidFactory();
    private volatile int timeout;
    private final ThreadLocal threadTx = new ThreadLocal();

    public TransactionManagerImpl() {
        this.txnLog = new UnrecoverableLog();
    }

    public TransactionManagerImpl(TransactionLog txnLog) {
        this.txnLog = txnLog;
    }

    public Transaction getTransaction() throws SystemException {
        return (Transaction)this.threadTx.get();
    }

    public void setTransactionTimeout(int seconds) throws SystemException {
        this.timeout = seconds;
    }

    public int getStatus() throws SystemException {
        Transaction tx = this.getTransaction();
        return tx != null ? tx.getStatus() : 6;
    }

    public void begin() throws NotSupportedException, SystemException {
        if (this.getStatus() != 6) {
            throw new NotSupportedException("Nested Transactions are not supported");
        }
        TransactionImpl tx = new TransactionImpl(this.xidFactory, this.txnLog);
        this.threadTx.set(tx);
    }

    public Transaction suspend() throws SystemException {
        Transaction tx = this.getTransaction();
        this.threadTx.set(null);
        return tx;
    }

    public void resume(Transaction tx) throws IllegalStateException, InvalidTransactionException, SystemException {
        if (this.threadTx.get() != null) {
            throw new IllegalStateException("Transaction already associated with current thread");
        }
        if (!(tx instanceof TransactionImpl)) {
            throw new InvalidTransactionException("Cannot resume foreign transaction: " + tx);
        }
        this.threadTx.set(tx);
    }

    public void setRollbackOnly() throws IllegalStateException, SystemException {
        Transaction tx = this.getTransaction();
        if (tx == null) {
            throw new IllegalStateException("No transaction associated with current thread");
        }
        tx.setRollbackOnly();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit() throws HeuristicMixedException, HeuristicRollbackException, IllegalStateException, RollbackException, SecurityException, SystemException {
        Transaction tx = this.getTransaction();
        if (tx == null) {
            throw new IllegalStateException("No transaction associated with current thread");
        }
        try {
            tx.commit();
        }
        finally {
            this.threadTx.set(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollback() throws IllegalStateException, SecurityException, SystemException {
        Transaction tx = this.getTransaction();
        if (tx == null) {
            throw new IllegalStateException("No transaction associated with current thread");
        }
        try {
            tx.rollback();
        }
        finally {
            this.threadTx.set(null);
        }
    }

    public Transaction importXid(Xid xid) throws XAException, SystemException {
        if (this.getStatus() != 6) {
            throw new XAException("Transaction already active in this thread");
        }
        TransactionImpl tx = new TransactionImpl(xid, this.xidFactory, this.txnLog);
        this.threadTx.set(tx);
        return tx;
    }

    public void commit(Transaction tx, boolean onePhase) throws XAException {
        if (onePhase) {
            try {
                tx.commit();
            }
            catch (HeuristicMixedException e) {
                throw new XAException();
            }
            catch (HeuristicRollbackException e) {
                throw new XAException();
            }
            catch (RollbackException e) {
                throw new XAException();
            }
            catch (SecurityException e) {
                throw new XAException();
            }
            catch (SystemException e) {
                throw new XAException();
            }
        }
        try {
            ((TransactionImpl)tx).preparedCommit();
        }
        catch (SystemException e) {
            throw new XAException();
        }
    }

    public void forget(Transaction tx) throws XAException {
    }

    public int prepare(Transaction tx) throws XAException {
        try {
            return ((TransactionImpl)tx).prepare();
        }
        catch (SystemException e) {
            throw new XAException();
        }
        catch (RollbackException e) {
            throw new XAException();
        }
    }

    public void rollback(Transaction tx) throws XAException {
        try {
            tx.rollback();
        }
        catch (IllegalStateException e) {
            throw new XAException();
        }
        catch (SystemException e) {
            throw new XAException();
        }
    }

    public void setTransactionTimeout(long milliseconds) {
    }
}

