/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.transaction.manager;

import java.net.InetAddress;
import java.net.UnknownHostException;
import javax.transaction.xa.Xid;
import org.apache.geronimo.transaction.manager.XidImpl;

public class XidFactory {
    byte[] baseId = new byte[64];
    long count = 1L;

    public XidFactory() {
        byte[] hostid;
        try {
            hostid = InetAddress.getLocalHost().getAddress();
        }
        catch (UnknownHostException e) {
            hostid = new byte[]{127, 0, 0, 1};
        }
        int uid = System.identityHashCode(this);
        this.baseId[8] = (byte)uid;
        this.baseId[9] = (byte)(uid >>> 8);
        this.baseId[10] = (byte)(uid >>> 16);
        this.baseId[11] = (byte)(uid >>> 24);
        System.arraycopy(hostid, 0, this.baseId, 12, hostid.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Xid createXid() {
        long id;
        byte[] globalId = (byte[])this.baseId.clone();
        XidFactory xidFactory = this;
        synchronized (xidFactory) {
            id = this.count++;
        }
        globalId[0] = (byte)id;
        globalId[1] = (byte)(id >>> 8);
        globalId[2] = (byte)(id >>> 16);
        globalId[3] = (byte)(id >>> 24);
        globalId[4] = (byte)(id >>> 32);
        globalId[5] = (byte)(id >>> 40);
        globalId[6] = (byte)(id >>> 48);
        globalId[7] = (byte)(id >>> 56);
        return new XidImpl(globalId);
    }

    public Xid createBranch(Xid globalId, int branch) {
        byte[] branchId = (byte[])this.baseId.clone();
        branchId[0] = (byte)branch;
        branchId[1] = (byte)(branch >>> 8);
        branchId[2] = (byte)(branch >>> 16);
        branchId[3] = (byte)(branch >>> 24);
        return new XidImpl(globalId, branchId);
    }
}

