/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.transaction.manager;

import java.io.Serializable;
import java.util.Arrays;
import javax.transaction.xa.Xid;

public class XidImpl
implements Xid,
Serializable {
    private static int FORMAT_ID = 1197822575;
    private final byte[] globalId;
    private final byte[] branchId;
    private final int hash;

    public XidImpl(byte[] globalId) {
        this.globalId = globalId;
        this.hash = this.hash(0, globalId);
        this.branchId = new byte[64];
    }

    public XidImpl(Xid global, byte[] branch) {
        int hash;
        if (global instanceof XidImpl) {
            this.globalId = ((XidImpl)global).globalId;
            hash = ((XidImpl)global).hash;
        } else {
            this.globalId = global.getGlobalTransactionId();
            hash = this.hash(0, this.globalId);
        }
        this.branchId = branch;
        this.hash = this.hash(hash, this.branchId);
    }

    private int hash(int hash, byte[] id) {
        for (int i = 0; i < id.length; ++i) {
            hash = hash * 37 + id[i];
        }
        return hash;
    }

    public int getFormatId() {
        return FORMAT_ID;
    }

    public byte[] getGlobalTransactionId() {
        return (byte[])this.globalId.clone();
    }

    public byte[] getBranchQualifier() {
        return (byte[])this.branchId.clone();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof XidImpl)) {
            return false;
        }
        XidImpl other = (XidImpl)obj;
        return Arrays.equals(this.globalId, other.globalId) && Arrays.equals(this.branchId, other.branchId);
    }

    public int hashCode() {
        return this.hash;
    }

    public String toString() {
        int i;
        StringBuffer s = new StringBuffer();
        s.append("[globalId=");
        for (i = 0; i < this.globalId.length; ++i) {
            s.append(Integer.toHexString(this.globalId[i]));
        }
        s.append(",branchId=");
        for (i = 0; i < this.branchId.length; ++i) {
            s.append(Integer.toHexString(this.branchId[i]));
        }
        s.append("]");
        return s.toString();
    }
}

