/*
 * Decompiled with CFR 0.152.
 */
package info.archinnov.achilles.embedded;

import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.ProtocolOptions;
import com.datastax.driver.core.ProtocolVersion;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.policies.LoadBalancingPolicy;
import com.datastax.driver.core.policies.ReconnectionPolicy;
import com.datastax.driver.core.policies.RetryPolicy;
import info.archinnov.achilles.embedded.ServerStarter;
import info.archinnov.achilles.script.ScriptExecutor;
import info.archinnov.achilles.type.TypedMap;
import info.archinnov.achilles.validation.Validator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AchillesInitializer {
    private static final AtomicBoolean STARTED = new AtomicBoolean(false);
    private static final Logger LOGGER = LoggerFactory.getLogger(AchillesInitializer.class);
    private static final Pattern KEYSPACE_NAME_PATTERN = Pattern.compile("[a-zA-Z][_a-zA-Z0-9]{0,31}");
    private Cluster singletonCluster;
    private Session singletonSession;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void initializeFromParameters(String cassandraHost, TypedMap parameters) {
        AtomicBoolean atomicBoolean = STARTED;
        synchronized (atomicBoolean) {
            String keyspaceName = this.extractAndValidateKeyspaceName(parameters);
            Boolean durableWrite = (Boolean)parameters.getTyped("keyspaceDurableWrite");
            if (!STARTED.get()) {
                LOGGER.debug("Creating cluster and session singletons");
                this.singletonCluster = this.initializeCluster(cassandraHost, parameters);
                Session tempSession = this.singletonCluster.connect();
                this.createKeyspaceIfNeeded(tempSession, keyspaceName, durableWrite);
                tempSession.close();
                this.singletonSession = this.singletonCluster.connect(keyspaceName);
                ServerStarter.CASSANDRA_EMBEDDED.getShutdownHook().addSession(this.singletonSession);
                this.executeStartupScripts(this.singletonSession, parameters);
                STARTED.getAndSet(true);
            } else {
                LOGGER.debug("Cluster and session singletons already created");
                this.createKeyspaceIfNeeded(this.singletonSession, keyspaceName, durableWrite);
                boolean useSingletonSession = this.singletonSession.getLoggedKeyspace().toLowerCase().equals(keyspaceName.toLowerCase());
                Session tempSession = useSingletonSession ? this.singletonSession : this.singletonCluster.connect(keyspaceName);
                this.executeStartupScripts(tempSession, parameters);
                if (!useSingletonSession) {
                    tempSession.close();
                }
            }
        }
    }

    private Cluster initializeCluster(String cassandraHost, TypedMap parameters) {
        int cqlPort;
        String hostname;
        if (StringUtils.isNotBlank((CharSequence)cassandraHost) && cassandraHost.contains(":")) {
            String[] split = cassandraHost.split(":");
            hostname = split[0];
            cqlPort = Integer.parseInt(split[1]);
        } else {
            hostname = (String)parameters.getTyped("rpcAddress");
            cqlPort = (Integer)parameters.getTyped("cqlPort");
        }
        return this.createCluster(hostname, cqlPort, parameters);
    }

    private Cluster createCluster(String host, int cqlPort, TypedMap parameters) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Creating Cluster object with host/port {}/{} and parameters {}", new Object[]{host, cqlPort, parameters});
        }
        String clusterName = (String)parameters.getTyped("clusterName");
        ProtocolOptions.Compression compression = (ProtocolOptions.Compression)parameters.getTyped("compressionType");
        LoadBalancingPolicy loadBalancingPolicy = (LoadBalancingPolicy)parameters.getTyped("loadBalancingPolicy");
        RetryPolicy retryPolicy = (RetryPolicy)parameters.getTyped("retryPolicy");
        ReconnectionPolicy reconnectionPolicy = (ReconnectionPolicy)parameters.getTyped("reconnectionPolicy");
        Cluster cluster = Cluster.builder().addContactPoint(host).withPort(cqlPort).withClusterName(clusterName).withCompression(compression).withLoadBalancingPolicy(loadBalancingPolicy).withRetryPolicy(retryPolicy).withReconnectionPolicy(reconnectionPolicy).withProtocolVersion(ProtocolVersion.NEWEST_SUPPORTED).build();
        ServerStarter.CASSANDRA_EMBEDDED.getShutdownHook().addCluster(cluster);
        return cluster;
    }

    private String extractAndValidateKeyspaceName(TypedMap parameters) {
        String keyspaceName = (String)parameters.getTyped("defaultKeyspaceName");
        Validator.validateNotBlank((String)keyspaceName, (String)"The provided keyspace name should not be blank", (Object[])new Object[0]);
        Validator.validateTrue((boolean)KEYSPACE_NAME_PATTERN.matcher(keyspaceName).matches(), (String)"The provided keyspace name '%s' should match the following pattern : '%s'", (Object[])new Object[]{keyspaceName, KEYSPACE_NAME_PATTERN.pattern()});
        return keyspaceName;
    }

    private void createKeyspaceIfNeeded(Session session, String keyspaceName, Boolean keyspaceDurableWrite) {
        StringBuilder createKeyspaceStatement = new StringBuilder("CREATE keyspace IF NOT EXISTS ");
        createKeyspaceStatement.append(keyspaceName);
        createKeyspaceStatement.append(" WITH REPLICATION = {'class':'SimpleStrategy', 'replication_factor':1}");
        if (!keyspaceDurableWrite.booleanValue()) {
            createKeyspaceStatement.append(" AND DURABLE_WRITES=false");
        }
        String query = createKeyspaceStatement.toString();
        LOGGER.info("Creating keyspace : " + query);
        session.execute(query);
    }

    private void executeStartupScripts(Session session, TypedMap parameters) {
        Map scriptTemplates;
        ScriptExecutor scriptExecutor = null;
        List scriptLocations = (List)parameters.getTypedOr("scriptLocations", new ArrayList());
        if (scriptLocations.size() > 0) {
            scriptExecutor = new ScriptExecutor(session);
            scriptLocations.forEach(arg_0 -> ((ScriptExecutor)scriptExecutor).executeScript(arg_0));
        }
        if ((scriptTemplates = (Map)parameters.getTypedOr("scriptTemplates", new HashMap())).size() > 0) {
            ScriptExecutor executor = scriptExecutor = scriptExecutor == null ? new ScriptExecutor(session) : scriptExecutor;
            scriptTemplates.entrySet().forEach(entry -> executor.executeScriptTemplate((String)entry.getKey(), (Map)entry.getValue()));
        }
    }

    public Cluster getSingletonCluster() {
        return this.singletonCluster;
    }

    public Session getSingletonSession() {
        return this.singletonSession;
    }
}

