/*
 * Decompiled with CFR 0.152.
 */
package info.archinnov.achilles.embedded;

import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.Session;
import info.archinnov.achilles.embedded.AchillesInitializer;
import info.archinnov.achilles.embedded.CassandraEmbeddedConfigParameters;
import info.archinnov.achilles.embedded.ServerStarter;
import info.archinnov.achilles.type.TypedMap;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CassandraEmbeddedServer {
    public static final Logger LOGGER = LoggerFactory.getLogger(CassandraEmbeddedServer.class);
    public static final String CASSANDRA_HOST = "cassandraHost";
    static final Object SEMAPHORE = new Object();
    static boolean embeddedServerStarted = false;
    private static final AchillesInitializer initializer = new AchillesInitializer();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CassandraEmbeddedServer(TypedMap originalParameters) {
        LOGGER.trace("Start Cassandra Embedded server with server and Achilles config");
        TypedMap parameters = CassandraEmbeddedConfigParameters.mergeWithDefaultParameters(originalParameters);
        String cassandraHost = System.getProperty(CASSANDRA_HOST);
        if (StringUtils.isBlank((CharSequence)cassandraHost)) {
            Object object = SEMAPHORE;
            synchronized (object) {
                if (!embeddedServerStarted) {
                    ServerStarter.CASSANDRA_EMBEDDED.startServer(cassandraHost, parameters);
                    embeddedServerStarted = true;
                } else {
                    ServerStarter.CASSANDRA_EMBEDDED.checkAndConfigurePorts(parameters);
                }
            }
        }
        initializer.initializeFromParameters(cassandraHost, parameters);
    }

    public Cluster getNativeCluster() {
        return initializer.getSingletonCluster();
    }

    public Session getNativeSession() {
        return initializer.getSingletonSession();
    }

    public void registerSessionForShutdown(Session session) {
        ServerStarter.CASSANDRA_EMBEDDED.getShutdownHook().addSession(session);
    }
}

