/*
 * Decompiled with CFR 0.152.
 */
package info.archinnov.achilles.embedded;

import info.archinnov.achilles.embedded.CassandraEmbeddedServer;
import info.archinnov.achilles.embedded.OrderedShutdownHook;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.cassandra.service.CassandraDaemon;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CassandraShutDownHook {
    private static final Logger LOGGER = LoggerFactory.getLogger(CassandraShutDownHook.class);
    private AtomicReference<CassandraDaemon> cassandraDaemonRef;
    private OrderedShutdownHook orderedShutdownHook;
    private ExecutorService executor;

    void addCassandraDaemonRef(AtomicReference<CassandraDaemon> cassandraDaemonRef) {
        this.cassandraDaemonRef = cassandraDaemonRef;
    }

    void addOrderedShutdownHook(OrderedShutdownHook orderedShutdownHook) {
        this.orderedShutdownHook = orderedShutdownHook;
    }

    void addExecutorService(ExecutorService executor) {
        this.executor = executor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutDownNow() throws InterruptedException {
        Object object = CassandraEmbeddedServer.SEMAPHORE;
        synchronized (object) {
            LOGGER.info("Calling stop on Embedded Cassandra server");
            this.cassandraDaemonRef.get().stop();
            LOGGER.info("Calling shutdown on all Cluster instances");
            this.orderedShutdownHook.callShutDown();
            LOGGER.info("Shutting down embedded Cassandra server");
            this.executor.shutdownNow();
            CassandraEmbeddedServer.embeddedServerStarted = false;
        }
    }
}

