package arrow.mtl.extensions.eithert.applicativeError

import arrow.Kind
import arrow.core.Either
import arrow.core.ForOption
import arrow.core.ForTry
import arrow.mtl.EitherT
import arrow.mtl.EitherT.Companion
import arrow.mtl.ForEitherT
import arrow.mtl.extensions.EitherTApplicativeError
import arrow.typeclasses.ApplicativeError
import kotlin.Function0
import kotlin.Function1
import kotlin.Suppress
import kotlin.Throwable
import kotlin.jvm.JvmName

@JvmName("handleErrorWith")
@Suppress(
    "UNCHECKED_CAST",
    "USELESS_CAST",
    "EXTENSION_SHADOWED_BY_MEMBER",
    "UNUSED_PARAMETER"
)
fun <F, L, A> Kind<Kind<Kind<ForEitherT, F>, L>, A>.handleErrorWith(AE: ApplicativeError<F, L>,
    arg1: Function1<L, Kind<Kind<Kind<ForEitherT, F>, L>, A>>): EitherT<F, L, A> =
    arrow.mtl.EitherT.applicativeError<F, L>(AE).run {
  this@handleErrorWith.handleErrorWith<A>(arg1) as arrow.mtl.EitherT<F, L, A>
}

@JvmName("raiseError1")
@Suppress(
    "UNCHECKED_CAST",
    "USELESS_CAST",
    "EXTENSION_SHADOWED_BY_MEMBER",
    "UNUSED_PARAMETER"
)
fun <F, L, A> L.raiseError(AE: ApplicativeError<F, L>): EitherT<F, L, A> =
    arrow.mtl.EitherT.applicativeError<F, L>(AE).run {
  this@raiseError.raiseError<A>() as arrow.mtl.EitherT<F, L, A>
}

@JvmName("fromOption")
@Suppress(
    "UNCHECKED_CAST",
    "USELESS_CAST",
    "EXTENSION_SHADOWED_BY_MEMBER",
    "UNUSED_PARAMETER"
)
fun <F, L, A> Kind<ForOption, A>.fromOption(AE: ApplicativeError<F, L>, arg1: Function0<L>):
    EitherT<F, L, A> = arrow.mtl.EitherT.applicativeError<F, L>(AE).run {
  this@fromOption.fromOption<A>(arg1) as arrow.mtl.EitherT<F, L, A>
}

@JvmName("fromEither")
@Suppress(
    "UNCHECKED_CAST",
    "USELESS_CAST",
    "EXTENSION_SHADOWED_BY_MEMBER",
    "UNUSED_PARAMETER"
)
fun <F, L, A, EE> Either<EE, A>.fromEither(AE: ApplicativeError<F, L>, arg1: Function1<EE, L>):
    EitherT<F, L, A> = arrow.mtl.EitherT.applicativeError<F, L>(AE).run {
  this@fromEither.fromEither<A, EE>(arg1) as arrow.mtl.EitherT<F, L, A>
}

@JvmName("fromTry")
@Suppress(
    "UNCHECKED_CAST",
    "USELESS_CAST",
    "EXTENSION_SHADOWED_BY_MEMBER",
    "UNUSED_PARAMETER"
)
fun <F, L, A> Kind<ForTry, A>.fromTry(AE: ApplicativeError<F, L>, arg1: Function1<Throwable, L>):
    EitherT<F, L, A> = arrow.mtl.EitherT.applicativeError<F, L>(AE).run {
  this@fromTry.fromTry<A>(arg1) as arrow.mtl.EitherT<F, L, A>
}

@JvmName("handleError")
@Suppress(
    "UNCHECKED_CAST",
    "USELESS_CAST",
    "EXTENSION_SHADOWED_BY_MEMBER",
    "UNUSED_PARAMETER"
)
fun <F, L, A> Kind<Kind<Kind<ForEitherT, F>, L>, A>.handleError(AE: ApplicativeError<F, L>,
    arg1: Function1<L, A>): EitherT<F, L, A> = arrow.mtl.EitherT.applicativeError<F, L>(AE).run {
  this@handleError.handleError<A>(arg1) as arrow.mtl.EitherT<F, L, A>
}

@JvmName("redeem")
@Suppress(
    "UNCHECKED_CAST",
    "USELESS_CAST",
    "EXTENSION_SHADOWED_BY_MEMBER",
    "UNUSED_PARAMETER"
)
fun <F, L, A, B> Kind<Kind<Kind<ForEitherT, F>, L>, A>.redeem(
  AE: ApplicativeError<F, L>,
  arg1: Function1<L, B>,
  arg2: Function1<A, B>
): EitherT<F, L, B> = arrow.mtl.EitherT.applicativeError<F, L>(AE).run {
  this@redeem.redeem<A, B>(arg1, arg2) as arrow.mtl.EitherT<F, L, B>
}

@JvmName("attempt")
@Suppress(
    "UNCHECKED_CAST",
    "USELESS_CAST",
    "EXTENSION_SHADOWED_BY_MEMBER",
    "UNUSED_PARAMETER"
)
fun <F, L, A> Kind<Kind<Kind<ForEitherT, F>, L>, A>.attempt(AE: ApplicativeError<F, L>): EitherT<F,
    L, Either<L, A>> = arrow.mtl.EitherT.applicativeError<F, L>(AE).run {
  this@attempt.attempt<A>() as arrow.mtl.EitherT<F, L, arrow.core.Either<L, A>>
}

@JvmName("catch")
@Suppress(
    "UNCHECKED_CAST",
    "USELESS_CAST",
    "EXTENSION_SHADOWED_BY_MEMBER",
    "UNUSED_PARAMETER"
)
fun <F, L, A> catch(
  AE: ApplicativeError<F, L>,
  arg0: Function1<Throwable, L>,
  arg1: Function0<A>
): EitherT<F, L, A> = arrow.mtl.EitherT
   .applicativeError<F, L>(AE)
   .catch<A>(arg0, arg1) as arrow.mtl.EitherT<F, L, A>

@JvmName("catch")
@Suppress(
    "UNCHECKED_CAST",
    "USELESS_CAST",
    "EXTENSION_SHADOWED_BY_MEMBER",
    "UNUSED_PARAMETER"
)
fun <F, L, A> ApplicativeError<Kind<Kind<ForEitherT, F>, L>,
    Throwable>.catch(AE: ApplicativeError<F, L>, arg1: Function0<A>): EitherT<F, L, A> =
    arrow.mtl.EitherT.applicativeError<F, L>(AE).run {
  this@catch.catch<A>(arg1) as arrow.mtl.EitherT<F, L, A>
}

@Suppress(
    "UNCHECKED_CAST",
    "NOTHING_TO_INLINE"
)
inline fun <F, L> Companion.applicativeError(AE: ApplicativeError<F, L>): EitherTApplicativeError<F,
    L> = object : arrow.mtl.extensions.EitherTApplicativeError<F, L> { override fun AE():
    arrow.typeclasses.ApplicativeError<F, L> = AE }