package arrow.mtl.extensions.eithert.contravariant

import arrow.Kind
import arrow.mtl.EitherT
import arrow.mtl.EitherT.Companion
import arrow.mtl.ForEitherT
import arrow.mtl.extensions.EitherTContravariant
import arrow.typeclasses.Contravariant
import kotlin.Function1
import kotlin.Suppress
import kotlin.jvm.JvmName

@JvmName("contramap")
@Suppress(
    "UNCHECKED_CAST",
    "USELESS_CAST",
    "EXTENSION_SHADOWED_BY_MEMBER",
    "UNUSED_PARAMETER"
)
fun <F, L, A, B> Kind<Kind<Kind<ForEitherT, F>, L>, A>.contramap(CF: Contravariant<F>,
    arg1: Function1<B, A>): EitherT<F, L, B> = arrow.mtl.EitherT.contravariant<F, L>(CF).run {
  this@contramap.contramap<A, B>(arg1) as arrow.mtl.EitherT<F, L, B>
}

@JvmName("lift1")
@Suppress(
    "UNCHECKED_CAST",
    "USELESS_CAST",
    "EXTENSION_SHADOWED_BY_MEMBER",
    "UNUSED_PARAMETER"
)
fun <F, L, A, B> lift(CF: Contravariant<F>, arg0: Function1<A, B>):
    Function1<Kind<Kind<Kind<ForEitherT, F>, L>, B>, Kind<Kind<Kind<ForEitherT, F>, L>, A>> =
    arrow.mtl.EitherT
   .contravariant<F, L>(CF)
   .lift<A, B>(arg0) as kotlin.Function1<arrow.Kind<arrow.Kind<arrow.Kind<arrow.mtl.ForEitherT, F>,
    L>, B>, arrow.Kind<arrow.Kind<arrow.Kind<arrow.mtl.ForEitherT, F>, L>, A>>

@JvmName("imap")
@Suppress(
    "UNCHECKED_CAST",
    "USELESS_CAST",
    "EXTENSION_SHADOWED_BY_MEMBER",
    "UNUSED_PARAMETER"
)
fun <F, L, A, B> Kind<Kind<Kind<ForEitherT, F>, L>, A>.imap(
  CF: Contravariant<F>,
  arg1: Function1<A, B>,
  arg2: Function1<B, A>
): EitherT<F, L, B> = arrow.mtl.EitherT.contravariant<F, L>(CF).run {
  this@imap.imap<A, B>(arg1, arg2) as arrow.mtl.EitherT<F, L, B>
}

@JvmName("narrow")
@Suppress(
    "UNCHECKED_CAST",
    "USELESS_CAST",
    "EXTENSION_SHADOWED_BY_MEMBER",
    "UNUSED_PARAMETER"
)
fun <F, L, A, B : A> Kind<Kind<Kind<ForEitherT, F>, L>, A>.narrow(CF: Contravariant<F>): EitherT<F,
    L, B> = arrow.mtl.EitherT.contravariant<F, L>(CF).run {
  this@narrow.narrow<A, B>() as arrow.mtl.EitherT<F, L, B>
}

@Suppress(
    "UNCHECKED_CAST",
    "NOTHING_TO_INLINE"
)
inline fun <F, L> Companion.contravariant(CF: Contravariant<F>): EitherTContravariant<F, L> = object
    : arrow.mtl.extensions.EitherTContravariant<F, L> { override fun CF():
    arrow.typeclasses.Contravariant<F> = CF }