package arrow.mtl.extensions.eithert.monad

import arrow.Kind
import arrow.core.Either
import arrow.core.Eval
import arrow.core.Tuple2
import arrow.mtl.EitherT
import arrow.mtl.EitherT.Companion
import arrow.mtl.ForEitherT
import arrow.mtl.extensions.EitherTMonad
import arrow.typeclasses.Monad
import kotlin.Boolean
import kotlin.Function0
import kotlin.Function1
import kotlin.Suppress
import kotlin.jvm.JvmName

@JvmName("flatMap")
@Suppress(
    "UNCHECKED_CAST",
    "USELESS_CAST",
    "EXTENSION_SHADOWED_BY_MEMBER",
    "UNUSED_PARAMETER"
)
fun <F, L, A, B> Kind<Kind<Kind<ForEitherT, F>, L>, A>.flatMap(MF: Monad<F>, arg1: Function1<A,
    Kind<Kind<Kind<ForEitherT, F>, L>, B>>): EitherT<F, L, B> = arrow.mtl.EitherT.monad<F,
    L>(MF).run {
  this@flatMap.flatMap<A, B>(arg1) as arrow.mtl.EitherT<F, L, B>
}

@JvmName("tailRecM")
@Suppress(
    "UNCHECKED_CAST",
    "USELESS_CAST",
    "EXTENSION_SHADOWED_BY_MEMBER",
    "UNUSED_PARAMETER"
)
fun <F, L, A, B> tailRecM(
  MF: Monad<F>,
  arg0: A,
  arg1: Function1<A, Kind<Kind<Kind<ForEitherT, F>, L>, Either<A, B>>>
): EitherT<F, L, B> = arrow.mtl.EitherT
   .monad<F, L>(MF)
   .tailRecM<A, B>(arg0, arg1) as arrow.mtl.EitherT<F, L, B>

@JvmName("map")
@Suppress(
    "UNCHECKED_CAST",
    "USELESS_CAST",
    "EXTENSION_SHADOWED_BY_MEMBER",
    "UNUSED_PARAMETER"
)
fun <F, L, A, B> Kind<Kind<Kind<ForEitherT, F>, L>, A>.map(MF: Monad<F>, arg1: Function1<A, B>):
    EitherT<F, L, B> = arrow.mtl.EitherT.monad<F, L>(MF).run {
  this@map.map<A, B>(arg1) as arrow.mtl.EitherT<F, L, B>
}

@JvmName("ap")
@Suppress(
    "UNCHECKED_CAST",
    "USELESS_CAST",
    "EXTENSION_SHADOWED_BY_MEMBER",
    "UNUSED_PARAMETER"
)
fun <F, L, A, B> Kind<Kind<Kind<ForEitherT, F>, L>, A>.ap(MF: Monad<F>,
    arg1: Kind<Kind<Kind<ForEitherT, F>, L>, Function1<A, B>>): EitherT<F, L, B> =
    arrow.mtl.EitherT.monad<F, L>(MF).run {
  this@ap.ap<A, B>(arg1) as arrow.mtl.EitherT<F, L, B>
}

@JvmName("flatten")
@Suppress(
    "UNCHECKED_CAST",
    "USELESS_CAST",
    "EXTENSION_SHADOWED_BY_MEMBER",
    "UNUSED_PARAMETER"
)
fun <F, L, A> Kind<Kind<Kind<ForEitherT, F>, L>, Kind<Kind<Kind<ForEitherT, F>, L>,
    A>>.flatten(MF: Monad<F>): EitherT<F, L, A> = arrow.mtl.EitherT.monad<F, L>(MF).run {
  this@flatten.flatten<A>() as arrow.mtl.EitherT<F, L, A>
}

@JvmName("followedBy")
@Suppress(
    "UNCHECKED_CAST",
    "USELESS_CAST",
    "EXTENSION_SHADOWED_BY_MEMBER",
    "UNUSED_PARAMETER"
)
fun <F, L, A, B> Kind<Kind<Kind<ForEitherT, F>, L>, A>.followedBy(MF: Monad<F>,
    arg1: Kind<Kind<Kind<ForEitherT, F>, L>, B>): EitherT<F, L, B> = arrow.mtl.EitherT.monad<F,
    L>(MF).run {
  this@followedBy.followedBy<A, B>(arg1) as arrow.mtl.EitherT<F, L, B>
}

@JvmName("followedByEval")
@Suppress(
    "UNCHECKED_CAST",
    "USELESS_CAST",
    "EXTENSION_SHADOWED_BY_MEMBER",
    "UNUSED_PARAMETER"
)
fun <F, L, A, B> Kind<Kind<Kind<ForEitherT, F>, L>, A>.followedByEval(MF: Monad<F>,
    arg1: Eval<Kind<Kind<Kind<ForEitherT, F>, L>, B>>): EitherT<F, L, B> =
    arrow.mtl.EitherT.monad<F, L>(MF).run {
  this@followedByEval.followedByEval<A, B>(arg1) as arrow.mtl.EitherT<F, L, B>
}

@JvmName("effectM")
@Suppress(
    "UNCHECKED_CAST",
    "USELESS_CAST",
    "EXTENSION_SHADOWED_BY_MEMBER",
    "UNUSED_PARAMETER"
)
fun <F, L, A, B> Kind<Kind<Kind<ForEitherT, F>, L>, A>.effectM(MF: Monad<F>, arg1: Function1<A,
    Kind<Kind<Kind<ForEitherT, F>, L>, B>>): EitherT<F, L, A> = arrow.mtl.EitherT.monad<F,
    L>(MF).run {
  this@effectM.effectM<A, B>(arg1) as arrow.mtl.EitherT<F, L, A>
}

@JvmName("flatTap")
@Suppress(
    "UNCHECKED_CAST",
    "USELESS_CAST",
    "EXTENSION_SHADOWED_BY_MEMBER",
    "UNUSED_PARAMETER"
)
fun <F, L, A, B> Kind<Kind<Kind<ForEitherT, F>, L>, A>.flatTap(MF: Monad<F>, arg1: Function1<A,
    Kind<Kind<Kind<ForEitherT, F>, L>, B>>): EitherT<F, L, A> = arrow.mtl.EitherT.monad<F,
    L>(MF).run {
  this@flatTap.flatTap<A, B>(arg1) as arrow.mtl.EitherT<F, L, A>
}

@JvmName("productL")
@Suppress(
    "UNCHECKED_CAST",
    "USELESS_CAST",
    "EXTENSION_SHADOWED_BY_MEMBER",
    "UNUSED_PARAMETER"
)
fun <F, L, A, B> Kind<Kind<Kind<ForEitherT, F>, L>, A>.productL(MF: Monad<F>,
    arg1: Kind<Kind<Kind<ForEitherT, F>, L>, B>): EitherT<F, L, A> = arrow.mtl.EitherT.monad<F,
    L>(MF).run {
  this@productL.productL<A, B>(arg1) as arrow.mtl.EitherT<F, L, A>
}

@JvmName("forEffect")
@Suppress(
    "UNCHECKED_CAST",
    "USELESS_CAST",
    "EXTENSION_SHADOWED_BY_MEMBER",
    "UNUSED_PARAMETER"
)
fun <F, L, A, B> Kind<Kind<Kind<ForEitherT, F>, L>, A>.forEffect(MF: Monad<F>,
    arg1: Kind<Kind<Kind<ForEitherT, F>, L>, B>): EitherT<F, L, A> = arrow.mtl.EitherT.monad<F,
    L>(MF).run {
  this@forEffect.forEffect<A, B>(arg1) as arrow.mtl.EitherT<F, L, A>
}

@JvmName("productLEval")
@Suppress(
    "UNCHECKED_CAST",
    "USELESS_CAST",
    "EXTENSION_SHADOWED_BY_MEMBER",
    "UNUSED_PARAMETER"
)
fun <F, L, A, B> Kind<Kind<Kind<ForEitherT, F>, L>, A>.productLEval(MF: Monad<F>,
    arg1: Eval<Kind<Kind<Kind<ForEitherT, F>, L>, B>>): EitherT<F, L, A> =
    arrow.mtl.EitherT.monad<F, L>(MF).run {
  this@productLEval.productLEval<A, B>(arg1) as arrow.mtl.EitherT<F, L, A>
}

@JvmName("forEffectEval")
@Suppress(
    "UNCHECKED_CAST",
    "USELESS_CAST",
    "EXTENSION_SHADOWED_BY_MEMBER",
    "UNUSED_PARAMETER"
)
fun <F, L, A, B> Kind<Kind<Kind<ForEitherT, F>, L>, A>.forEffectEval(MF: Monad<F>,
    arg1: Eval<Kind<Kind<Kind<ForEitherT, F>, L>, B>>): EitherT<F, L, A> =
    arrow.mtl.EitherT.monad<F, L>(MF).run {
  this@forEffectEval.forEffectEval<A, B>(arg1) as arrow.mtl.EitherT<F, L, A>
}

@JvmName("mproduct")
@Suppress(
    "UNCHECKED_CAST",
    "USELESS_CAST",
    "EXTENSION_SHADOWED_BY_MEMBER",
    "UNUSED_PARAMETER"
)
fun <F, L, A, B> Kind<Kind<Kind<ForEitherT, F>, L>, A>.mproduct(MF: Monad<F>, arg1: Function1<A,
    Kind<Kind<Kind<ForEitherT, F>, L>, B>>): EitherT<F, L, Tuple2<A, B>> =
    arrow.mtl.EitherT.monad<F, L>(MF).run {
  this@mproduct.mproduct<A, B>(arg1) as arrow.mtl.EitherT<F, L, arrow.core.Tuple2<A, B>>
}

@JvmName("ifM")
@Suppress(
    "UNCHECKED_CAST",
    "USELESS_CAST",
    "EXTENSION_SHADOWED_BY_MEMBER",
    "UNUSED_PARAMETER"
)
fun <F, L, B> Kind<Kind<Kind<ForEitherT, F>, L>, Boolean>.ifM(
  MF: Monad<F>,
  arg1: Function0<Kind<Kind<Kind<ForEitherT, F>, L>, B>>,
  arg2: Function0<Kind<Kind<Kind<ForEitherT, F>, L>, B>>
): EitherT<F, L, B> = arrow.mtl.EitherT.monad<F, L>(MF).run {
  this@ifM.ifM<B>(arg1, arg2) as arrow.mtl.EitherT<F, L, B>
}

@JvmName("selectM")
@Suppress(
    "UNCHECKED_CAST",
    "USELESS_CAST",
    "EXTENSION_SHADOWED_BY_MEMBER",
    "UNUSED_PARAMETER"
)
fun <F, L, A, B> Kind<Kind<Kind<ForEitherT, F>, L>, Either<A, B>>.selectM(MF: Monad<F>,
    arg1: Kind<Kind<Kind<ForEitherT, F>, L>, Function1<A, B>>): EitherT<F, L, B> =
    arrow.mtl.EitherT.monad<F, L>(MF).run {
  this@selectM.selectM<A, B>(arg1) as arrow.mtl.EitherT<F, L, B>
}

@JvmName("select")
@Suppress(
    "UNCHECKED_CAST",
    "USELESS_CAST",
    "EXTENSION_SHADOWED_BY_MEMBER",
    "UNUSED_PARAMETER"
)
fun <F, L, A, B> Kind<Kind<Kind<ForEitherT, F>, L>, Either<A, B>>.select(MF: Monad<F>,
    arg1: Kind<Kind<Kind<ForEitherT, F>, L>, Function1<A, B>>): EitherT<F, L, B> =
    arrow.mtl.EitherT.monad<F, L>(MF).run {
  this@select.select<A, B>(arg1) as arrow.mtl.EitherT<F, L, B>
}

@Suppress(
    "UNCHECKED_CAST",
    "NOTHING_TO_INLINE"
)
inline fun <F, L> Companion.monad(MF: Monad<F>): EitherTMonad<F, L> = object :
    arrow.mtl.extensions.EitherTMonad<F, L> { override fun MF(): arrow.typeclasses.Monad<F> = MF }