package arrow.mtl.extensions.eithert.monadError

import arrow.Kind
import arrow.core.Either
import arrow.mtl.EitherT
import arrow.mtl.EitherT.Companion
import arrow.mtl.ForEitherT
import arrow.mtl.extensions.EitherTMonadError
import arrow.typeclasses.ApplicativeError
import arrow.typeclasses.Monad
import kotlin.Boolean
import kotlin.Function0
import kotlin.Function1
import kotlin.Suppress
import kotlin.jvm.JvmName

@JvmName("ensure")
@Suppress(
    "UNCHECKED_CAST",
    "USELESS_CAST",
    "EXTENSION_SHADOWED_BY_MEMBER",
    "UNUSED_PARAMETER"
)
fun <F, L, A> Kind<Kind<Kind<ForEitherT, F>, L>, A>.ensure(
  MF: Monad<F>,
  AE: ApplicativeError<F, L>,
  arg1: Function0<L>,
  arg2: Function1<A, Boolean>
): EitherT<F, L, A> = arrow.mtl.EitherT.monadError<F, L>(MF, AE).run {
  this@ensure.ensure<A>(arg1, arg2) as arrow.mtl.EitherT<F, L, A>
}

@JvmName("redeemWith")
@Suppress(
    "UNCHECKED_CAST",
    "USELESS_CAST",
    "EXTENSION_SHADOWED_BY_MEMBER",
    "UNUSED_PARAMETER"
)
fun <F, L, A, B> Kind<Kind<Kind<ForEitherT, F>, L>, A>.redeemWith(
  MF: Monad<F>,
  AE: ApplicativeError<F, L>,
  arg1: Function1<L, Kind<Kind<Kind<ForEitherT, F>, L>, B>>,
  arg2: Function1<A, Kind<Kind<Kind<ForEitherT, F>, L>, B>>
): EitherT<F, L, B> = arrow.mtl.EitherT.monadError<F, L>(MF, AE).run {
  this@redeemWith.redeemWith<A, B>(arg1, arg2) as arrow.mtl.EitherT<F, L, B>
}

@JvmName("rethrow")
@Suppress(
    "UNCHECKED_CAST",
    "USELESS_CAST",
    "EXTENSION_SHADOWED_BY_MEMBER",
    "UNUSED_PARAMETER"
)
fun <F, L, A> Kind<Kind<Kind<ForEitherT, F>, L>, Either<L, A>>.rethrow(MF: Monad<F>,
    AE: ApplicativeError<F, L>): EitherT<F, L, A> = arrow.mtl.EitherT.monadError<F, L>(MF, AE).run {
  this@rethrow.rethrow<A>() as arrow.mtl.EitherT<F, L, A>
}

@Suppress(
    "UNCHECKED_CAST",
    "NOTHING_TO_INLINE"
)
inline fun <F, L> Companion.monadError(MF: Monad<F>, AE: ApplicativeError<F, L>):
    EitherTMonadError<F, L> = object : arrow.mtl.extensions.EitherTMonadError<F, L> { override fun
    MF(): arrow.typeclasses.Monad<F> = MF

  override fun AE(): arrow.typeclasses.ApplicativeError<F, L> = AE }