package arrow.mtl.extensions.eithert.traverse

import arrow.Kind
import arrow.mtl.EitherT
import arrow.mtl.EitherT.Companion
import arrow.mtl.ForEitherT
import arrow.mtl.extensions.EitherTTraverse
import arrow.typeclasses.Applicative
import arrow.typeclasses.Monad
import arrow.typeclasses.Traverse
import kotlin.Function1
import kotlin.Suppress
import kotlin.jvm.JvmName

@JvmName("traverse")
@Suppress(
    "UNCHECKED_CAST",
    "USELESS_CAST",
    "EXTENSION_SHADOWED_BY_MEMBER",
    "UNUSED_PARAMETER"
)
fun <F, L, G, A, B> Kind<Kind<Kind<ForEitherT, F>, L>, A>.traverse(
  TF: Traverse<F>,
  arg1: Applicative<G>,
  arg2: Function1<A, Kind<G, B>>
): Kind<G, Kind<Kind<Kind<ForEitherT, F>, L>, B>> = arrow.mtl.EitherT.traverse<F, L>(TF).run {
  this@traverse.traverse<G, A, B>(arg1, arg2) as arrow.Kind<G,
    arrow.Kind<arrow.Kind<arrow.Kind<arrow.mtl.ForEitherT, F>, L>, B>>
}

@JvmName("sequence")
@Suppress(
    "UNCHECKED_CAST",
    "USELESS_CAST",
    "EXTENSION_SHADOWED_BY_MEMBER",
    "UNUSED_PARAMETER"
)
fun <F, L, G, A> Kind<Kind<Kind<ForEitherT, F>, L>, Kind<G, A>>.sequence(TF: Traverse<F>,
    arg1: Applicative<G>): Kind<G, Kind<Kind<Kind<ForEitherT, F>, L>, A>> =
    arrow.mtl.EitherT.traverse<F, L>(TF).run {
  this@sequence.sequence<G, A>(arg1) as arrow.Kind<G,
    arrow.Kind<arrow.Kind<arrow.Kind<arrow.mtl.ForEitherT, F>, L>, A>>
}

@JvmName("map")
@Suppress(
    "UNCHECKED_CAST",
    "USELESS_CAST",
    "EXTENSION_SHADOWED_BY_MEMBER",
    "UNUSED_PARAMETER"
)
fun <F, L, A, B> Kind<Kind<Kind<ForEitherT, F>, L>, A>.map(TF: Traverse<F>, arg1: Function1<A, B>):
    EitherT<F, L, B> = arrow.mtl.EitherT.traverse<F, L>(TF).run {
  this@map.map<A, B>(arg1) as arrow.mtl.EitherT<F, L, B>
}

@JvmName("flatTraverse")
@Suppress(
    "UNCHECKED_CAST",
    "USELESS_CAST",
    "EXTENSION_SHADOWED_BY_MEMBER",
    "UNUSED_PARAMETER"
)
fun <F, L, G, A, B> Kind<Kind<Kind<ForEitherT, F>, L>, A>.flatTraverse(
  TF: Traverse<F>,
  arg1: Monad<Kind<Kind<ForEitherT, F>, L>>,
  arg2: Applicative<G>,
  arg3: Function1<A, Kind<G, Kind<Kind<Kind<ForEitherT, F>, L>, B>>>
): Kind<G, Kind<Kind<Kind<ForEitherT, F>, L>, B>> = arrow.mtl.EitherT.traverse<F, L>(TF).run {
  this@flatTraverse.flatTraverse<G, A, B>(arg1, arg2, arg3) as arrow.Kind<G,
    arrow.Kind<arrow.Kind<arrow.Kind<arrow.mtl.ForEitherT, F>, L>, B>>
}

@Suppress(
    "UNCHECKED_CAST",
    "NOTHING_TO_INLINE"
)
inline fun <F, L> Companion.traverse(TF: Traverse<F>): EitherTTraverse<F, L> = object :
    arrow.mtl.extensions.EitherTTraverse<F, L> { override fun TF(): arrow.typeclasses.Traverse<F> =
    TF }