package arrow.mtl.extensions.kleisli.applicativeError

import arrow.Kind
import arrow.core.Either
import arrow.core.ForOption
import arrow.core.ForTry
import arrow.mtl.ForKleisli
import arrow.mtl.Kleisli
import arrow.mtl.Kleisli.Companion
import arrow.mtl.extensions.KleisliApplicativeError
import arrow.typeclasses.ApplicativeError
import kotlin.Function0
import kotlin.Function1
import kotlin.Suppress
import kotlin.Throwable
import kotlin.jvm.JvmName

@JvmName("handleErrorWith")
@Suppress(
    "UNCHECKED_CAST",
    "USELESS_CAST",
    "EXTENSION_SHADOWED_BY_MEMBER",
    "UNUSED_PARAMETER"
)
fun <F, D, E, A> Kind<Kind<Kind<ForKleisli, F>, D>, A>.handleErrorWith(AE: ApplicativeError<F, E>,
    arg1: Function1<E, Kind<Kind<Kind<ForKleisli, F>, D>, A>>): Kleisli<F, D, A> =
    arrow.mtl.Kleisli.applicativeError<F, D, E>(AE).run {
  this@handleErrorWith.handleErrorWith<A>(arg1) as arrow.mtl.Kleisli<F, D, A>
}

@JvmName("raiseError1")
@Suppress(
    "UNCHECKED_CAST",
    "USELESS_CAST",
    "EXTENSION_SHADOWED_BY_MEMBER",
    "UNUSED_PARAMETER"
)
fun <F, D, E, A> E.raiseError(AE: ApplicativeError<F, E>): Kleisli<F, D, A> =
    arrow.mtl.Kleisli.applicativeError<F, D, E>(AE).run {
  this@raiseError.raiseError<A>() as arrow.mtl.Kleisli<F, D, A>
}

@JvmName("fromOption")
@Suppress(
    "UNCHECKED_CAST",
    "USELESS_CAST",
    "EXTENSION_SHADOWED_BY_MEMBER",
    "UNUSED_PARAMETER"
)
fun <F, D, E, A> Kind<ForOption, A>.fromOption(AE: ApplicativeError<F, E>, arg1: Function0<E>):
    Kleisli<F, D, A> = arrow.mtl.Kleisli.applicativeError<F, D, E>(AE).run {
  this@fromOption.fromOption<A>(arg1) as arrow.mtl.Kleisli<F, D, A>
}

@JvmName("fromEither")
@Suppress(
    "UNCHECKED_CAST",
    "USELESS_CAST",
    "EXTENSION_SHADOWED_BY_MEMBER",
    "UNUSED_PARAMETER"
)
fun <F, D, E, A, EE> Either<EE, A>.fromEither(AE: ApplicativeError<F, E>, arg1: Function1<EE, E>):
    Kleisli<F, D, A> = arrow.mtl.Kleisli.applicativeError<F, D, E>(AE).run {
  this@fromEither.fromEither<A, EE>(arg1) as arrow.mtl.Kleisli<F, D, A>
}

@JvmName("fromTry")
@Suppress(
    "UNCHECKED_CAST",
    "USELESS_CAST",
    "EXTENSION_SHADOWED_BY_MEMBER",
    "UNUSED_PARAMETER"
)
fun <F, D, E, A> Kind<ForTry, A>.fromTry(AE: ApplicativeError<F, E>, arg1: Function1<Throwable, E>):
    Kleisli<F, D, A> = arrow.mtl.Kleisli.applicativeError<F, D, E>(AE).run {
  this@fromTry.fromTry<A>(arg1) as arrow.mtl.Kleisli<F, D, A>
}

@JvmName("handleError")
@Suppress(
    "UNCHECKED_CAST",
    "USELESS_CAST",
    "EXTENSION_SHADOWED_BY_MEMBER",
    "UNUSED_PARAMETER"
)
fun <F, D, E, A> Kind<Kind<Kind<ForKleisli, F>, D>, A>.handleError(AE: ApplicativeError<F, E>,
    arg1: Function1<E, A>): Kleisli<F, D, A> = arrow.mtl.Kleisli.applicativeError<F, D, E>(AE).run {
  this@handleError.handleError<A>(arg1) as arrow.mtl.Kleisli<F, D, A>
}

@JvmName("redeem")
@Suppress(
    "UNCHECKED_CAST",
    "USELESS_CAST",
    "EXTENSION_SHADOWED_BY_MEMBER",
    "UNUSED_PARAMETER"
)
fun <F, D, E, A, B> Kind<Kind<Kind<ForKleisli, F>, D>, A>.redeem(
  AE: ApplicativeError<F, E>,
  arg1: Function1<E, B>,
  arg2: Function1<A, B>
): Kleisli<F, D, B> = arrow.mtl.Kleisli.applicativeError<F, D, E>(AE).run {
  this@redeem.redeem<A, B>(arg1, arg2) as arrow.mtl.Kleisli<F, D, B>
}

@JvmName("attempt")
@Suppress(
    "UNCHECKED_CAST",
    "USELESS_CAST",
    "EXTENSION_SHADOWED_BY_MEMBER",
    "UNUSED_PARAMETER"
)
fun <F, D, E, A> Kind<Kind<Kind<ForKleisli, F>, D>, A>.attempt(AE: ApplicativeError<F, E>):
    Kleisli<F, D, Either<E, A>> = arrow.mtl.Kleisli.applicativeError<F, D, E>(AE).run {
  this@attempt.attempt<A>() as arrow.mtl.Kleisli<F, D, arrow.core.Either<E, A>>
}

@JvmName("catch")
@Suppress(
    "UNCHECKED_CAST",
    "USELESS_CAST",
    "EXTENSION_SHADOWED_BY_MEMBER",
    "UNUSED_PARAMETER"
)
fun <F, D, E, A> catch(
  AE: ApplicativeError<F, E>,
  arg0: Function1<Throwable, E>,
  arg1: Function0<A>
): Kleisli<F, D, A> = arrow.mtl.Kleisli
   .applicativeError<F, D, E>(AE)
   .catch<A>(arg0, arg1) as arrow.mtl.Kleisli<F, D, A>

@JvmName("catch")
@Suppress(
    "UNCHECKED_CAST",
    "USELESS_CAST",
    "EXTENSION_SHADOWED_BY_MEMBER",
    "UNUSED_PARAMETER"
)
fun <F, D, E, A> ApplicativeError<Kind<Kind<ForKleisli, F>, D>,
    Throwable>.catch(AE: ApplicativeError<F, E>, arg1: Function0<A>): Kleisli<F, D, A> =
    arrow.mtl.Kleisli.applicativeError<F, D, E>(AE).run {
  this@catch.catch<A>(arg1) as arrow.mtl.Kleisli<F, D, A>
}

@Suppress(
    "UNCHECKED_CAST",
    "NOTHING_TO_INLINE"
)
inline fun <F, D, E> Companion.applicativeError(AE: ApplicativeError<F, E>):
    KleisliApplicativeError<F, D, E> = object : arrow.mtl.extensions.KleisliApplicativeError<F, D,
    E> { override fun AE(): arrow.typeclasses.ApplicativeError<F, E> = AE }