package arrow.mtl.extensions.kleisli.apply

import arrow.Kind
import arrow.core.Eval
import arrow.core.Tuple10
import arrow.core.Tuple2
import arrow.core.Tuple3
import arrow.core.Tuple4
import arrow.core.Tuple5
import arrow.core.Tuple6
import arrow.core.Tuple7
import arrow.core.Tuple8
import arrow.core.Tuple9
import arrow.mtl.ForKleisli
import arrow.mtl.Kleisli
import arrow.mtl.Kleisli.Companion
import arrow.mtl.extensions.KleisliApply
import arrow.typeclasses.Applicative
import kotlin.Function1
import kotlin.Suppress
import kotlin.jvm.JvmName

@JvmName("ap")
@Suppress(
    "UNCHECKED_CAST",
    "USELESS_CAST",
    "EXTENSION_SHADOWED_BY_MEMBER",
    "UNUSED_PARAMETER"
)
fun <F, D, A, B> Kind<Kind<Kind<ForKleisli, F>, D>, A>.ap(AF: Applicative<F>,
    arg1: Kind<Kind<Kind<ForKleisli, F>, D>, Function1<A, B>>): Kleisli<F, D, B> =
    arrow.mtl.Kleisli.apply<F, D>(AF).run {
  this@ap.ap<A, B>(arg1) as arrow.mtl.Kleisli<F, D, B>
}

@JvmName("map")
@Suppress(
    "UNCHECKED_CAST",
    "USELESS_CAST",
    "EXTENSION_SHADOWED_BY_MEMBER",
    "UNUSED_PARAMETER"
)
fun <F, D, A, B, Z> map(
  AF: Applicative<F>,
  arg0: Kind<Kind<Kind<ForKleisli, F>, D>, A>,
  arg1: Kind<Kind<Kind<ForKleisli, F>, D>, B>,
  arg2: Function1<Tuple2<A, B>, Z>
): Kleisli<F, D, Z> = arrow.mtl.Kleisli
   .apply<F, D>(AF)
   .map<A, B, Z>(arg0, arg1, arg2) as arrow.mtl.Kleisli<F, D, Z>

@JvmName("map")
@Suppress(
    "UNCHECKED_CAST",
    "USELESS_CAST",
    "EXTENSION_SHADOWED_BY_MEMBER",
    "UNUSED_PARAMETER"
)
fun <F, D, A, B, C, Z> map(
  AF: Applicative<F>,
  arg0: Kind<Kind<Kind<ForKleisli, F>, D>, A>,
  arg1: Kind<Kind<Kind<ForKleisli, F>, D>, B>,
  arg2: Kind<Kind<Kind<ForKleisli, F>, D>, C>,
  arg3: Function1<Tuple3<A, B, C>, Z>
): Kleisli<F, D, Z> = arrow.mtl.Kleisli
   .apply<F, D>(AF)
   .map<A, B, C, Z>(arg0, arg1, arg2, arg3) as arrow.mtl.Kleisli<F, D, Z>

@JvmName("map")
@Suppress(
    "UNCHECKED_CAST",
    "USELESS_CAST",
    "EXTENSION_SHADOWED_BY_MEMBER",
    "UNUSED_PARAMETER"
)
fun <F, D, A, B, C, Z> map(
  AF: Applicative<F>,
  arg0: Kind<Kind<Kind<ForKleisli, F>, D>, A>,
  arg1: Kind<Kind<Kind<ForKleisli, F>, D>, B>,
  arg2: Kind<Kind<Kind<ForKleisli, F>, D>, C>,
  arg3: Kind<Kind<Kind<ForKleisli, F>, D>, D>,
  arg4: Function1<Tuple4<A, B, C, D>, Z>
): Kleisli<F, D, Z> = arrow.mtl.Kleisli
   .apply<F, D>(AF)
   .map<A, B, C, D, Z>(arg0, arg1, arg2, arg3, arg4) as arrow.mtl.Kleisli<F, D, Z>

@JvmName("map")
@Suppress(
    "UNCHECKED_CAST",
    "USELESS_CAST",
    "EXTENSION_SHADOWED_BY_MEMBER",
    "UNUSED_PARAMETER"
)
fun <F, D, A, B, C, E, Z> map(
  AF: Applicative<F>,
  arg0: Kind<Kind<Kind<ForKleisli, F>, D>, A>,
  arg1: Kind<Kind<Kind<ForKleisli, F>, D>, B>,
  arg2: Kind<Kind<Kind<ForKleisli, F>, D>, C>,
  arg3: Kind<Kind<Kind<ForKleisli, F>, D>, D>,
  arg4: Kind<Kind<Kind<ForKleisli, F>, D>, E>,
  arg5: Function1<Tuple5<A, B, C, D, E>, Z>
): Kleisli<F, D, Z> = arrow.mtl.Kleisli
   .apply<F, D>(AF)
   .map<A, B, C, D, E, Z>(arg0, arg1, arg2, arg3, arg4, arg5) as arrow.mtl.Kleisli<F, D, Z>

@JvmName("map")
@Suppress(
    "UNCHECKED_CAST",
    "USELESS_CAST",
    "EXTENSION_SHADOWED_BY_MEMBER",
    "UNUSED_PARAMETER"
)
fun <F, D, A, B, C, E, FF, Z> map(
  AF: Applicative<F>,
  arg0: Kind<Kind<Kind<ForKleisli, F>, D>, A>,
  arg1: Kind<Kind<Kind<ForKleisli, F>, D>, B>,
  arg2: Kind<Kind<Kind<ForKleisli, F>, D>, C>,
  arg3: Kind<Kind<Kind<ForKleisli, F>, D>, D>,
  arg4: Kind<Kind<Kind<ForKleisli, F>, D>, E>,
  arg5: Kind<Kind<Kind<ForKleisli, F>, D>, FF>,
  arg6: Function1<Tuple6<A, B, C, D, E, FF>, Z>
): Kleisli<F, D, Z> = arrow.mtl.Kleisli
   .apply<F, D>(AF)
   .map<A, B, C, D, E, FF, Z>(arg0, arg1, arg2, arg3, arg4, arg5, arg6) as arrow.mtl.Kleisli<F, D,
    Z>

@JvmName("map")
@Suppress(
    "UNCHECKED_CAST",
    "USELESS_CAST",
    "EXTENSION_SHADOWED_BY_MEMBER",
    "UNUSED_PARAMETER"
)
fun <F, D, A, B, C, E, FF, G, Z> map(
  AF: Applicative<F>,
  arg0: Kind<Kind<Kind<ForKleisli, F>, D>, A>,
  arg1: Kind<Kind<Kind<ForKleisli, F>, D>, B>,
  arg2: Kind<Kind<Kind<ForKleisli, F>, D>, C>,
  arg3: Kind<Kind<Kind<ForKleisli, F>, D>, D>,
  arg4: Kind<Kind<Kind<ForKleisli, F>, D>, E>,
  arg5: Kind<Kind<Kind<ForKleisli, F>, D>, FF>,
  arg6: Kind<Kind<Kind<ForKleisli, F>, D>, G>,
  arg7: Function1<Tuple7<A, B, C, D, E, FF, G>, Z>
): Kleisli<F, D, Z> = arrow.mtl.Kleisli
   .apply<F, D>(AF)
   .map<A, B, C, D, E, FF, G, Z>(arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7) as
    arrow.mtl.Kleisli<F, D, Z>

@JvmName("map")
@Suppress(
    "UNCHECKED_CAST",
    "USELESS_CAST",
    "EXTENSION_SHADOWED_BY_MEMBER",
    "UNUSED_PARAMETER"
)
fun <F, D, A, B, C, E, FF, G, H, Z> map(
  AF: Applicative<F>,
  arg0: Kind<Kind<Kind<ForKleisli, F>, D>, A>,
  arg1: Kind<Kind<Kind<ForKleisli, F>, D>, B>,
  arg2: Kind<Kind<Kind<ForKleisli, F>, D>, C>,
  arg3: Kind<Kind<Kind<ForKleisli, F>, D>, D>,
  arg4: Kind<Kind<Kind<ForKleisli, F>, D>, E>,
  arg5: Kind<Kind<Kind<ForKleisli, F>, D>, FF>,
  arg6: Kind<Kind<Kind<ForKleisli, F>, D>, G>,
  arg7: Kind<Kind<Kind<ForKleisli, F>, D>, H>,
  arg8: Function1<Tuple8<A, B, C, D, E, FF, G, H>, Z>
): Kleisli<F, D, Z> = arrow.mtl.Kleisli
   .apply<F, D>(AF)
   .map<A, B, C, D, E, FF, G, H, Z>(arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8) as
    arrow.mtl.Kleisli<F, D, Z>

@JvmName("map")
@Suppress(
    "UNCHECKED_CAST",
    "USELESS_CAST",
    "EXTENSION_SHADOWED_BY_MEMBER",
    "UNUSED_PARAMETER"
)
fun <F, D, A, B, C, E, FF, G, H, I, Z> map(
  AF: Applicative<F>,
  arg0: Kind<Kind<Kind<ForKleisli, F>, D>, A>,
  arg1: Kind<Kind<Kind<ForKleisli, F>, D>, B>,
  arg2: Kind<Kind<Kind<ForKleisli, F>, D>, C>,
  arg3: Kind<Kind<Kind<ForKleisli, F>, D>, D>,
  arg4: Kind<Kind<Kind<ForKleisli, F>, D>, E>,
  arg5: Kind<Kind<Kind<ForKleisli, F>, D>, FF>,
  arg6: Kind<Kind<Kind<ForKleisli, F>, D>, G>,
  arg7: Kind<Kind<Kind<ForKleisli, F>, D>, H>,
  arg8: Kind<Kind<Kind<ForKleisli, F>, D>, I>,
  arg9: Function1<Tuple9<A, B, C, D, E, FF, G, H, I>, Z>
): Kleisli<F, D, Z> = arrow.mtl.Kleisli
   .apply<F, D>(AF)
   .map<A, B, C, D, E, FF, G, H, I, Z>(arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9)
    as arrow.mtl.Kleisli<F, D, Z>

@JvmName("map")
@Suppress(
    "UNCHECKED_CAST",
    "USELESS_CAST",
    "EXTENSION_SHADOWED_BY_MEMBER",
    "UNUSED_PARAMETER"
)
fun <F, D, A, B, C, E, FF, G, H, I, J, Z> map(
  AF: Applicative<F>,
  arg0: Kind<Kind<Kind<ForKleisli, F>, D>, A>,
  arg1: Kind<Kind<Kind<ForKleisli, F>, D>, B>,
  arg2: Kind<Kind<Kind<ForKleisli, F>, D>, C>,
  arg3: Kind<Kind<Kind<ForKleisli, F>, D>, D>,
  arg4: Kind<Kind<Kind<ForKleisli, F>, D>, E>,
  arg5: Kind<Kind<Kind<ForKleisli, F>, D>, FF>,
  arg6: Kind<Kind<Kind<ForKleisli, F>, D>, G>,
  arg7: Kind<Kind<Kind<ForKleisli, F>, D>, H>,
  arg8: Kind<Kind<Kind<ForKleisli, F>, D>, I>,
  arg9: Kind<Kind<Kind<ForKleisli, F>, D>, J>,
  arg10: Function1<Tuple10<A, B, C, D, E, FF, G, H, I, J>, Z>
): Kleisli<F, D, Z> = arrow.mtl.Kleisli
   .apply<F, D>(AF)
   .map<A, B, C, D, E, FF, G, H, I, J,
    Z>(arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10) as arrow.mtl.Kleisli<F, D,
    Z>

@JvmName("map2")
@Suppress(
    "UNCHECKED_CAST",
    "USELESS_CAST",
    "EXTENSION_SHADOWED_BY_MEMBER",
    "UNUSED_PARAMETER"
)
fun <F, D, A, B, Z> Kind<Kind<Kind<ForKleisli, F>, D>, A>.map2(
  AF: Applicative<F>,
  arg1: Kind<Kind<Kind<ForKleisli, F>, D>, B>,
  arg2: Function1<Tuple2<A, B>, Z>
): Kleisli<F, D, Z> = arrow.mtl.Kleisli.apply<F, D>(AF).run {
  this@map2.map2<A, B, Z>(arg1, arg2) as arrow.mtl.Kleisli<F, D, Z>
}

@JvmName("map2Eval")
@Suppress(
    "UNCHECKED_CAST",
    "USELESS_CAST",
    "EXTENSION_SHADOWED_BY_MEMBER",
    "UNUSED_PARAMETER"
)
fun <F, D, A, B, Z> Kind<Kind<Kind<ForKleisli, F>, D>, A>.map2Eval(
  AF: Applicative<F>,
  arg1: Eval<Kind<Kind<Kind<ForKleisli, F>, D>, B>>,
  arg2: Function1<Tuple2<A, B>, Z>
): Eval<Kind<Kind<Kind<ForKleisli, F>, D>, Z>> = arrow.mtl.Kleisli.apply<F, D>(AF).run {
  this@map2Eval.map2Eval<A, B, Z>(arg1, arg2) as
    arrow.core.Eval<arrow.Kind<arrow.Kind<arrow.Kind<arrow.mtl.ForKleisli, F>, D>, Z>>
}

@JvmName("product")
@Suppress(
    "UNCHECKED_CAST",
    "USELESS_CAST",
    "EXTENSION_SHADOWED_BY_MEMBER",
    "UNUSED_PARAMETER"
)
fun <F, D, A, B> Kind<Kind<Kind<ForKleisli, F>, D>, A>.product(AF: Applicative<F>,
    arg1: Kind<Kind<Kind<ForKleisli, F>, D>, B>): Kleisli<F, D, Tuple2<A, B>> =
    arrow.mtl.Kleisli.apply<F, D>(AF).run {
  this@product.product<A, B>(arg1) as arrow.mtl.Kleisli<F, D, arrow.core.Tuple2<A, B>>
}

@JvmName("product1")
@Suppress(
    "UNCHECKED_CAST",
    "USELESS_CAST",
    "EXTENSION_SHADOWED_BY_MEMBER",
    "UNUSED_PARAMETER"
)
fun <F, D, A, B, Z> Kind<Kind<Kind<ForKleisli, F>, D>, Tuple2<A, B>>.product(AF: Applicative<F>,
    arg1: Kind<Kind<Kind<ForKleisli, F>, D>, Z>): Kleisli<F, D, Tuple3<A, B, Z>> =
    arrow.mtl.Kleisli.apply<F, D>(AF).run {
  this@product.product<A, B, Z>(arg1) as arrow.mtl.Kleisli<F, D, arrow.core.Tuple3<A, B, Z>>
}

@JvmName("product2")
@Suppress(
    "UNCHECKED_CAST",
    "USELESS_CAST",
    "EXTENSION_SHADOWED_BY_MEMBER",
    "UNUSED_PARAMETER"
)
fun <F, D, A, B, C, Z> Kind<Kind<Kind<ForKleisli, F>, D>, Tuple3<A, B,
    C>>.product(AF: Applicative<F>, arg1: Kind<Kind<Kind<ForKleisli, F>, D>, Z>): Kleisli<F, D,
    Tuple4<A, B, C, Z>> = arrow.mtl.Kleisli.apply<F, D>(AF).run {
  this@product.product<A, B, C, Z>(arg1) as arrow.mtl.Kleisli<F, D, arrow.core.Tuple4<A, B, C, Z>>
}

@JvmName("product3")
@Suppress(
    "UNCHECKED_CAST",
    "USELESS_CAST",
    "EXTENSION_SHADOWED_BY_MEMBER",
    "UNUSED_PARAMETER"
)
fun <F, D, A, B, C, Z> Kind<Kind<Kind<ForKleisli, F>, D>, Tuple4<A, B, C,
    D>>.product(AF: Applicative<F>, arg1: Kind<Kind<Kind<ForKleisli, F>, D>, Z>): Kleisli<F, D,
    Tuple5<A, B, C, D, Z>> = arrow.mtl.Kleisli.apply<F, D>(AF).run {
  this@product.product<A, B, C, D, Z>(arg1) as arrow.mtl.Kleisli<F, D, arrow.core.Tuple5<A, B, C, D,
    Z>>
}

@JvmName("product4")
@Suppress(
    "UNCHECKED_CAST",
    "USELESS_CAST",
    "EXTENSION_SHADOWED_BY_MEMBER",
    "UNUSED_PARAMETER"
)
fun <F, D, A, B, C, E, Z> Kind<Kind<Kind<ForKleisli, F>, D>, Tuple5<A, B, C, D,
    E>>.product(AF: Applicative<F>, arg1: Kind<Kind<Kind<ForKleisli, F>, D>, Z>): Kleisli<F, D,
    Tuple6<A, B, C, D, E, Z>> = arrow.mtl.Kleisli.apply<F, D>(AF).run {
  this@product.product<A, B, C, D, E, Z>(arg1) as arrow.mtl.Kleisli<F, D, arrow.core.Tuple6<A, B, C,
    D, E, Z>>
}

@JvmName("product5")
@Suppress(
    "UNCHECKED_CAST",
    "USELESS_CAST",
    "EXTENSION_SHADOWED_BY_MEMBER",
    "UNUSED_PARAMETER"
)
fun <F, D, A, B, C, E, FF, Z> Kind<Kind<Kind<ForKleisli, F>, D>, Tuple6<A, B, C, D, E,
    FF>>.product(AF: Applicative<F>, arg1: Kind<Kind<Kind<ForKleisli, F>, D>, Z>): Kleisli<F, D,
    Tuple7<A, B, C, D, E, FF, Z>> = arrow.mtl.Kleisli.apply<F, D>(AF).run {
  this@product.product<A, B, C, D, E, FF, Z>(arg1) as arrow.mtl.Kleisli<F, D, arrow.core.Tuple7<A,
    B, C, D, E, FF, Z>>
}

@JvmName("product6")
@Suppress(
    "UNCHECKED_CAST",
    "USELESS_CAST",
    "EXTENSION_SHADOWED_BY_MEMBER",
    "UNUSED_PARAMETER"
)
fun <F, D, A, B, C, E, FF, G, Z> Kind<Kind<Kind<ForKleisli, F>, D>, Tuple7<A, B, C, D, E, FF,
    G>>.product(AF: Applicative<F>, arg1: Kind<Kind<Kind<ForKleisli, F>, D>, Z>): Kleisli<F, D,
    Tuple8<A, B, C, D, E, FF, G, Z>> = arrow.mtl.Kleisli.apply<F, D>(AF).run {
  this@product.product<A, B, C, D, E, FF, G, Z>(arg1) as arrow.mtl.Kleisli<F, D,
    arrow.core.Tuple8<A, B, C, D, E, FF, G, Z>>
}

@JvmName("product7")
@Suppress(
    "UNCHECKED_CAST",
    "USELESS_CAST",
    "EXTENSION_SHADOWED_BY_MEMBER",
    "UNUSED_PARAMETER"
)
fun <F, D, A, B, C, E, FF, G, H, Z> Kind<Kind<Kind<ForKleisli, F>, D>, Tuple8<A, B, C, D, E, FF, G,
    H>>.product(AF: Applicative<F>, arg1: Kind<Kind<Kind<ForKleisli, F>, D>, Z>): Kleisli<F, D,
    Tuple9<A, B, C, D, E, FF, G, H, Z>> = arrow.mtl.Kleisli.apply<F, D>(AF).run {
  this@product.product<A, B, C, D, E, FF, G, H, Z>(arg1) as arrow.mtl.Kleisli<F, D,
    arrow.core.Tuple9<A, B, C, D, E, FF, G, H, Z>>
}

@JvmName("product8")
@Suppress(
    "UNCHECKED_CAST",
    "USELESS_CAST",
    "EXTENSION_SHADOWED_BY_MEMBER",
    "UNUSED_PARAMETER"
)
fun <F, D, A, B, C, E, FF, G, H, I, Z> Kind<Kind<Kind<ForKleisli, F>, D>, Tuple9<A, B, C, D, E, FF,
    G, H, I>>.product(AF: Applicative<F>, arg1: Kind<Kind<Kind<ForKleisli, F>, D>, Z>): Kleisli<F,
    D, Tuple10<A, B, C, D, E, FF, G, H, I, Z>> = arrow.mtl.Kleisli.apply<F, D>(AF).run {
  this@product.product<A, B, C, D, E, FF, G, H, I, Z>(arg1) as arrow.mtl.Kleisli<F, D,
    arrow.core.Tuple10<A, B, C, D, E, FF, G, H, I, Z>>
}

@JvmName("tupled")
@Suppress(
    "UNCHECKED_CAST",
    "USELESS_CAST",
    "EXTENSION_SHADOWED_BY_MEMBER",
    "UNUSED_PARAMETER"
)
fun <F, D, A, B> tupled(
  AF: Applicative<F>,
  arg0: Kind<Kind<Kind<ForKleisli, F>, D>, A>,
  arg1: Kind<Kind<Kind<ForKleisli, F>, D>, B>
): Kleisli<F, D, Tuple2<A, B>> = arrow.mtl.Kleisli
   .apply<F, D>(AF)
   .tupled<A, B>(arg0, arg1) as arrow.mtl.Kleisli<F, D, arrow.core.Tuple2<A, B>>

@JvmName("tupled")
@Suppress(
    "UNCHECKED_CAST",
    "USELESS_CAST",
    "EXTENSION_SHADOWED_BY_MEMBER",
    "UNUSED_PARAMETER"
)
fun <F, D, A, B, C> tupled(
  AF: Applicative<F>,
  arg0: Kind<Kind<Kind<ForKleisli, F>, D>, A>,
  arg1: Kind<Kind<Kind<ForKleisli, F>, D>, B>,
  arg2: Kind<Kind<Kind<ForKleisli, F>, D>, C>
): Kleisli<F, D, Tuple3<A, B, C>> = arrow.mtl.Kleisli
   .apply<F, D>(AF)
   .tupled<A, B, C>(arg0, arg1, arg2) as arrow.mtl.Kleisli<F, D, arrow.core.Tuple3<A, B, C>>

@JvmName("tupled")
@Suppress(
    "UNCHECKED_CAST",
    "USELESS_CAST",
    "EXTENSION_SHADOWED_BY_MEMBER",
    "UNUSED_PARAMETER"
)
fun <F, D, A, B, C> tupled(
  AF: Applicative<F>,
  arg0: Kind<Kind<Kind<ForKleisli, F>, D>, A>,
  arg1: Kind<Kind<Kind<ForKleisli, F>, D>, B>,
  arg2: Kind<Kind<Kind<ForKleisli, F>, D>, C>,
  arg3: Kind<Kind<Kind<ForKleisli, F>, D>, D>
): Kleisli<F, D, Tuple4<A, B, C, D>> = arrow.mtl.Kleisli
   .apply<F, D>(AF)
   .tupled<A, B, C, D>(arg0, arg1, arg2, arg3) as arrow.mtl.Kleisli<F, D, arrow.core.Tuple4<A, B, C,
    D>>

@JvmName("tupled")
@Suppress(
    "UNCHECKED_CAST",
    "USELESS_CAST",
    "EXTENSION_SHADOWED_BY_MEMBER",
    "UNUSED_PARAMETER"
)
fun <F, D, A, B, C, E> tupled(
  AF: Applicative<F>,
  arg0: Kind<Kind<Kind<ForKleisli, F>, D>, A>,
  arg1: Kind<Kind<Kind<ForKleisli, F>, D>, B>,
  arg2: Kind<Kind<Kind<ForKleisli, F>, D>, C>,
  arg3: Kind<Kind<Kind<ForKleisli, F>, D>, D>,
  arg4: Kind<Kind<Kind<ForKleisli, F>, D>, E>
): Kleisli<F, D, Tuple5<A, B, C, D, E>> = arrow.mtl.Kleisli
   .apply<F, D>(AF)
   .tupled<A, B, C, D, E>(arg0, arg1, arg2, arg3, arg4) as arrow.mtl.Kleisli<F, D,
    arrow.core.Tuple5<A, B, C, D, E>>

@JvmName("tupled")
@Suppress(
    "UNCHECKED_CAST",
    "USELESS_CAST",
    "EXTENSION_SHADOWED_BY_MEMBER",
    "UNUSED_PARAMETER"
)
fun <F, D, A, B, C, E, FF> tupled(
  AF: Applicative<F>,
  arg0: Kind<Kind<Kind<ForKleisli, F>, D>, A>,
  arg1: Kind<Kind<Kind<ForKleisli, F>, D>, B>,
  arg2: Kind<Kind<Kind<ForKleisli, F>, D>, C>,
  arg3: Kind<Kind<Kind<ForKleisli, F>, D>, D>,
  arg4: Kind<Kind<Kind<ForKleisli, F>, D>, E>,
  arg5: Kind<Kind<Kind<ForKleisli, F>, D>, FF>
): Kleisli<F, D, Tuple6<A, B, C, D, E, FF>> = arrow.mtl.Kleisli
   .apply<F, D>(AF)
   .tupled<A, B, C, D, E, FF>(arg0, arg1, arg2, arg3, arg4, arg5) as arrow.mtl.Kleisli<F, D,
    arrow.core.Tuple6<A, B, C, D, E, FF>>

@JvmName("tupled")
@Suppress(
    "UNCHECKED_CAST",
    "USELESS_CAST",
    "EXTENSION_SHADOWED_BY_MEMBER",
    "UNUSED_PARAMETER"
)
fun <F, D, A, B, C, E, FF, G> tupled(
  AF: Applicative<F>,
  arg0: Kind<Kind<Kind<ForKleisli, F>, D>, A>,
  arg1: Kind<Kind<Kind<ForKleisli, F>, D>, B>,
  arg2: Kind<Kind<Kind<ForKleisli, F>, D>, C>,
  arg3: Kind<Kind<Kind<ForKleisli, F>, D>, D>,
  arg4: Kind<Kind<Kind<ForKleisli, F>, D>, E>,
  arg5: Kind<Kind<Kind<ForKleisli, F>, D>, FF>,
  arg6: Kind<Kind<Kind<ForKleisli, F>, D>, G>
): Kleisli<F, D, Tuple7<A, B, C, D, E, FF, G>> = arrow.mtl.Kleisli
   .apply<F, D>(AF)
   .tupled<A, B, C, D, E, FF, G>(arg0, arg1, arg2, arg3, arg4, arg5, arg6) as arrow.mtl.Kleisli<F,
    D, arrow.core.Tuple7<A, B, C, D, E, FF, G>>

@JvmName("tupled")
@Suppress(
    "UNCHECKED_CAST",
    "USELESS_CAST",
    "EXTENSION_SHADOWED_BY_MEMBER",
    "UNUSED_PARAMETER"
)
fun <F, D, A, B, C, E, FF, G, H> tupled(
  AF: Applicative<F>,
  arg0: Kind<Kind<Kind<ForKleisli, F>, D>, A>,
  arg1: Kind<Kind<Kind<ForKleisli, F>, D>, B>,
  arg2: Kind<Kind<Kind<ForKleisli, F>, D>, C>,
  arg3: Kind<Kind<Kind<ForKleisli, F>, D>, D>,
  arg4: Kind<Kind<Kind<ForKleisli, F>, D>, E>,
  arg5: Kind<Kind<Kind<ForKleisli, F>, D>, FF>,
  arg6: Kind<Kind<Kind<ForKleisli, F>, D>, G>,
  arg7: Kind<Kind<Kind<ForKleisli, F>, D>, H>
): Kleisli<F, D, Tuple8<A, B, C, D, E, FF, G, H>> = arrow.mtl.Kleisli
   .apply<F, D>(AF)
   .tupled<A, B, C, D, E, FF, G, H>(arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7) as
    arrow.mtl.Kleisli<F, D, arrow.core.Tuple8<A, B, C, D, E, FF, G, H>>

@JvmName("tupled")
@Suppress(
    "UNCHECKED_CAST",
    "USELESS_CAST",
    "EXTENSION_SHADOWED_BY_MEMBER",
    "UNUSED_PARAMETER"
)
fun <F, D, A, B, C, E, FF, G, H, I> tupled(
  AF: Applicative<F>,
  arg0: Kind<Kind<Kind<ForKleisli, F>, D>, A>,
  arg1: Kind<Kind<Kind<ForKleisli, F>, D>, B>,
  arg2: Kind<Kind<Kind<ForKleisli, F>, D>, C>,
  arg3: Kind<Kind<Kind<ForKleisli, F>, D>, D>,
  arg4: Kind<Kind<Kind<ForKleisli, F>, D>, E>,
  arg5: Kind<Kind<Kind<ForKleisli, F>, D>, FF>,
  arg6: Kind<Kind<Kind<ForKleisli, F>, D>, G>,
  arg7: Kind<Kind<Kind<ForKleisli, F>, D>, H>,
  arg8: Kind<Kind<Kind<ForKleisli, F>, D>, I>
): Kleisli<F, D, Tuple9<A, B, C, D, E, FF, G, H, I>> = arrow.mtl.Kleisli
   .apply<F, D>(AF)
   .tupled<A, B, C, D, E, FF, G, H, I>(arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8) as
    arrow.mtl.Kleisli<F, D, arrow.core.Tuple9<A, B, C, D, E, FF, G, H, I>>

@JvmName("tupled")
@Suppress(
    "UNCHECKED_CAST",
    "USELESS_CAST",
    "EXTENSION_SHADOWED_BY_MEMBER",
    "UNUSED_PARAMETER"
)
fun <F, D, A, B, C, E, FF, G, H, I, J> tupled(
  AF: Applicative<F>,
  arg0: Kind<Kind<Kind<ForKleisli, F>, D>, A>,
  arg1: Kind<Kind<Kind<ForKleisli, F>, D>, B>,
  arg2: Kind<Kind<Kind<ForKleisli, F>, D>, C>,
  arg3: Kind<Kind<Kind<ForKleisli, F>, D>, D>,
  arg4: Kind<Kind<Kind<ForKleisli, F>, D>, E>,
  arg5: Kind<Kind<Kind<ForKleisli, F>, D>, FF>,
  arg6: Kind<Kind<Kind<ForKleisli, F>, D>, G>,
  arg7: Kind<Kind<Kind<ForKleisli, F>, D>, H>,
  arg8: Kind<Kind<Kind<ForKleisli, F>, D>, I>,
  arg9: Kind<Kind<Kind<ForKleisli, F>, D>, J>
): Kleisli<F, D, Tuple10<A, B, C, D, E, FF, G, H, I, J>> = arrow.mtl.Kleisli
   .apply<F, D>(AF)
   .tupled<A, B, C, D, E, FF, G, H, I,
    J>(arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9) as arrow.mtl.Kleisli<F, D,
    arrow.core.Tuple10<A, B, C, D, E, FF, G, H, I, J>>

@Suppress(
    "UNCHECKED_CAST",
    "NOTHING_TO_INLINE"
)
inline fun <F, D> Companion.apply(AF: Applicative<F>): KleisliApply<F, D> = object :
    arrow.mtl.extensions.KleisliApply<F, D> { override fun AF(): arrow.typeclasses.Applicative<F> =
    AF }