package arrow.mtl.extensions.kleisli.monadError

import arrow.Kind
import arrow.core.Either
import arrow.mtl.ForKleisli
import arrow.mtl.Kleisli
import arrow.mtl.Kleisli.Companion
import arrow.mtl.extensions.KleisliMonadError
import arrow.typeclasses.MonadError
import kotlin.Boolean
import kotlin.Function0
import kotlin.Function1
import kotlin.Suppress
import kotlin.jvm.JvmName

@JvmName("ensure")
@Suppress(
    "UNCHECKED_CAST",
    "USELESS_CAST",
    "EXTENSION_SHADOWED_BY_MEMBER",
    "UNUSED_PARAMETER"
)
fun <F, D, E, A> Kind<Kind<Kind<ForKleisli, F>, D>, A>.ensure(
  ME: MonadError<F, E>,
  arg1: Function0<E>,
  arg2: Function1<A, Boolean>
): Kleisli<F, D, A> = arrow.mtl.Kleisli.monadError<F, D, E>(ME).run {
  this@ensure.ensure<A>(arg1, arg2) as arrow.mtl.Kleisli<F, D, A>
}

@JvmName("redeemWith")
@Suppress(
    "UNCHECKED_CAST",
    "USELESS_CAST",
    "EXTENSION_SHADOWED_BY_MEMBER",
    "UNUSED_PARAMETER"
)
fun <F, D, E, A, B> Kind<Kind<Kind<ForKleisli, F>, D>, A>.redeemWith(
  ME: MonadError<F, E>,
  arg1: Function1<E, Kind<Kind<Kind<ForKleisli, F>, D>, B>>,
  arg2: Function1<A, Kind<Kind<Kind<ForKleisli, F>, D>, B>>
): Kleisli<F, D, B> = arrow.mtl.Kleisli.monadError<F, D, E>(ME).run {
  this@redeemWith.redeemWith<A, B>(arg1, arg2) as arrow.mtl.Kleisli<F, D, B>
}

@JvmName("rethrow")
@Suppress(
    "UNCHECKED_CAST",
    "USELESS_CAST",
    "EXTENSION_SHADOWED_BY_MEMBER",
    "UNUSED_PARAMETER"
)
fun <F, D, E, A> Kind<Kind<Kind<ForKleisli, F>, D>, Either<E, A>>.rethrow(ME: MonadError<F, E>):
    Kleisli<F, D, A> = arrow.mtl.Kleisli.monadError<F, D, E>(ME).run {
  this@rethrow.rethrow<A>() as arrow.mtl.Kleisli<F, D, A>
}

@Suppress(
    "UNCHECKED_CAST",
    "NOTHING_TO_INLINE"
)
inline fun <F, D, E> Companion.monadError(ME: MonadError<F, E>): KleisliMonadError<F, D, E> = object
    : arrow.mtl.extensions.KleisliMonadError<F, D, E> { override fun ME():
    arrow.typeclasses.MonadError<F, E> = ME }