package arrow.mtl.extensions.kleisli.monadThrow

import arrow.mtl.Kleisli
import arrow.mtl.Kleisli.Companion
import arrow.mtl.extensions.KleisliMonadThrow
import arrow.typeclasses.MonadError
import kotlin.Suppress
import kotlin.Throwable
import kotlin.jvm.JvmName

@JvmName("raiseNonFatal")
@Suppress(
    "UNCHECKED_CAST",
    "USELESS_CAST",
    "EXTENSION_SHADOWED_BY_MEMBER",
    "UNUSED_PARAMETER"
)
fun <F, D, A> Throwable.raiseNonFatal(ME: MonadError<F, Throwable>): Kleisli<F, D, A> =
    arrow.mtl.Kleisli.monadThrow<F, D>(ME).run {
  this@raiseNonFatal.raiseNonFatal<A>() as arrow.mtl.Kleisli<F, D, A>
}

@Suppress(
    "UNCHECKED_CAST",
    "NOTHING_TO_INLINE"
)
inline fun <F, D> Companion.monadThrow(ME: MonadError<F, Throwable>): KleisliMonadThrow<F, D> =
    object : arrow.mtl.extensions.KleisliMonadThrow<F, D> { override fun ME():
    arrow.typeclasses.MonadError<F, kotlin.Throwable> = ME }