package arrow.mtl.extensions.optiont.applicativeError

import arrow.Kind
import arrow.core.Either
import arrow.core.ForOption
import arrow.core.ForTry
import arrow.mtl.ForOptionT
import arrow.mtl.OptionT
import arrow.mtl.OptionT.Companion
import arrow.mtl.extensions.OptionTApplicativeError
import arrow.typeclasses.ApplicativeError
import kotlin.Function0
import kotlin.Function1
import kotlin.Suppress
import kotlin.Throwable
import kotlin.jvm.JvmName

@JvmName("handleErrorWith")
@Suppress(
    "UNCHECKED_CAST",
    "USELESS_CAST",
    "EXTENSION_SHADOWED_BY_MEMBER",
    "UNUSED_PARAMETER"
)
fun <F, E, A> Kind<Kind<ForOptionT, F>, A>.handleErrorWith(AE: ApplicativeError<F, E>,
    arg1: Function1<E, Kind<Kind<ForOptionT, F>, A>>): OptionT<F, A> =
    arrow.mtl.OptionT.applicativeError<F, E>(AE).run {
  this@handleErrorWith.handleErrorWith<A>(arg1) as arrow.mtl.OptionT<F, A>
}

@JvmName("raiseError1")
@Suppress(
    "UNCHECKED_CAST",
    "USELESS_CAST",
    "EXTENSION_SHADOWED_BY_MEMBER",
    "UNUSED_PARAMETER"
)
fun <F, E, A> E.raiseError(AE: ApplicativeError<F, E>): OptionT<F, A> =
    arrow.mtl.OptionT.applicativeError<F, E>(AE).run {
  this@raiseError.raiseError<A>() as arrow.mtl.OptionT<F, A>
}

@JvmName("fromOption")
@Suppress(
    "UNCHECKED_CAST",
    "USELESS_CAST",
    "EXTENSION_SHADOWED_BY_MEMBER",
    "UNUSED_PARAMETER"
)
fun <F, E, A> Kind<ForOption, A>.fromOption(AE: ApplicativeError<F, E>, arg1: Function0<E>):
    OptionT<F, A> = arrow.mtl.OptionT.applicativeError<F, E>(AE).run {
  this@fromOption.fromOption<A>(arg1) as arrow.mtl.OptionT<F, A>
}

@JvmName("fromEither")
@Suppress(
    "UNCHECKED_CAST",
    "USELESS_CAST",
    "EXTENSION_SHADOWED_BY_MEMBER",
    "UNUSED_PARAMETER"
)
fun <F, E, A, EE> Either<EE, A>.fromEither(AE: ApplicativeError<F, E>, arg1: Function1<EE, E>):
    OptionT<F, A> = arrow.mtl.OptionT.applicativeError<F, E>(AE).run {
  this@fromEither.fromEither<A, EE>(arg1) as arrow.mtl.OptionT<F, A>
}

@JvmName("fromTry")
@Suppress(
    "UNCHECKED_CAST",
    "USELESS_CAST",
    "EXTENSION_SHADOWED_BY_MEMBER",
    "UNUSED_PARAMETER"
)
fun <F, E, A> Kind<ForTry, A>.fromTry(AE: ApplicativeError<F, E>, arg1: Function1<Throwable, E>):
    OptionT<F, A> = arrow.mtl.OptionT.applicativeError<F, E>(AE).run {
  this@fromTry.fromTry<A>(arg1) as arrow.mtl.OptionT<F, A>
}

@JvmName("handleError")
@Suppress(
    "UNCHECKED_CAST",
    "USELESS_CAST",
    "EXTENSION_SHADOWED_BY_MEMBER",
    "UNUSED_PARAMETER"
)
fun <F, E, A> Kind<Kind<ForOptionT, F>, A>.handleError(AE: ApplicativeError<F, E>,
    arg1: Function1<E, A>): OptionT<F, A> = arrow.mtl.OptionT.applicativeError<F, E>(AE).run {
  this@handleError.handleError<A>(arg1) as arrow.mtl.OptionT<F, A>
}

@JvmName("redeem")
@Suppress(
    "UNCHECKED_CAST",
    "USELESS_CAST",
    "EXTENSION_SHADOWED_BY_MEMBER",
    "UNUSED_PARAMETER"
)
fun <F, E, A, B> Kind<Kind<ForOptionT, F>, A>.redeem(
  AE: ApplicativeError<F, E>,
  arg1: Function1<E, B>,
  arg2: Function1<A, B>
): OptionT<F, B> = arrow.mtl.OptionT.applicativeError<F, E>(AE).run {
  this@redeem.redeem<A, B>(arg1, arg2) as arrow.mtl.OptionT<F, B>
}

@JvmName("attempt")
@Suppress(
    "UNCHECKED_CAST",
    "USELESS_CAST",
    "EXTENSION_SHADOWED_BY_MEMBER",
    "UNUSED_PARAMETER"
)
fun <F, E, A> Kind<Kind<ForOptionT, F>, A>.attempt(AE: ApplicativeError<F, E>): OptionT<F, Either<E,
    A>> = arrow.mtl.OptionT.applicativeError<F, E>(AE).run {
  this@attempt.attempt<A>() as arrow.mtl.OptionT<F, arrow.core.Either<E, A>>
}

@JvmName("catch")
@Suppress(
    "UNCHECKED_CAST",
    "USELESS_CAST",
    "EXTENSION_SHADOWED_BY_MEMBER",
    "UNUSED_PARAMETER"
)
fun <F, E, A> catch(
  AE: ApplicativeError<F, E>,
  arg0: Function1<Throwable, E>,
  arg1: Function0<A>
): OptionT<F, A> = arrow.mtl.OptionT
   .applicativeError<F, E>(AE)
   .catch<A>(arg0, arg1) as arrow.mtl.OptionT<F, A>

@JvmName("catch")
@Suppress(
    "UNCHECKED_CAST",
    "USELESS_CAST",
    "EXTENSION_SHADOWED_BY_MEMBER",
    "UNUSED_PARAMETER"
)
fun <F, E, A> ApplicativeError<Kind<ForOptionT, F>, Throwable>.catch(AE: ApplicativeError<F, E>,
    arg1: Function0<A>): OptionT<F, A> = arrow.mtl.OptionT.applicativeError<F, E>(AE).run {
  this@catch.catch<A>(arg1) as arrow.mtl.OptionT<F, A>
}

@Suppress(
    "UNCHECKED_CAST",
    "NOTHING_TO_INLINE"
)
inline fun <F, E> Companion.applicativeError(AE: ApplicativeError<F, E>): OptionTApplicativeError<F,
    E> = object : arrow.mtl.extensions.OptionTApplicativeError<F, E> { override fun AE():
    arrow.typeclasses.ApplicativeError<F, E> = AE }