package arrow.mtl.extensions.optiont.functorFilter

import arrow.Kind
import arrow.core.Option
import arrow.mtl.ForOptionT
import arrow.mtl.OptionT
import arrow.mtl.OptionT.Companion
import arrow.mtl.extensions.OptionTFunctorFilter
import arrow.typeclasses.Functor
import kotlin.Boolean
import kotlin.Function1
import kotlin.Suppress
import kotlin.jvm.JvmName

@JvmName("filterMap")
@Suppress(
    "UNCHECKED_CAST",
    "USELESS_CAST",
    "EXTENSION_SHADOWED_BY_MEMBER",
    "UNUSED_PARAMETER"
)
fun <F, A, B> Kind<Kind<ForOptionT, F>, A>.filterMap(FF: Functor<F>, arg1: Function1<A, Option<B>>):
    OptionT<F, B> = arrow.mtl.OptionT.functorFilter<F>(FF).run {
  this@filterMap.filterMap<A, B>(arg1) as arrow.mtl.OptionT<F, B>
}

@JvmName("flattenOption")
@Suppress(
    "UNCHECKED_CAST",
    "USELESS_CAST",
    "EXTENSION_SHADOWED_BY_MEMBER",
    "UNUSED_PARAMETER"
)
fun <F, A> Kind<Kind<ForOptionT, F>, Option<A>>.flattenOption(FF: Functor<F>): OptionT<F, A> =
    arrow.mtl.OptionT.functorFilter<F>(FF).run {
  this@flattenOption.flattenOption<A>() as arrow.mtl.OptionT<F, A>
}

@JvmName("filter")
@Suppress(
    "UNCHECKED_CAST",
    "USELESS_CAST",
    "EXTENSION_SHADOWED_BY_MEMBER",
    "UNUSED_PARAMETER"
)
fun <F, A> Kind<Kind<ForOptionT, F>, A>.filter(FF: Functor<F>, arg1: Function1<A, Boolean>):
    OptionT<F, A> = arrow.mtl.OptionT.functorFilter<F>(FF).run {
  this@filter.filter<A>(arg1) as arrow.mtl.OptionT<F, A>
}

@Suppress(
    "UNCHECKED_CAST",
    "NOTHING_TO_INLINE"
)
inline fun <F> Companion.functorFilter(FF: Functor<F>): OptionTFunctorFilter<F> = object :
    arrow.mtl.extensions.OptionTFunctorFilter<F> { override fun FF(): arrow.typeclasses.Functor<F> =
    FF }