package arrow.mtl.extensions.optiont.monad

import arrow.Kind
import arrow.core.Either
import arrow.core.Eval
import arrow.core.Tuple2
import arrow.mtl.ForOptionT
import arrow.mtl.OptionT
import arrow.mtl.OptionT.Companion
import arrow.mtl.extensions.OptionTMonad
import arrow.typeclasses.Monad
import kotlin.Boolean
import kotlin.Function0
import kotlin.Function1
import kotlin.Suppress
import kotlin.jvm.JvmName

@JvmName("flatMap")
@Suppress(
    "UNCHECKED_CAST",
    "USELESS_CAST",
    "EXTENSION_SHADOWED_BY_MEMBER",
    "UNUSED_PARAMETER"
)
fun <F, A, B> Kind<Kind<ForOptionT, F>, A>.flatMap(MF: Monad<F>, arg1: Function1<A,
    Kind<Kind<ForOptionT, F>, B>>): OptionT<F, B> = arrow.mtl.OptionT.monad<F>(MF).run {
  this@flatMap.flatMap<A, B>(arg1) as arrow.mtl.OptionT<F, B>
}

@JvmName("tailRecM")
@Suppress(
    "UNCHECKED_CAST",
    "USELESS_CAST",
    "EXTENSION_SHADOWED_BY_MEMBER",
    "UNUSED_PARAMETER"
)
fun <F, A, B> tailRecM(
  MF: Monad<F>,
  arg0: A,
  arg1: Function1<A, Kind<Kind<ForOptionT, F>, Either<A, B>>>
): OptionT<F, B> = arrow.mtl.OptionT
   .monad<F>(MF)
   .tailRecM<A, B>(arg0, arg1) as arrow.mtl.OptionT<F, B>

@JvmName("map")
@Suppress(
    "UNCHECKED_CAST",
    "USELESS_CAST",
    "EXTENSION_SHADOWED_BY_MEMBER",
    "UNUSED_PARAMETER"
)
fun <F, A, B> Kind<Kind<ForOptionT, F>, A>.map(MF: Monad<F>, arg1: Function1<A, B>): OptionT<F, B> =
    arrow.mtl.OptionT.monad<F>(MF).run {
  this@map.map<A, B>(arg1) as arrow.mtl.OptionT<F, B>
}

/**
 *  @see [Apply.ap]
 */
@JvmName("ap")
@Suppress(
    "UNCHECKED_CAST",
    "USELESS_CAST",
    "EXTENSION_SHADOWED_BY_MEMBER",
    "UNUSED_PARAMETER"
)
fun <F, A, B> Kind<Kind<ForOptionT, F>, A>.ap(MF: Monad<F>, arg1: Kind<Kind<ForOptionT, F>,
    Function1<A, B>>): OptionT<F, B> = arrow.mtl.OptionT.monad<F>(MF).run {
  this@ap.ap<A, B>(arg1) as arrow.mtl.OptionT<F, B>
}

@JvmName("flatten")
@Suppress(
    "UNCHECKED_CAST",
    "USELESS_CAST",
    "EXTENSION_SHADOWED_BY_MEMBER",
    "UNUSED_PARAMETER"
)
fun <F, A> Kind<Kind<ForOptionT, F>, Kind<Kind<ForOptionT, F>, A>>.flatten(MF: Monad<F>): OptionT<F,
    A> = arrow.mtl.OptionT.monad<F>(MF).run {
  this@flatten.flatten<A>() as arrow.mtl.OptionT<F, A>
}

@JvmName("followedBy")
@Suppress(
    "UNCHECKED_CAST",
    "USELESS_CAST",
    "EXTENSION_SHADOWED_BY_MEMBER",
    "UNUSED_PARAMETER"
)
fun <F, A, B> Kind<Kind<ForOptionT, F>, A>.followedBy(MF: Monad<F>, arg1: Kind<Kind<ForOptionT, F>,
    B>): OptionT<F, B> = arrow.mtl.OptionT.monad<F>(MF).run {
  this@followedBy.followedBy<A, B>(arg1) as arrow.mtl.OptionT<F, B>
}

@JvmName("followedByEval")
@Suppress(
    "UNCHECKED_CAST",
    "USELESS_CAST",
    "EXTENSION_SHADOWED_BY_MEMBER",
    "UNUSED_PARAMETER"
)
fun <F, A, B> Kind<Kind<ForOptionT, F>, A>.followedByEval(MF: Monad<F>,
    arg1: Eval<Kind<Kind<ForOptionT, F>, B>>): OptionT<F, B> = arrow.mtl.OptionT.monad<F>(MF).run {
  this@followedByEval.followedByEval<A, B>(arg1) as arrow.mtl.OptionT<F, B>
}

@JvmName("effectM")
@Suppress(
    "UNCHECKED_CAST",
    "USELESS_CAST",
    "EXTENSION_SHADOWED_BY_MEMBER",
    "UNUSED_PARAMETER"
)
fun <F, A, B> Kind<Kind<ForOptionT, F>, A>.effectM(MF: Monad<F>, arg1: Function1<A,
    Kind<Kind<ForOptionT, F>, B>>): OptionT<F, A> = arrow.mtl.OptionT.monad<F>(MF).run {
  this@effectM.effectM<A, B>(arg1) as arrow.mtl.OptionT<F, A>
}

@JvmName("flatTap")
@Suppress(
    "UNCHECKED_CAST",
    "USELESS_CAST",
    "EXTENSION_SHADOWED_BY_MEMBER",
    "UNUSED_PARAMETER"
)
fun <F, A, B> Kind<Kind<ForOptionT, F>, A>.flatTap(MF: Monad<F>, arg1: Function1<A,
    Kind<Kind<ForOptionT, F>, B>>): OptionT<F, A> = arrow.mtl.OptionT.monad<F>(MF).run {
  this@flatTap.flatTap<A, B>(arg1) as arrow.mtl.OptionT<F, A>
}

@JvmName("productL")
@Suppress(
    "UNCHECKED_CAST",
    "USELESS_CAST",
    "EXTENSION_SHADOWED_BY_MEMBER",
    "UNUSED_PARAMETER"
)
fun <F, A, B> Kind<Kind<ForOptionT, F>, A>.productL(MF: Monad<F>, arg1: Kind<Kind<ForOptionT, F>,
    B>): OptionT<F, A> = arrow.mtl.OptionT.monad<F>(MF).run {
  this@productL.productL<A, B>(arg1) as arrow.mtl.OptionT<F, A>
}

@JvmName("forEffect")
@Suppress(
    "UNCHECKED_CAST",
    "USELESS_CAST",
    "EXTENSION_SHADOWED_BY_MEMBER",
    "UNUSED_PARAMETER"
)
fun <F, A, B> Kind<Kind<ForOptionT, F>, A>.forEffect(MF: Monad<F>, arg1: Kind<Kind<ForOptionT, F>,
    B>): OptionT<F, A> = arrow.mtl.OptionT.monad<F>(MF).run {
  this@forEffect.forEffect<A, B>(arg1) as arrow.mtl.OptionT<F, A>
}

@JvmName("productLEval")
@Suppress(
    "UNCHECKED_CAST",
    "USELESS_CAST",
    "EXTENSION_SHADOWED_BY_MEMBER",
    "UNUSED_PARAMETER"
)
fun <F, A, B> Kind<Kind<ForOptionT, F>, A>.productLEval(MF: Monad<F>,
    arg1: Eval<Kind<Kind<ForOptionT, F>, B>>): OptionT<F, A> = arrow.mtl.OptionT.monad<F>(MF).run {
  this@productLEval.productLEval<A, B>(arg1) as arrow.mtl.OptionT<F, A>
}

@JvmName("forEffectEval")
@Suppress(
    "UNCHECKED_CAST",
    "USELESS_CAST",
    "EXTENSION_SHADOWED_BY_MEMBER",
    "UNUSED_PARAMETER"
)
fun <F, A, B> Kind<Kind<ForOptionT, F>, A>.forEffectEval(MF: Monad<F>,
    arg1: Eval<Kind<Kind<ForOptionT, F>, B>>): OptionT<F, A> = arrow.mtl.OptionT.monad<F>(MF).run {
  this@forEffectEval.forEffectEval<A, B>(arg1) as arrow.mtl.OptionT<F, A>
}

@JvmName("mproduct")
@Suppress(
    "UNCHECKED_CAST",
    "USELESS_CAST",
    "EXTENSION_SHADOWED_BY_MEMBER",
    "UNUSED_PARAMETER"
)
fun <F, A, B> Kind<Kind<ForOptionT, F>, A>.mproduct(MF: Monad<F>, arg1: Function1<A,
    Kind<Kind<ForOptionT, F>, B>>): OptionT<F, Tuple2<A, B>> = arrow.mtl.OptionT.monad<F>(MF).run {
  this@mproduct.mproduct<A, B>(arg1) as arrow.mtl.OptionT<F, arrow.core.Tuple2<A, B>>
}

@JvmName("ifM")
@Suppress(
    "UNCHECKED_CAST",
    "USELESS_CAST",
    "EXTENSION_SHADOWED_BY_MEMBER",
    "UNUSED_PARAMETER"
)
fun <F, B> Kind<Kind<ForOptionT, F>, Boolean>.ifM(
  MF: Monad<F>,
  arg1: Function0<Kind<Kind<ForOptionT, F>, B>>,
  arg2: Function0<Kind<Kind<ForOptionT, F>, B>>
): OptionT<F, B> = arrow.mtl.OptionT.monad<F>(MF).run {
  this@ifM.ifM<B>(arg1, arg2) as arrow.mtl.OptionT<F, B>
}

@JvmName("selectM")
@Suppress(
    "UNCHECKED_CAST",
    "USELESS_CAST",
    "EXTENSION_SHADOWED_BY_MEMBER",
    "UNUSED_PARAMETER"
)
fun <F, A, B> Kind<Kind<ForOptionT, F>, Either<A, B>>.selectM(MF: Monad<F>,
    arg1: Kind<Kind<ForOptionT, F>, Function1<A, B>>): OptionT<F, B> =
    arrow.mtl.OptionT.monad<F>(MF).run {
  this@selectM.selectM<A, B>(arg1) as arrow.mtl.OptionT<F, B>
}

@JvmName("select")
@Suppress(
    "UNCHECKED_CAST",
    "USELESS_CAST",
    "EXTENSION_SHADOWED_BY_MEMBER",
    "UNUSED_PARAMETER"
)
fun <F, A, B> Kind<Kind<ForOptionT, F>, Either<A, B>>.select(MF: Monad<F>,
    arg1: Kind<Kind<ForOptionT, F>, Function1<A, B>>): OptionT<F, B> =
    arrow.mtl.OptionT.monad<F>(MF).run {
  this@select.select<A, B>(arg1) as arrow.mtl.OptionT<F, B>
}

/**
 * ank_macro_hierarchy(arrow.typeclasses.Monad)
 *
 * [Monad] abstract over the ability to declare sequential computations that are dependent in the order or
 * the results of previous computations.
 *
 * Given a type constructor [F] with a value of [A] we can compose multiple operations of type
 * `Kind<F, ?>` where `?` denotes a value being transformed.
 *
 * This is true for all type constructors that can support the [Monad] type class including and not limited to
 * [IO], [DeferredK], [ObservableK], [Option], [Either], [List], [Try] ...
 *
 * [The Monad Tutorial](https://arrow-kt.io/docs/patterns/monads/)
 */
@Suppress(
    "UNCHECKED_CAST",
    "NOTHING_TO_INLINE"
)
inline fun <F> Companion.monad(MF: Monad<F>): OptionTMonad<F> = object :
    arrow.mtl.extensions.OptionTMonad<F> { override fun MF(): arrow.typeclasses.Monad<F> = MF }