package arrow.mtl.extensions.optiont.monadError

import arrow.Kind
import arrow.core.Either
import arrow.mtl.ForOptionT
import arrow.mtl.OptionT
import arrow.mtl.OptionT.Companion
import arrow.mtl.extensions.OptionTMonadError
import arrow.typeclasses.MonadError
import kotlin.Boolean
import kotlin.Function0
import kotlin.Function1
import kotlin.Suppress
import kotlin.jvm.JvmName

@JvmName("ensure")
@Suppress(
    "UNCHECKED_CAST",
    "USELESS_CAST",
    "EXTENSION_SHADOWED_BY_MEMBER",
    "UNUSED_PARAMETER"
)
fun <F, E, A> Kind<Kind<ForOptionT, F>, A>.ensure(
  ME: MonadError<F, E>,
  arg1: Function0<E>,
  arg2: Function1<A, Boolean>
): OptionT<F, A> = arrow.mtl.OptionT.monadError<F, E>(ME).run {
  this@ensure.ensure<A>(arg1, arg2) as arrow.mtl.OptionT<F, A>
}

@JvmName("redeemWith")
@Suppress(
    "UNCHECKED_CAST",
    "USELESS_CAST",
    "EXTENSION_SHADOWED_BY_MEMBER",
    "UNUSED_PARAMETER"
)
fun <F, E, A, B> Kind<Kind<ForOptionT, F>, A>.redeemWith(
  ME: MonadError<F, E>,
  arg1: Function1<E, Kind<Kind<ForOptionT, F>, B>>,
  arg2: Function1<A, Kind<Kind<ForOptionT, F>, B>>
): OptionT<F, B> = arrow.mtl.OptionT.monadError<F, E>(ME).run {
  this@redeemWith.redeemWith<A, B>(arg1, arg2) as arrow.mtl.OptionT<F, B>
}

@JvmName("rethrow")
@Suppress(
    "UNCHECKED_CAST",
    "USELESS_CAST",
    "EXTENSION_SHADOWED_BY_MEMBER",
    "UNUSED_PARAMETER"
)
fun <F, E, A> Kind<Kind<ForOptionT, F>, Either<E, A>>.rethrow(ME: MonadError<F, E>): OptionT<F, A> =
    arrow.mtl.OptionT.monadError<F, E>(ME).run {
  this@rethrow.rethrow<A>() as arrow.mtl.OptionT<F, A>
}

@Suppress(
    "UNCHECKED_CAST",
    "NOTHING_TO_INLINE"
)
inline fun <F, E> Companion.monadError(ME: MonadError<F, E>): OptionTMonadError<F, E> = object :
    arrow.mtl.extensions.OptionTMonadError<F, E> { override fun ME():
    arrow.typeclasses.MonadError<F, E> = ME }