package arrow.mtl.extensions.optiont.traverse

import arrow.Kind
import arrow.mtl.ForOptionT
import arrow.mtl.OptionT
import arrow.mtl.OptionT.Companion
import arrow.mtl.extensions.OptionTTraverse
import arrow.typeclasses.Applicative
import arrow.typeclasses.Monad
import arrow.typeclasses.Traverse
import kotlin.Function1
import kotlin.Suppress
import kotlin.jvm.JvmName

@JvmName("traverse")
@Suppress(
    "UNCHECKED_CAST",
    "USELESS_CAST",
    "EXTENSION_SHADOWED_BY_MEMBER",
    "UNUSED_PARAMETER"
)
fun <F, G, A, B> Kind<Kind<ForOptionT, F>, A>.traverse(
  FFT: Traverse<F>,
  arg1: Applicative<G>,
  arg2: Function1<A, Kind<G, B>>
): Kind<G, Kind<Kind<ForOptionT, F>, B>> = arrow.mtl.OptionT.traverse<F>(FFT).run {
  this@traverse.traverse<G, A, B>(arg1, arg2) as arrow.Kind<G,
    arrow.Kind<arrow.Kind<arrow.mtl.ForOptionT, F>, B>>
}

@JvmName("sequence")
@Suppress(
    "UNCHECKED_CAST",
    "USELESS_CAST",
    "EXTENSION_SHADOWED_BY_MEMBER",
    "UNUSED_PARAMETER"
)
fun <F, G, A> Kind<Kind<ForOptionT, F>, Kind<G, A>>.sequence(FFT: Traverse<F>,
    arg1: Applicative<G>): Kind<G, Kind<Kind<ForOptionT, F>, A>> =
    arrow.mtl.OptionT.traverse<F>(FFT).run {
  this@sequence.sequence<G, A>(arg1) as arrow.Kind<G, arrow.Kind<arrow.Kind<arrow.mtl.ForOptionT,
    F>, A>>
}

@JvmName("map")
@Suppress(
    "UNCHECKED_CAST",
    "USELESS_CAST",
    "EXTENSION_SHADOWED_BY_MEMBER",
    "UNUSED_PARAMETER"
)
fun <F, A, B> Kind<Kind<ForOptionT, F>, A>.map(FFT: Traverse<F>, arg1: Function1<A, B>): OptionT<F,
    B> = arrow.mtl.OptionT.traverse<F>(FFT).run {
  this@map.map<A, B>(arg1) as arrow.mtl.OptionT<F, B>
}

@JvmName("flatTraverse")
@Suppress(
    "UNCHECKED_CAST",
    "USELESS_CAST",
    "EXTENSION_SHADOWED_BY_MEMBER",
    "UNUSED_PARAMETER"
)
fun <F, G, A, B> Kind<Kind<ForOptionT, F>, A>.flatTraverse(
  FFT: Traverse<F>,
  arg1: Monad<Kind<ForOptionT, F>>,
  arg2: Applicative<G>,
  arg3: Function1<A, Kind<G, Kind<Kind<ForOptionT, F>, B>>>
): Kind<G, Kind<Kind<ForOptionT, F>, B>> = arrow.mtl.OptionT.traverse<F>(FFT).run {
  this@flatTraverse.flatTraverse<G, A, B>(arg1, arg2, arg3) as arrow.Kind<G,
    arrow.Kind<arrow.Kind<arrow.mtl.ForOptionT, F>, B>>
}

@Suppress(
    "UNCHECKED_CAST",
    "NOTHING_TO_INLINE"
)
inline fun <F> Companion.traverse(FFT: Traverse<F>): OptionTTraverse<F> = object :
    arrow.mtl.extensions.OptionTTraverse<F> { override fun FFT(): arrow.typeclasses.Traverse<F> =
    FFT }