package arrow.mtl.extensions.statet.applicativeError

import arrow.Kind
import arrow.core.Either
import arrow.core.ForOption
import arrow.core.ForTry
import arrow.mtl.ForStateT
import arrow.mtl.StateT
import arrow.mtl.StateT.Companion
import arrow.mtl.extensions.StateTApplicativeError
import arrow.typeclasses.ApplicativeError
import arrow.typeclasses.MonadError
import kotlin.Function0
import kotlin.Function1
import kotlin.Suppress
import kotlin.Throwable
import kotlin.jvm.JvmName

@JvmName("handleErrorWith")
@Suppress(
    "UNCHECKED_CAST",
    "USELESS_CAST",
    "EXTENSION_SHADOWED_BY_MEMBER",
    "UNUSED_PARAMETER"
)
fun <F, S, E, A> Kind<Kind<Kind<ForStateT, F>, S>, A>.handleErrorWith(ME: MonadError<F, E>,
    arg1: Function1<E, Kind<Kind<Kind<ForStateT, F>, S>, A>>): StateT<F, S, A> =
    arrow.mtl.StateT.applicativeError<F, S, E>(ME).run {
  this@handleErrorWith.handleErrorWith<A>(arg1) as arrow.mtl.StateT<F, S, A>
}

@JvmName("raiseError1")
@Suppress(
    "UNCHECKED_CAST",
    "USELESS_CAST",
    "EXTENSION_SHADOWED_BY_MEMBER",
    "UNUSED_PARAMETER"
)
fun <F, S, E, A> E.raiseError(ME: MonadError<F, E>): StateT<F, S, A> =
    arrow.mtl.StateT.applicativeError<F, S, E>(ME).run {
  this@raiseError.raiseError<A>() as arrow.mtl.StateT<F, S, A>
}

@JvmName("fromOption")
@Suppress(
    "UNCHECKED_CAST",
    "USELESS_CAST",
    "EXTENSION_SHADOWED_BY_MEMBER",
    "UNUSED_PARAMETER"
)
fun <F, S, E, A> Kind<ForOption, A>.fromOption(ME: MonadError<F, E>, arg1: Function0<E>): StateT<F,
    S, A> = arrow.mtl.StateT.applicativeError<F, S, E>(ME).run {
  this@fromOption.fromOption<A>(arg1) as arrow.mtl.StateT<F, S, A>
}

@JvmName("fromEither")
@Suppress(
    "UNCHECKED_CAST",
    "USELESS_CAST",
    "EXTENSION_SHADOWED_BY_MEMBER",
    "UNUSED_PARAMETER"
)
fun <F, S, E, A, EE> Either<EE, A>.fromEither(ME: MonadError<F, E>, arg1: Function1<EE, E>):
    StateT<F, S, A> = arrow.mtl.StateT.applicativeError<F, S, E>(ME).run {
  this@fromEither.fromEither<A, EE>(arg1) as arrow.mtl.StateT<F, S, A>
}

@JvmName("fromTry")
@Suppress(
    "UNCHECKED_CAST",
    "USELESS_CAST",
    "EXTENSION_SHADOWED_BY_MEMBER",
    "UNUSED_PARAMETER"
)
fun <F, S, E, A> Kind<ForTry, A>.fromTry(ME: MonadError<F, E>, arg1: Function1<Throwable, E>):
    StateT<F, S, A> = arrow.mtl.StateT.applicativeError<F, S, E>(ME).run {
  this@fromTry.fromTry<A>(arg1) as arrow.mtl.StateT<F, S, A>
}

@JvmName("handleError")
@Suppress(
    "UNCHECKED_CAST",
    "USELESS_CAST",
    "EXTENSION_SHADOWED_BY_MEMBER",
    "UNUSED_PARAMETER"
)
fun <F, S, E, A> Kind<Kind<Kind<ForStateT, F>, S>, A>.handleError(ME: MonadError<F, E>,
    arg1: Function1<E, A>): StateT<F, S, A> = arrow.mtl.StateT.applicativeError<F, S, E>(ME).run {
  this@handleError.handleError<A>(arg1) as arrow.mtl.StateT<F, S, A>
}

@JvmName("redeem")
@Suppress(
    "UNCHECKED_CAST",
    "USELESS_CAST",
    "EXTENSION_SHADOWED_BY_MEMBER",
    "UNUSED_PARAMETER"
)
fun <F, S, E, A, B> Kind<Kind<Kind<ForStateT, F>, S>, A>.redeem(
  ME: MonadError<F, E>,
  arg1: Function1<E, B>,
  arg2: Function1<A, B>
): StateT<F, S, B> = arrow.mtl.StateT.applicativeError<F, S, E>(ME).run {
  this@redeem.redeem<A, B>(arg1, arg2) as arrow.mtl.StateT<F, S, B>
}

@JvmName("attempt")
@Suppress(
    "UNCHECKED_CAST",
    "USELESS_CAST",
    "EXTENSION_SHADOWED_BY_MEMBER",
    "UNUSED_PARAMETER"
)
fun <F, S, E, A> Kind<Kind<Kind<ForStateT, F>, S>, A>.attempt(ME: MonadError<F, E>): StateT<F, S,
    Either<E, A>> = arrow.mtl.StateT.applicativeError<F, S, E>(ME).run {
  this@attempt.attempt<A>() as arrow.mtl.StateT<F, S, arrow.core.Either<E, A>>
}

@JvmName("catch")
@Suppress(
    "UNCHECKED_CAST",
    "USELESS_CAST",
    "EXTENSION_SHADOWED_BY_MEMBER",
    "UNUSED_PARAMETER"
)
fun <F, S, E, A> catch(
  ME: MonadError<F, E>,
  arg0: Function1<Throwable, E>,
  arg1: Function0<A>
): StateT<F, S, A> = arrow.mtl.StateT
   .applicativeError<F, S, E>(ME)
   .catch<A>(arg0, arg1) as arrow.mtl.StateT<F, S, A>

@JvmName("catch")
@Suppress(
    "UNCHECKED_CAST",
    "USELESS_CAST",
    "EXTENSION_SHADOWED_BY_MEMBER",
    "UNUSED_PARAMETER"
)
fun <F, S, E, A> ApplicativeError<Kind<Kind<ForStateT, F>, S>, Throwable>.catch(ME: MonadError<F,
    E>, arg1: Function0<A>): StateT<F, S, A> = arrow.mtl.StateT.applicativeError<F, S, E>(ME).run {
  this@catch.catch<A>(arg1) as arrow.mtl.StateT<F, S, A>
}

@JvmName("raiseError")
@Suppress(
    "UNCHECKED_CAST",
    "USELESS_CAST",
    "EXTENSION_SHADOWED_BY_MEMBER",
    "UNUSED_PARAMETER"
)
fun <F, S, E, A> raiseError(ME: MonadError<F, E>, e: E): StateT<F, S, A> = arrow.mtl.StateT
   .applicativeError<F, S, E>(ME)
   .raiseError<A>(e) as arrow.mtl.StateT<F, S, A>

@Suppress(
    "UNCHECKED_CAST",
    "NOTHING_TO_INLINE"
)
inline fun <F, S, E> Companion.applicativeError(ME: MonadError<F, E>): StateTApplicativeError<F, S,
    E> = object : arrow.mtl.extensions.StateTApplicativeError<F, S, E> { override fun ME():
    arrow.typeclasses.MonadError<F, E> = ME }