package arrow.mtl.extensions.statet.contravariant

import arrow.Kind
import arrow.mtl.ForStateT
import arrow.mtl.StateT
import arrow.mtl.StateT.Companion
import arrow.mtl.extensions.StateTContravariantInstance
import arrow.typeclasses.Contravariant
import arrow.typeclasses.Monad
import kotlin.Function1
import kotlin.Suppress
import kotlin.jvm.JvmName

@JvmName("contramap")
@Suppress(
    "UNCHECKED_CAST",
    "USELESS_CAST",
    "EXTENSION_SHADOWED_BY_MEMBER",
    "UNUSED_PARAMETER"
)
fun <F, S, A, B> Kind<Kind<Kind<ForStateT, F>, S>, A>.contramap(
  CF: Contravariant<F>,
  MF: Monad<F>,
  arg1: Function1<B, A>
): StateT<F, S, B> = arrow.mtl.StateT.contravariant<F, S>(CF, MF).run {
  this@contramap.contramap<A, B>(arg1) as arrow.mtl.StateT<F, S, B>
}

@JvmName("lift1")
@Suppress(
    "UNCHECKED_CAST",
    "USELESS_CAST",
    "EXTENSION_SHADOWED_BY_MEMBER",
    "UNUSED_PARAMETER"
)
fun <F, S, A, B> lift(
  CF: Contravariant<F>,
  MF: Monad<F>,
  arg0: Function1<A, B>
): Function1<Kind<Kind<Kind<ForStateT, F>, S>, B>, Kind<Kind<Kind<ForStateT, F>, S>, A>> =
    arrow.mtl.StateT
   .contravariant<F, S>(CF, MF)
   .lift<A, B>(arg0) as kotlin.Function1<arrow.Kind<arrow.Kind<arrow.Kind<arrow.mtl.ForStateT, F>,
    S>, B>, arrow.Kind<arrow.Kind<arrow.Kind<arrow.mtl.ForStateT, F>, S>, A>>

@JvmName("imap")
@Suppress(
    "UNCHECKED_CAST",
    "USELESS_CAST",
    "EXTENSION_SHADOWED_BY_MEMBER",
    "UNUSED_PARAMETER"
)
fun <F, S, A, B> Kind<Kind<Kind<ForStateT, F>, S>, A>.imap(
  CF: Contravariant<F>,
  MF: Monad<F>,
  arg1: Function1<A, B>,
  arg2: Function1<B, A>
): StateT<F, S, B> = arrow.mtl.StateT.contravariant<F, S>(CF, MF).run {
  this@imap.imap<A, B>(arg1, arg2) as arrow.mtl.StateT<F, S, B>
}

@JvmName("narrow")
@Suppress(
    "UNCHECKED_CAST",
    "USELESS_CAST",
    "EXTENSION_SHADOWED_BY_MEMBER",
    "UNUSED_PARAMETER"
)
fun <F, S, A, B : A> Kind<Kind<Kind<ForStateT, F>, S>, A>.narrow(CF: Contravariant<F>,
    MF: Monad<F>): StateT<F, S, B> = arrow.mtl.StateT.contravariant<F, S>(CF, MF).run {
  this@narrow.narrow<A, B>() as arrow.mtl.StateT<F, S, B>
}

@Suppress(
    "UNCHECKED_CAST",
    "NOTHING_TO_INLINE"
)
inline fun <F, S> Companion.contravariant(CF: Contravariant<F>, MF: Monad<F>):
    StateTContravariantInstance<F, S> = object : arrow.mtl.extensions.StateTContravariantInstance<F,
    S> { override fun CF(): arrow.typeclasses.Contravariant<F> = CF

  override fun MF(): arrow.typeclasses.Monad<F> = MF }