package arrow.mtl.extensions.statet.monadError

import arrow.Kind
import arrow.core.Either
import arrow.mtl.ForStateT
import arrow.mtl.StateT
import arrow.mtl.StateT.Companion
import arrow.mtl.extensions.StateTMonadError
import arrow.typeclasses.MonadError
import kotlin.Boolean
import kotlin.Function0
import kotlin.Function1
import kotlin.Suppress
import kotlin.jvm.JvmName

@JvmName("ensure")
@Suppress(
    "UNCHECKED_CAST",
    "USELESS_CAST",
    "EXTENSION_SHADOWED_BY_MEMBER",
    "UNUSED_PARAMETER"
)
fun <F, S, E, A> Kind<Kind<Kind<ForStateT, F>, S>, A>.ensure(
  ME: MonadError<F, E>,
  arg1: Function0<E>,
  arg2: Function1<A, Boolean>
): StateT<F, S, A> = arrow.mtl.StateT.monadError<F, S, E>(ME).run {
  this@ensure.ensure<A>(arg1, arg2) as arrow.mtl.StateT<F, S, A>
}

@JvmName("redeemWith")
@Suppress(
    "UNCHECKED_CAST",
    "USELESS_CAST",
    "EXTENSION_SHADOWED_BY_MEMBER",
    "UNUSED_PARAMETER"
)
fun <F, S, E, A, B> Kind<Kind<Kind<ForStateT, F>, S>, A>.redeemWith(
  ME: MonadError<F, E>,
  arg1: Function1<E, Kind<Kind<Kind<ForStateT, F>, S>, B>>,
  arg2: Function1<A, Kind<Kind<Kind<ForStateT, F>, S>, B>>
): StateT<F, S, B> = arrow.mtl.StateT.monadError<F, S, E>(ME).run {
  this@redeemWith.redeemWith<A, B>(arg1, arg2) as arrow.mtl.StateT<F, S, B>
}

@JvmName("rethrow")
@Suppress(
    "UNCHECKED_CAST",
    "USELESS_CAST",
    "EXTENSION_SHADOWED_BY_MEMBER",
    "UNUSED_PARAMETER"
)
fun <F, S, E, A> Kind<Kind<Kind<ForStateT, F>, S>, Either<E, A>>.rethrow(ME: MonadError<F, E>):
    StateT<F, S, A> = arrow.mtl.StateT.monadError<F, S, E>(ME).run {
  this@rethrow.rethrow<A>() as arrow.mtl.StateT<F, S, A>
}

@Suppress(
    "UNCHECKED_CAST",
    "NOTHING_TO_INLINE"
)
inline fun <F, S, E> Companion.monadError(ME: MonadError<F, E>): StateTMonadError<F, S, E> = object
    : arrow.mtl.extensions.StateTMonadError<F, S, E> { override fun ME():
    arrow.typeclasses.MonadError<F, E> = ME }