package arrow.mtl.extensions.writert.contravariant

import arrow.Kind
import arrow.mtl.ForWriterT
import arrow.mtl.WriterT
import arrow.mtl.WriterT.Companion
import arrow.mtl.extensions.WriterTContravariantInstance
import arrow.typeclasses.Contravariant
import kotlin.Function1
import kotlin.Suppress
import kotlin.jvm.JvmName

@JvmName("contramap")
@Suppress(
    "UNCHECKED_CAST",
    "USELESS_CAST",
    "EXTENSION_SHADOWED_BY_MEMBER",
    "UNUSED_PARAMETER"
)
fun <F, W, A, B> Kind<Kind<Kind<ForWriterT, F>, W>, A>.contramap(CF: Contravariant<F>,
    arg1: Function1<B, A>): WriterT<F, W, B> = arrow.mtl.WriterT.contravariant<F, W>(CF).run {
  this@contramap.contramap<A, B>(arg1) as arrow.mtl.WriterT<F, W, B>
}

@JvmName("lift1")
@Suppress(
    "UNCHECKED_CAST",
    "USELESS_CAST",
    "EXTENSION_SHADOWED_BY_MEMBER",
    "UNUSED_PARAMETER"
)
fun <F, W, A, B> lift(CF: Contravariant<F>, arg0: Function1<A, B>):
    Function1<Kind<Kind<Kind<ForWriterT, F>, W>, B>, Kind<Kind<Kind<ForWriterT, F>, W>, A>> =
    arrow.mtl.WriterT
   .contravariant<F, W>(CF)
   .lift<A, B>(arg0) as kotlin.Function1<arrow.Kind<arrow.Kind<arrow.Kind<arrow.mtl.ForWriterT, F>,
    W>, B>, arrow.Kind<arrow.Kind<arrow.Kind<arrow.mtl.ForWriterT, F>, W>, A>>

@JvmName("imap")
@Suppress(
    "UNCHECKED_CAST",
    "USELESS_CAST",
    "EXTENSION_SHADOWED_BY_MEMBER",
    "UNUSED_PARAMETER"
)
fun <F, W, A, B> Kind<Kind<Kind<ForWriterT, F>, W>, A>.imap(
  CF: Contravariant<F>,
  arg1: Function1<A, B>,
  arg2: Function1<B, A>
): WriterT<F, W, B> = arrow.mtl.WriterT.contravariant<F, W>(CF).run {
  this@imap.imap<A, B>(arg1, arg2) as arrow.mtl.WriterT<F, W, B>
}

@JvmName("narrow")
@Suppress(
    "UNCHECKED_CAST",
    "USELESS_CAST",
    "EXTENSION_SHADOWED_BY_MEMBER",
    "UNUSED_PARAMETER"
)
fun <F, W, A, B : A> Kind<Kind<Kind<ForWriterT, F>, W>, A>.narrow(CF: Contravariant<F>): WriterT<F,
    W, B> = arrow.mtl.WriterT.contravariant<F, W>(CF).run {
  this@narrow.narrow<A, B>() as arrow.mtl.WriterT<F, W, B>
}

@Suppress(
    "UNCHECKED_CAST",
    "NOTHING_TO_INLINE"
)
inline fun <F, W> Companion.contravariant(CF: Contravariant<F>): WriterTContravariantInstance<F, W>
    = object : arrow.mtl.extensions.WriterTContravariantInstance<F, W> { override fun CF():
    arrow.typeclasses.Contravariant<F> = CF }