package arrow.mtl.extensions.writert.monadError

import arrow.Kind
import arrow.core.Either
import arrow.mtl.ForWriterT
import arrow.mtl.WriterT
import arrow.mtl.WriterT.Companion
import arrow.mtl.extensions.WriterTMonadError
import arrow.typeclasses.MonadError
import arrow.typeclasses.Monoid
import kotlin.Boolean
import kotlin.Function0
import kotlin.Function1
import kotlin.Suppress
import kotlin.jvm.JvmName

@JvmName("ensure")
@Suppress(
    "UNCHECKED_CAST",
    "USELESS_CAST",
    "EXTENSION_SHADOWED_BY_MEMBER",
    "UNUSED_PARAMETER"
)
fun <F, W, E, A> Kind<Kind<Kind<ForWriterT, F>, W>, A>.ensure(
  ME: MonadError<F, E>,
  MM: Monoid<W>,
  arg1: Function0<E>,
  arg2: Function1<A, Boolean>
): WriterT<F, W, A> = arrow.mtl.WriterT.monadError<F, W, E>(ME, MM).run {
  this@ensure.ensure<A>(arg1, arg2) as arrow.mtl.WriterT<F, W, A>
}

@JvmName("redeemWith")
@Suppress(
    "UNCHECKED_CAST",
    "USELESS_CAST",
    "EXTENSION_SHADOWED_BY_MEMBER",
    "UNUSED_PARAMETER"
)
fun <F, W, E, A, B> Kind<Kind<Kind<ForWriterT, F>, W>, A>.redeemWith(
  ME: MonadError<F, E>,
  MM: Monoid<W>,
  arg1: Function1<E, Kind<Kind<Kind<ForWriterT, F>, W>, B>>,
  arg2: Function1<A, Kind<Kind<Kind<ForWriterT, F>, W>, B>>
): WriterT<F, W, B> = arrow.mtl.WriterT.monadError<F, W, E>(ME, MM).run {
  this@redeemWith.redeemWith<A, B>(arg1, arg2) as arrow.mtl.WriterT<F, W, B>
}

@JvmName("rethrow")
@Suppress(
    "UNCHECKED_CAST",
    "USELESS_CAST",
    "EXTENSION_SHADOWED_BY_MEMBER",
    "UNUSED_PARAMETER"
)
fun <F, W, E, A> Kind<Kind<Kind<ForWriterT, F>, W>, Either<E, A>>.rethrow(ME: MonadError<F, E>,
    MM: Monoid<W>): WriterT<F, W, A> = arrow.mtl.WriterT.monadError<F, W, E>(ME, MM).run {
  this@rethrow.rethrow<A>() as arrow.mtl.WriterT<F, W, A>
}

@Suppress(
    "UNCHECKED_CAST",
    "NOTHING_TO_INLINE"
)
inline fun <F, W, E> Companion.monadError(ME: MonadError<F, E>, MM: Monoid<W>): WriterTMonadError<F,
    W, E> = object : arrow.mtl.extensions.WriterTMonadError<F, W, E> { override fun ME():
    arrow.typeclasses.MonadError<F, E> = ME

  override fun MM(): arrow.typeclasses.Monoid<W> = MM }