package arrow.mtl.extensions.writert.monadFilter

import arrow.Kind
import arrow.core.Option
import arrow.mtl.ForWriterT
import arrow.mtl.WriterT
import arrow.mtl.WriterT.Companion
import arrow.mtl.extensions.WriterTMonadFilter
import arrow.typeclasses.MonadFilter
import arrow.typeclasses.MonadFilterSyntax
import arrow.typeclasses.Monoid
import kotlin.Function1
import kotlin.Suppress
import kotlin.jvm.JvmName

@JvmName("filterMap")
@Suppress(
    "UNCHECKED_CAST",
    "USELESS_CAST",
    "EXTENSION_SHADOWED_BY_MEMBER",
    "UNUSED_PARAMETER"
)
fun <F, W, A, B> Kind<Kind<Kind<ForWriterT, F>, W>, A>.filterMap(
  FF: MonadFilter<F>,
  MM: Monoid<W>,
  arg1: Function1<A, Option<B>>
): WriterT<F, W, B> = arrow.mtl.WriterT.monadFilter<F, W>(FF, MM).run {
  this@filterMap.filterMap<A, B>(arg1) as arrow.mtl.WriterT<F, W, B>
}

@JvmName("bindingFilter")
@Suppress(
    "UNCHECKED_CAST",
    "USELESS_CAST",
    "EXTENSION_SHADOWED_BY_MEMBER",
    "UNUSED_PARAMETER"
)
fun <F, W, B> bindingFilter(
  FF: MonadFilter<F>,
  MM: Monoid<W>,
  arg0: suspend MonadFilterSyntax<Kind<Kind<ForWriterT, F>, W>>.() -> B
): WriterT<F, W, B> = arrow.mtl.WriterT
   .monadFilter<F, W>(FF, MM)
   .bindingFilter<B>(arg0) as arrow.mtl.WriterT<F, W, B>

@JvmName("empty")
@Suppress(
    "UNCHECKED_CAST",
    "USELESS_CAST",
    "EXTENSION_SHADOWED_BY_MEMBER",
    "UNUSED_PARAMETER"
)
fun <F, W, A> empty(FF: MonadFilter<F>, MM: Monoid<W>): WriterT<F, W, A> = arrow.mtl.WriterT
   .monadFilter<F, W>(FF, MM)
   .empty<A>() as arrow.mtl.WriterT<F, W, A>

@Suppress(
    "UNCHECKED_CAST",
    "NOTHING_TO_INLINE"
)
inline fun <F, W> Companion.monadFilter(FF: MonadFilter<F>, MM: Monoid<W>): WriterTMonadFilter<F, W>
    = object : arrow.mtl.extensions.WriterTMonadFilter<F, W> { override fun FF():
    arrow.typeclasses.MonadFilter<F> = FF

  override fun MM(): arrow.typeclasses.Monoid<W> = MM }