package arrow.mtl.extensions.writert.monadWriter

import arrow.Kind
import arrow.core.Tuple2
import arrow.mtl.ForWriterT
import arrow.mtl.WriterT
import arrow.mtl.WriterT.Companion
import arrow.mtl.extensions.WriterTMonadWriter
import arrow.typeclasses.Monad
import arrow.typeclasses.Monoid
import kotlin.Function1
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

@JvmName("listen")
@Suppress(
    "UNCHECKED_CAST",
    "USELESS_CAST",
    "EXTENSION_SHADOWED_BY_MEMBER",
    "UNUSED_PARAMETER"
)
fun <F, W, A> Kind<Kind<Kind<ForWriterT, F>, W>, A>.listen(MF: Monad<F>, MM: Monoid<W>): WriterT<F,
    W, Tuple2<W, A>> = arrow.mtl.WriterT.monadWriter<F, W>(MF, MM).run {
  this@listen.listen<A>() as arrow.mtl.WriterT<F, W, arrow.core.Tuple2<W, A>>
}

@JvmName("pass")
@Suppress(
    "UNCHECKED_CAST",
    "USELESS_CAST",
    "EXTENSION_SHADOWED_BY_MEMBER",
    "UNUSED_PARAMETER"
)
fun <F, W, A> Kind<Kind<Kind<ForWriterT, F>, W>, Tuple2<Function1<W, W>, A>>.pass(MF: Monad<F>,
    MM: Monoid<W>): WriterT<F, W, A> = arrow.mtl.WriterT.monadWriter<F, W>(MF, MM).run {
  this@pass.pass<A>() as arrow.mtl.WriterT<F, W, A>
}

@JvmName("listens")
@Suppress(
    "UNCHECKED_CAST",
    "USELESS_CAST",
    "EXTENSION_SHADOWED_BY_MEMBER",
    "UNUSED_PARAMETER"
)
fun <F, W, A, B> Kind<Kind<Kind<ForWriterT, F>, W>, A>.listens(
  MF: Monad<F>,
  MM: Monoid<W>,
  arg1: Function1<W, B>
): WriterT<F, W, Tuple2<B, A>> = arrow.mtl.WriterT.monadWriter<F, W>(MF, MM).run {
  this@listens.listens<A, B>(arg1) as arrow.mtl.WriterT<F, W, arrow.core.Tuple2<B, A>>
}

@JvmName("censor")
@Suppress(
    "UNCHECKED_CAST",
    "USELESS_CAST",
    "EXTENSION_SHADOWED_BY_MEMBER",
    "UNUSED_PARAMETER"
)
fun <F, W, A> Kind<Kind<Kind<ForWriterT, F>, W>, A>.censor(
  MF: Monad<F>,
  MM: Monoid<W>,
  arg1: Function1<W, W>
): WriterT<F, W, A> = arrow.mtl.WriterT.monadWriter<F, W>(MF, MM).run {
  this@censor.censor<A>(arg1) as arrow.mtl.WriterT<F, W, A>
}

@JvmName("tell")
@Suppress(
    "UNCHECKED_CAST",
    "USELESS_CAST",
    "EXTENSION_SHADOWED_BY_MEMBER",
    "UNUSED_PARAMETER"
)
fun <F, W> tell(
  MF: Monad<F>,
  MM: Monoid<W>,
  w: W
): WriterT<F, W, Unit> = arrow.mtl.WriterT
   .monadWriter<F, W>(MF, MM)
   .tell(w) as arrow.mtl.WriterT<F, W, kotlin.Unit>

@Suppress(
    "UNCHECKED_CAST",
    "NOTHING_TO_INLINE"
)
inline fun <F, W> Companion.monadWriter(MF: Monad<F>, MM: Monoid<W>): WriterTMonadWriter<F, W> =
    object : arrow.mtl.extensions.WriterTMonadWriter<F, W> { override fun MF():
    arrow.typeclasses.Monad<F> = MF

  override fun MM(): arrow.typeclasses.Monoid<W> = MM }