package arrow.validation.refinedTypes.generic.validated.nonEmpty

import arrow.core.NonEmptyList
import arrow.core.Validated
import arrow.core.Validated.Companion
import arrow.validation.RefinedPredicateException
import arrow.validation.refinedTypes.generic.ValidatedNonEmpty
import kotlin.Boolean
import kotlin.Function1
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

@JvmName("refinement")
@Suppress(
    "UNCHECKED_CAST",
    "USELESS_CAST",
    "EXTENSION_SHADOWED_BY_MEMBER",
    "UNUSED_PARAMETER"
)
fun <A> A.refinement(empty: A): Boolean = arrow.core.Validated.nonEmpty<A>(empty).run {
  this@refinement.refinement() as kotlin.Boolean
}

@JvmName("nonEmpty")
@Suppress(
    "UNCHECKED_CAST",
    "USELESS_CAST",
    "EXTENSION_SHADOWED_BY_MEMBER",
    "UNUSED_PARAMETER"
)
fun <A> A.nonEmpty(empty: A): Validated<NonEmptyList<RefinedPredicateException>, A> =
    arrow.core.Validated.nonEmpty<A>(empty).run {
  this@nonEmpty.nonEmpty() as
    arrow.core.Validated<arrow.core.NonEmptyList<arrow.validation.RefinedPredicateException>, A>
}

@JvmName("nonEmpty")
@Suppress(
    "UNCHECKED_CAST",
    "USELESS_CAST",
    "EXTENSION_SHADOWED_BY_MEMBER",
    "UNUSED_PARAMETER"
)
fun <A, B> A.nonEmpty(empty: A, f: Function1<A, B>):
    Validated<NonEmptyList<RefinedPredicateException>, B> =
    arrow.core.Validated.nonEmpty<A>(empty).run {
  this@nonEmpty.nonEmpty<B>(f) as
    arrow.core.Validated<arrow.core.NonEmptyList<arrow.validation.RefinedPredicateException>, B>
}

@JvmName("invalidValueMsg")
@Suppress(
    "UNCHECKED_CAST",
    "USELESS_CAST",
    "EXTENSION_SHADOWED_BY_MEMBER",
    "UNUSED_PARAMETER"
)
fun <A> invalidValueMsg(empty: A, a: A): String = arrow.core.Validated
   .nonEmpty<A>(empty)
   .invalidValueMsg(a) as kotlin.String

@JvmName("empty")
@Suppress(
    "UNCHECKED_CAST",
    "USELESS_CAST",
    "EXTENSION_SHADOWED_BY_MEMBER",
    "UNUSED_PARAMETER"
)
fun <A> empty(empty: A): A = arrow.core.Validated
   .nonEmpty<A>(empty)
   .empty() as A

@Suppress(
    "UNCHECKED_CAST",
    "NOTHING_TO_INLINE"
)
inline fun <A> Companion.nonEmpty(empty: A): ValidatedNonEmpty<A> = object :
    arrow.validation.refinedTypes.generic.ValidatedNonEmpty<A> { override fun empty(): A = empty }