package arrow.validation.refinedTypes.numeric.either.greater

import arrow.core.Either
import arrow.core.Either.Companion
import arrow.core.NonEmptyList
import arrow.typeclasses.Order
import arrow.validation.RefinedPredicateException
import arrow.validation.refinedTypes.numeric.EitherGreater
import kotlin.Boolean
import kotlin.Function1
import kotlin.Number
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

@JvmName("refinement")
@Suppress(
    "UNCHECKED_CAST",
    "USELESS_CAST",
    "EXTENSION_SHADOWED_BY_MEMBER",
    "UNUSED_PARAMETER"
)
fun <A : Number> A.refinement(ORD: Order<A>, min: A): Boolean =
    arrow.core.Either.greater<A>(ORD, min).run {
  this@refinement.refinement() as kotlin.Boolean
}

@JvmName("greater")
@Suppress(
    "UNCHECKED_CAST",
    "USELESS_CAST",
    "EXTENSION_SHADOWED_BY_MEMBER",
    "UNUSED_PARAMETER"
)
fun <A : Number> A.greater(ORD: Order<A>, min: A): Either<NonEmptyList<RefinedPredicateException>,
    A> = arrow.core.Either.greater<A>(ORD, min).run {
  this@greater.greater() as
    arrow.core.Either<arrow.core.NonEmptyList<arrow.validation.RefinedPredicateException>, A>
}

@JvmName("greater")
@Suppress(
    "UNCHECKED_CAST",
    "USELESS_CAST",
    "EXTENSION_SHADOWED_BY_MEMBER",
    "UNUSED_PARAMETER"
)
fun <A : Number, B> A.greater(
  ORD: Order<A>,
  min: A,
  f: Function1<A, B>
): Either<NonEmptyList<RefinedPredicateException>, B> = arrow.core.Either.greater<A>(ORD, min).run {
  this@greater.greater<B>(f) as
    arrow.core.Either<arrow.core.NonEmptyList<arrow.validation.RefinedPredicateException>, B>
}

@JvmName("invalidValueMsg")
@Suppress(
    "UNCHECKED_CAST",
    "USELESS_CAST",
    "EXTENSION_SHADOWED_BY_MEMBER",
    "UNUSED_PARAMETER"
)
fun <A : Number> invalidValueMsg(
  ORD: Order<A>,
  min: A,
  a: A
): String = arrow.core.Either
   .greater<A>(ORD, min)
   .invalidValueMsg(a) as kotlin.String

@JvmName("ORD")
@Suppress(
    "UNCHECKED_CAST",
    "USELESS_CAST",
    "EXTENSION_SHADOWED_BY_MEMBER",
    "UNUSED_PARAMETER"
)
fun <A : Number> ORD(ORD: Order<A>, min: A): Order<A> = arrow.core.Either
   .greater<A>(ORD, min)
   .ORD() as arrow.typeclasses.Order<A>

@JvmName("min")
@Suppress(
    "UNCHECKED_CAST",
    "USELESS_CAST",
    "EXTENSION_SHADOWED_BY_MEMBER",
    "UNUSED_PARAMETER"
)
fun <A : Number> min(ORD: Order<A>, min: A): A = arrow.core.Either
   .greater<A>(ORD, min)
   .min() as A

@Suppress(
    "UNCHECKED_CAST",
    "NOTHING_TO_INLINE"
)
inline fun <A : Number> Companion.greater(ORD: Order<A>, min: A): EitherGreater<A> = object :
    arrow.validation.refinedTypes.numeric.EitherGreater<A> { override fun ORD():
    arrow.typeclasses.Order<A> = ORD

  override fun min(): A = min }