package arrow.validation.refinedTypes.numeric.either.greaterEqual

import arrow.core.Either
import arrow.core.Either.Companion
import arrow.core.NonEmptyList
import arrow.typeclasses.Order
import arrow.validation.RefinedPredicateException
import arrow.validation.refinedTypes.numeric.EitherGreaterEqual
import kotlin.Boolean
import kotlin.Function1
import kotlin.Number
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

@JvmName("refinement")
@Suppress(
    "UNCHECKED_CAST",
    "USELESS_CAST",
    "EXTENSION_SHADOWED_BY_MEMBER",
    "UNUSED_PARAMETER"
)
fun <A : Number> A.refinement(ORD: Order<A>, min: A): Boolean =
    arrow.core.Either.greaterEqual<A>(ORD, min).run {
  this@refinement.refinement() as kotlin.Boolean
}

@JvmName("invalidValueMsg")
@Suppress(
    "UNCHECKED_CAST",
    "USELESS_CAST",
    "EXTENSION_SHADOWED_BY_MEMBER",
    "UNUSED_PARAMETER"
)
fun <A : Number> invalidValueMsg(
  ORD: Order<A>,
  min: A,
  a: A
): String = arrow.core.Either
   .greaterEqual<A>(ORD, min)
   .invalidValueMsg(a) as kotlin.String

@JvmName("greaterEqual")
@Suppress(
    "UNCHECKED_CAST",
    "USELESS_CAST",
    "EXTENSION_SHADOWED_BY_MEMBER",
    "UNUSED_PARAMETER"
)
fun <A : Number> A.greaterEqual(ORD: Order<A>, min: A):
    Either<NonEmptyList<RefinedPredicateException>, A> =
    arrow.core.Either.greaterEqual<A>(ORD, min).run {
  this@greaterEqual.greaterEqual() as
    arrow.core.Either<arrow.core.NonEmptyList<arrow.validation.RefinedPredicateException>, A>
}

@JvmName("greaterEqual")
@Suppress(
    "UNCHECKED_CAST",
    "USELESS_CAST",
    "EXTENSION_SHADOWED_BY_MEMBER",
    "UNUSED_PARAMETER"
)
fun <A : Number, B> A.greaterEqual(
  ORD: Order<A>,
  min: A,
  f: Function1<A, B>
): Either<NonEmptyList<RefinedPredicateException>, B> =
    arrow.core.Either.greaterEqual<A>(ORD, min).run {
  this@greaterEqual.greaterEqual<B>(f) as
    arrow.core.Either<arrow.core.NonEmptyList<arrow.validation.RefinedPredicateException>, B>
}

@JvmName("ORD")
@Suppress(
    "UNCHECKED_CAST",
    "USELESS_CAST",
    "EXTENSION_SHADOWED_BY_MEMBER",
    "UNUSED_PARAMETER"
)
fun <A : Number> ORD(ORD: Order<A>, min: A): Order<A> = arrow.core.Either
   .greaterEqual<A>(ORD, min)
   .ORD() as arrow.typeclasses.Order<A>

@JvmName("min")
@Suppress(
    "UNCHECKED_CAST",
    "USELESS_CAST",
    "EXTENSION_SHADOWED_BY_MEMBER",
    "UNUSED_PARAMETER"
)
fun <A : Number> min(ORD: Order<A>, min: A): A = arrow.core.Either
   .greaterEqual<A>(ORD, min)
   .min() as A

@Suppress(
    "UNCHECKED_CAST",
    "NOTHING_TO_INLINE"
)
inline fun <A : Number> Companion.greaterEqual(ORD: Order<A>, min: A): EitherGreaterEqual<A> =
    object : arrow.validation.refinedTypes.numeric.EitherGreaterEqual<A> { override fun ORD():
    arrow.typeclasses.Order<A> = ORD

  override fun min(): A = min }